/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import agent.main.AgentShim;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.internal.Java15AgentInitializationCallBack;
import com.wily.introscope.agent.runtime.java.enterprise.Java2PostConstructionInitializationHelper;
import com.wily.introscope.agent.transformer.IInstrumentationAcceptor;
import com.wily.introscope.agent.transformer.OnInstrumentationAcceptedCallback;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.agent.upgrade.merge.MergeAdministrator;
import com.wily.introscope.agent.upgrade.merge.MergeException;
import com.wily.introscope.agent.upgrade.merge.StatusErrorLogger;
import com.wily.introscope.api.instrument.AClassRedefinitionDelegate;
import com.wily.introscope.api.instrument.ClassFileTransformerImpl;
import com.wily.introscope.api.instrument.ContinuousRetransformer;
import com.wily.introscope.api.instrument.JBossTransformer;
import com.wily.introscope.api.instrument.JavaRedefineRetransformBean;
import com.wily.introscope.properties.IntroscopePropertyUtilities;
import com.wily.util.feedback.DefaultValidationFeedbackChannel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.IValidationFeedbackChannel;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class JavaAgent {
    static final ClassFileTransformer sTransformer = new ClassFileTransformerImpl();
    static boolean sTransformerAdded = false;
    public static CountDownLatch jbossConfigured = null;

    public static boolean validate(String agentArgs, Instrumentation instrumentation, String updateDir, String configDir, String mergeRules, String upgradeStatusLog) {
        StatusErrorLogger statusLogger = null;
        try {
            statusLogger = new StatusErrorLogger(upgradeStatusLog);
        }
        catch (IOException iOException) {
            return false;
        }
        JavaAgent.retrieveInfoFromManifest(statusLogger);
        try {
            MergeAdministrator.doMerge(updateDir, configDir, mergeRules, false);
        }
        catch (MergeException e) {
            statusLogger.error(e.getMessage());
            statusLogger.save();
            return false;
        }
        boolean result = JavaAgent.initializeAgent(agentArgs, instrumentation, true, statusLogger);
        statusLogger.save();
        return result;
    }

    private static void retrieveInfoFromManifest(StatusErrorLogger statusLogger) {
        String fileName = JavaAgent.getManifestUrl();
        if (fileName == null) {
            statusLogger.info("Failed to retrieve Agent version information");
            return;
        }
        try {
            Manifest manifest = new Manifest(new URL(fileName).openStream());
            Attributes attribs = manifest.getMainAttributes();
            String jar = attribs.getValue("Boot-Class-Path");
            String name = attribs.getValue("com-wily-Name");
            String release = attribs.getValue("com-wily-Release");
            String build = attribs.getValue("com-wily-Build");
            statusLogger.info("Artifact: " + jar + " name: " + name + " release: " + release + " build: " + build);
        }
        catch (Exception exception) {}
    }

    private static String getManifestUrl() {
        int marker;
        String manifestUrlString = null;
        Class<JavaAgent> clazz = JavaAgent.class;
        String classFileName = "/" + clazz.getName().replace('.', '/') + ".class";
        URL url = clazz.getResource(classFileName);
        String urlString = url.toString();
        if (urlString.startsWith("jar:") && (marker = urlString.indexOf("!")) != -1) {
            manifestUrlString = String.valueOf(urlString.substring(0, marker + 1)) + "/META-INF/MANIFEST.MF";
        }
        return manifestUrlString;
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        System.setProperty("com.wily.introscope.agent.starter", "premain");
        String monitor = System.getenv("CA_APM_MONITORING_ENABLED");
        if (monitor != null && !Boolean.parseBoolean(monitor)) {
            System.out.println("Monitoring disabled by environment variable CA_APM_MONITORING_ENABLED, CA APM AGENT Exiting");
            return;
        }
        JavaAgent.initializeAgent(agentArgs, instrumentation, false, null);
        try {
            AgentShim.kAgent = com.wily.introscope.agent.AgentShim.getAgent();
        }
        catch (AgentNotAvailableException e) {
            com.wily.introscope.agent.AgentShim.handleError("Agent Unavailable", e);
        }
    }

    private static boolean initializeAgent(String agentArgs, final Instrumentation instrumentation, boolean validate, StatusErrorLogger statusLogger) {
        boolean success = true;
        final JavaRedefineRetransformBean statusOfTransformation = JavaRedefineRetransformBean.getJavaRedefineRetransformBeanInfo(agentArgs, instrumentation);
        AInstrumentationHelper.setValidate(validate);
        if (validate) {
            AInstrumentationHelper.setValidationFeedbackChannel(new DefaultValidationFeedbackChannel());
        }
        AInstrumentationHelper.initialize(instrumentation, new OnInstrumentationAcceptedCallback(){

            @Override
            public void onInstrumentationAccepted(IInstrumentationAcceptor accepter) {
                if (accepter instanceof IDynamicInstrumentationTransformer) {
                    IAgent agent = accepter.getAgent();
                    IDynamicInstrumentationTransformer iService = (IDynamicInstrumentationTransformer)((Object)accepter);
                    if (iService != null) {
                        AClassRedefinitionDelegate classRedefinitionDelegate = JavaAgent.getDelegate(instrumentation, statusOfTransformation, agent);
                        if (classRedefinitionDelegate != null) {
                            iService.setClassRedefinitionDelegate(classRedefinitionDelegate);
                        } else {
                            agent.IAgent_getModuleFeedback().warn("The redefinition delegate is not set");
                        }
                    } else {
                        agent.IAgent_getModuleFeedback().warn("The default Dynamic InstrumentationTransformer has not been found");
                    }
                    agent.IAgent_getModuleFeedback().trace("Adding java level transformer");
                    JavaAgent.addTransformer(instrumentation, statusOfTransformation, agent.IAgent_getModuleFeedback());
                    if (iService != null) {
                        agent.IAgent_getModuleFeedback().trace("Executing Premain transformation");
                        iService.executeBootstrapTransform();
                    } else {
                        agent.IAgent_getModuleFeedback().trace("The default Dynamic InstrumentationTransformer has not been found");
                    }
                    agent.IAgent_getModuleFeedback().trace("Done with premain.");
                }
            }
        });
        try {
            Java2PostConstructionInitializationHelper.initialize(new Java15AgentInitializationCallBack(true));
        }
        catch (Exception exception) {
            success = false;
        }
        if (agentArgs != null && agentArgs.startsWith("collector:")) {
            int beginIndex = agentArgs.indexOf(58) + 1;
            com.wily.introscope.agent.AgentShim.sRemoteAgentArgs = agentArgs.substring(beginIndex);
        }
        com.wily.introscope.agent.AgentShim.ProbeBuilderEntryPoint_initializeAgentShim(null);
        if (validate) {
            String[] errors;
            String[] infos;
            IValidationFeedbackChannel channel = AInstrumentationHelper.getValidationFeedbackChannel();
            String[] stringArray = infos = channel.getInfos();
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                String info = stringArray[n2];
                statusLogger.info(info);
                ++n2;
            }
            success = !channel.hasError();
            String[] stringArray2 = errors = channel.getErrors();
            int n3 = errors.length;
            n = 0;
            while (n < n3) {
                String error = stringArray2[n];
                statusLogger.error(error);
                ++n;
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        String agentOptionsPath = "/tmp/ca-apm-java-agent.options";
        if (agentArgs.equals(agentOptionsPath)) {
            agentArgs = null;
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(agentOptionsPath));
                String line = bufferedReader.readLine();
                bufferedReader.close();
                if (line != null) {
                    agentArgs = line;
                }
            }
            catch (IOException ioe) {
                System.out.println("CA APM: Exception reading provided agentOptions. Agent Loading Terminated. Please correct agent options and redeploy UMA");
                ioe.printStackTrace();
                return;
            }
        }
        System.out.println("CA APM: Initiated Java Agent");
        IntroscopePropertyUtilities.loadSystemProperties(agentArgs);
        System.setProperty("com.wily.introscope.agent.starter", "agentmain");
        String monitor = System.getenv("CA_APM_MONITORING_ENABLED");
        if (monitor == null) {
            if (System.getProperty("com.wily.autoattach.mode").equals("whitelist")) {
                return;
            }
        } else if (!Boolean.parseBoolean(monitor)) {
            System.out.println("Monitoring disabled by environment variable CA_APM_MONITORING_ENABLED, CA APM AGENT Exiting");
            return;
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {}
        if (System.getProperty("jboss.modules.system.pkgs") != null) {
            JavaAgent.configureJBoss(instrumentation);
        }
        if (Boolean.parseBoolean(System.getProperty("com.wily.introscope.defer.instrumentation", "false"))) {
            System.out.println("CA APM: Deferring Load Time Transformation");
            ClassFileTransformerImpl.agentMain = true;
        }
        JavaAgent.initializeAgentMain(agentArgs, instrumentation);
        ContinuousRetransformer retransformer = null;
        try {
            retransformer = new ContinuousRetransformer(instrumentation, com.wily.introscope.agent.AgentShim.getAgent(), 2, 200);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
        Class<com.wily.introscope.agent.AgentShim> clazz = com.wily.introscope.agent.AgentShim.class;
        synchronized (com.wily.introscope.agent.AgentShim.class) {
            if (!sTransformerAdded) {
                System.out.println("CA APM: Adding Transformer");
                instrumentation.addTransformer(sTransformer, true);
                sTransformerAdded = true;
            }
            // ** MonitorExit[var5_6] (shouldn't be in output)
            if (retransformer != null) {
                retransformer.setName("AgentContinuousRetransformer");
                retransformer.setDaemon(true);
                retransformer.start();
            }
            return;
        }
    }

    private static boolean initializeAgentMain(String agentArgs, final Instrumentation instrumentation) {
        boolean success = true;
        final JavaRedefineRetransformBean statusOfTransformation = JavaRedefineRetransformBean.getJavaRedefineRetransformBeanInfo(agentArgs, instrumentation);
        AInstrumentationHelper.initialize(instrumentation, new OnInstrumentationAcceptedCallback(){

            @Override
            public void onInstrumentationAccepted(IInstrumentationAcceptor accepter) {
                if (accepter instanceof IDynamicInstrumentationTransformer) {
                    IAgent agent = accepter.getAgent();
                    IDynamicInstrumentationTransformer iService = (IDynamicInstrumentationTransformer)((Object)accepter);
                    if (iService != null) {
                        AClassRedefinitionDelegate classRedefinitionDelegate = JavaAgent.getDelegate(instrumentation, statusOfTransformation, agent);
                        if (classRedefinitionDelegate != null) {
                            iService.setClassRedefinitionDelegate(classRedefinitionDelegate);
                        } else {
                            agent.IAgent_getModuleFeedback().warn("The redefinition delegate is not set");
                        }
                        agent.IAgent_getModuleFeedback().trace("Registering Bootstrap Transformer");
                        iService.registerBootstrapTransformer();
                    } else {
                        agent.IAgent_getModuleFeedback().warn("The default Dynamic InstrumentationTransformer has not been found");
                    }
                    agent.IAgent_getModuleFeedback().trace("Done with agentmain.");
                }
            }
        });
        try {
            Java2PostConstructionInitializationHelper.initialize(new Java15AgentInitializationCallBack(false));
        }
        catch (Exception exception) {
            success = false;
        }
        com.wily.introscope.agent.AgentShim.ProbeBuilderEntryPoint_initializeAgentShim(null);
        return success;
    }

    private static void configureJBoss(Instrumentation instrumentation) {
        JBossTransformer transformer = new JBossTransformer();
        ArrayList<Class> classList = new ArrayList<Class>();
        int retransformCount = 0;
        instrumentation.addTransformer(transformer, true);
        Class[] classArray = instrumentation.getAllLoadedClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            if (clazz.getName().equals("org.jboss.modules.Module")) {
                ++retransformCount;
                classList.add(clazz);
            }
            ++n2;
        }
        jbossConfigured = new CountDownLatch(retransformCount);
        for (Class clazz : classList) {
            try {
                instrumentation.retransformClasses(clazz);
            }
            catch (UnmodifiableClassException unmodifiableClassException) {
                System.out.println("CA APM: Can't retransform JBoss modules");
                --retransformCount;
                jbossConfigured.countDown();
            }
        }
        System.out.println("CA APM: Waiting for JBoss to be configured");
        try {
            jbossConfigured.await(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("CA APM: Wait for JBoss configuration interrupted");
        }
        System.out.println("CA APM: Jboss configuration applied " + retransformCount + " times");
        instrumentation.removeTransformer(transformer);
    }

    private static boolean addTransformer(Instrumentation i, JavaRedefineRetransformBean status, IModuleFeedbackChannel feedback) {
        try {
            if (status.fCanRetransform && status.fSuggestRetransform) {
                feedback.info("Try and add transformer that can retransform classes");
                Method instrumentationAddTransformer = i.getClass().getMethod("addTransformer", ClassFileTransformer.class, Boolean.TYPE);
                instrumentationAddTransformer.invoke((Object)i, sTransformer, Boolean.TRUE);
                return true;
            }
        }
        catch (SecurityException e) {
            feedback.debug("Unable to add class retransformer: " + e.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            feedback.debug("Class retransformation not supported by JVM");
        }
        catch (IllegalArgumentException e) {
            feedback.debug("Unable to add class retransformer: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            feedback.debug("Unable to add class retransformer: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            feedback.debug("Unable to add class retransformer: " + e.getMessage());
        }
        catch (ClassCastException e) {
            feedback.debug("Unable to add class retransformer: " + e.getMessage());
        }
        feedback.info("Try and add transformer using java5 API");
        i.addTransformer(sTransformer);
        return false;
    }

    private static AClassRedefinitionDelegate getDelegate(Instrumentation instrumentation, JavaRedefineRetransformBean status, IAgent agent) {
        String delegateClassName = "com.wily.introscope.api.instrument.AClassRedefinitionDelegate";
        delegateClassName = status.fPropertyForceRetransformation ? "com.wily.introscope.api.instrument.AClassRetransformationDelegate" : (status.fPropertyForceRedefinition ? "com.wily.introscope.api.instrument.AClassRedefinitionDelegate" : (status.fCanRetransform && status.fSuggestRetransform ? "com.wily.introscope.api.instrument.AClassRetransformationDelegate" : "com.wily.introscope.api.instrument.AClassRedefinitionDelegate"));
        agent.IAgent_getModuleFeedback().info("Using delegate class =" + delegateClassName);
        try {
            Class<?> delegateClass = Class.forName(delegateClassName);
            try {
                Constructor<?> instrumentationAddTransformer = delegateClass.getConstructor(Instrumentation.class, IAgent.class);
                try {
                    Object result = instrumentationAddTransformer.newInstance(instrumentation, agent);
                    return (AClassRedefinitionDelegate)result;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    agent.IAgent_getModuleFeedback().error("Unexpected argument exception when instatiating delegate class " + delegateClassName);
                }
                catch (InstantiationException instantiationException) {
                    agent.IAgent_getModuleFeedback().error("Unable to instatiate delegate class " + delegateClassName);
                }
                catch (IllegalAccessException illegalAccessException) {
                    agent.IAgent_getModuleFeedback().error("Unable to access instatiation for delegate class " + delegateClassName);
                }
                catch (InvocationTargetException invocationTargetException) {
                    agent.IAgent_getModuleFeedback().error("Exception when instatiating delegate class " + delegateClassName);
                }
            }
            catch (SecurityException securityException) {
                agent.IAgent_getModuleFeedback().error("Unable to access delegate class " + delegateClassName);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                agent.IAgent_getModuleFeedback().error("Unable to find constructor for delegate class " + delegateClassName);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            agent.IAgent_getModuleFeedback().error("Unable to find delegate class " + delegateClassName);
        }
        return null;
    }
}

