/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.history;

import com.wily.util.feedback.ApplicationFeedback;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedCharacterEncoding;
import com.wily.util.io.ExtendedFile;
import com.wily.wilyassert.Assertion;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public class HistoryHelper {
    private static final int kHistoryStackDepth = 5;
    private final Vector fStacks;
    private final ExtendedFile fHistoryFile;
    private final InputStreamReader fReader;
    private final OutputStreamWriter fWriter;
    private final IModuleFeedbackChannel fFeedbackChannel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistoryHelper(ExtendedFile historyFile, IModuleFeedbackChannel feedbackChannel) throws IOException {
        Assertion.wilyAssert(historyFile != null, "history file cannot be null");
        Assertion.wilyAssert(feedbackChannel != null, "feedback channel cannot be null");
        this.fStacks = new Vector();
        this.fFeedbackChannel = feedbackChannel;
        this.fHistoryFile = historyFile;
        boolean fileIsNew = false;
        if (!this.fHistoryFile.exists()) {
            fileIsNew = true;
            this.fHistoryFile.createFile();
        }
        this.fReader = ExtendedCharacterEncoding.getUTF8InputStreamReader(new FileInputStream(this.fHistoryFile.getFile()));
        OutputStreamWriter writer = null;
        try {
            if (!fileIsNew) {
                this.fillStacks();
            }
            writer = ExtendedCharacterEncoding.getUTF8OutputStreamWriter(new FileOutputStream(this.fHistoryFile.getFile()));
        }
        finally {
            if (writer == null) {
                this.fReader.close();
            }
        }
        this.fWriter = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillStacks() throws IOException {
        String stackTitle = "";
        int i = -1;
        BufferedReader reader = new BufferedReader(this.fReader);
        String line = reader.readLine();
        try {
            while (line != null) {
                int index = line.indexOf(".");
                if (index == -1) {
                    break;
                }
                String newTitle = line.substring(0, index);
                String value = line.substring(Math.min(index + 1, line.length()), line.length());
                if (!newTitle.equals(stackTitle)) {
                    stackTitle = newTitle;
                    this.fStacks.add(new HistoryStack(newTitle));
                    ++i;
                }
                ((HistoryStack)this.fStacks.elementAt(i)).insertElementAt(value, 0);
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void emptyStacks() throws IOException {
        BufferedWriter writer = new BufferedWriter(this.fWriter);
        try {
            Iterator i = this.fStacks.iterator();
            while (i.hasNext()) {
                HistoryStack stack = (HistoryStack)i.next();
                stack = (HistoryStack)stack.clone();
                String stackTitle = stack.getTitle();
                while (!stack.empty()) {
                    String value = (String)stack.pop();
                    String pair = stackTitle + "." + value;
                    writer.write(pair, 0, pair.length());
                    writer.newLine();
                }
            }
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    private HistoryStack getHistoryStackByName(String stackTitle) {
        HistoryStack result = null;
        Iterator i = this.fStacks.iterator();
        while (i.hasNext()) {
            HistoryStack stack = (HistoryStack)i.next();
            String title = stack.getTitle();
            if (!title.equals(stackTitle)) continue;
            result = stack;
            break;
        }
        return result;
    }

    public synchronized void clear(String stackTitle) {
        Assertion.wilyAssert(stackTitle != null, "stack title must not be null");
        HistoryStack stack = this.getHistoryStackByName(stackTitle);
        if (stack != null) {
            stack.clear();
        }
    }

    public synchronized String[] pop(String stackTitle) {
        Assertion.wilyAssert(stackTitle != null, "stack title must not be null");
        HistoryStack stack = this.getHistoryStackByName(stackTitle);
        if (stack == null) {
            return new String[0];
        }
        HistoryStack newStack = (HistoryStack)stack.clone();
        Vector result = new Vector();
        for (int i = 0; i < 5 && !newStack.empty(); ++i) {
            result.add(newStack.pop());
        }
        Object[] ret = new String[result.size()];
        result.copyInto(ret);
        return ret;
    }

    public synchronized void push(String stackTitle, String value) {
        HistoryStack stack = this.getHistoryStackByName(stackTitle);
        if (stack == null) {
            stack = new HistoryStack(stackTitle);
            this.fStacks.add(stack);
        }
        if (stack.contains(value)) {
            int i = stack.indexOf(value);
            stack.removeElementAt(i);
        }
        stack.push(value);
    }

    public void flushToFile() throws IOException {
        this.emptyStacks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.fWriter.close();
        }
        finally {
            this.fReader.close();
        }
    }

    public static void main(String[] args) {
        System.out.println("Invoking HistoryHelper stub driver");
        ExtendedFile file = new ExtendedFile("d:\\tmp\\history.test");
        ApplicationFeedback channel = new ApplicationFeedback("dbm", false);
        HistoryHelper manager = null;
        try {
            manager = new HistoryHelper(file, channel);
            manager.push("host", "www");
            manager.push("host", "loopback");
            manager.push("port", "8808");
            manager.push("host", "token");
            manager.push("port", "55");
            manager.push("host", "tweak");
            manager.push("host", "rubin");
            manager.flushToFile();
            manager = null;
            HistoryHelper manager2 = new HistoryHelper(file, channel);
            String[] hosts = manager2.pop("host");
            String[] user = manager2.pop("user");
            String[] port = manager2.pop("port");
            System.out.println("hosts length: " + hosts.length);
            System.out.println("port length: " + port.length);
            System.out.println("user length: " + user.length);
            for (int i = 0; i < hosts.length; ++i) {
                System.out.println(hosts[i]);
            }
            for (int j = 0; j < user.length; ++j) {
                System.out.println(user[j]);
            }
            for (int k = 0; k < port.length; ++k) {
                System.out.println(port[k]);
            }
            System.out.flush();
            manager2.flushToFile();
        }
        catch (IOException ie) {
            System.out.println("couldn't initialize history helper" + ie.getMessage());
            System.exit(1);
        }
    }

    private class HistoryStack
    extends Stack {
        private static final long serialVersionUID = 3513708565380015498L;
        private String fTitle;

        public HistoryStack(String title) {
            this.fTitle = title;
        }

        public String getTitle() {
            return this.fTitle;
        }
    }
}

