/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.correlation.WSClientCorrelationTracer;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.DynamicParamsProcessor;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.WSFlexibleUtil;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class WSClientFlexibleStartCorrelationTracer
extends WSClientCorrelationTracer {
    private static final String kReservedWSDMTransactionContext = "Reserved WSDM Transaction Context";
    private DynamicParamsProcessor paramsSchema;
    private String dynamicParamSyntax = null;
    private HashMap dynamicProperties = null;

    public WSClientFlexibleStartCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
    }

    private void listHeaders(Object servletRequestImpl) throws Exception {
        ArrayList headerValuesArrayList = (ArrayList)WSMUtils.invokeMethodOnObject(servletRequestImpl, "getHeaderValuesArrayList");
        ArrayList headerNamesArrayList = (ArrayList)WSMUtils.invokeMethodOnObject(servletRequestImpl, "getHeaderNamesArrayList");
        WSMUtils.getLogger().debug("WSClientFlexibleStartCorrelationTracer Headers as name/value pairs)");
        int i = 0;
        while (i < headerNamesArrayList.size()) {
            String value = new String((byte[])headerValuesArrayList.get(i));
            WSMUtils.getLogger().debug(String.valueOf((String)headerNamesArrayList.get(i)) + " " + value);
            ++i;
        }
    }

    private final String getDynamicParamsString(String formattedName) throws Exception {
        String formattingName = null;
        int startIndex = formattedName.indexOf("{DynamicParams");
        if (startIndex == -1) {
            throw new Exception("'{' is missing in trace param schema. ");
        }
        formattingName = formattedName.substring(startIndex);
        int finishIndex = formattingName.indexOf("}");
        if (finishIndex == -1) {
            throw new Exception("'}' is missing in trace param schema. ");
        }
        formattingName = formattingName.substring("{DynamicParams".length(), finishIndex);
        return formattingName;
    }

    private final void initialiseParams(String name, InvocationData data, String correlationString) throws Exception {
        if (this.dynamicParamSyntax == null) {
            String dynamicParamSyntax = this.getDynamicParamsString(name);
            this.paramsSchema = DynamicParamsProcessor.getInstance(this.getAgent().IAgent_getModuleFeedback(), dynamicParamSyntax, correlationString);
            this.dynamicProperties = this.paramsSchema.processDynamicParams(data);
        }
    }

    private void traceSOAPHeader(InvocationData data) {
        if (WSMUtils.getLogger().isDebugEnabled()) {
            try {
                Object stub = data.getInvocationParameterAsObject(0);
                stub = WSMUtils.invokeMethodOnObject(stub, "getMessage");
                stub = WSMUtils.invokeMethodOnObject(stub, "getSOAPPart");
                stub = WSMUtils.invokeMethodOnObject(stub, "getEnvelope");
                stub = WSMUtils.invokeMethodOnObject(stub, "getHeader");
                WSMUtils.getLogger().debug("WSClientFlexibleStartCorrelationTracer traceSOAPHeader");
                Class<?> clazz = stub.getClass();
                Method method = clazz.getMethod("getChildElements", new Class[0]);
                method.setAccessible(true);
                Iterator it = (Iterator)method.invoke(stub, new Object[0]);
                while (it.hasNext()) {
                    stub = it.next();
                    clazz = stub.getClass();
                    method = clazz.getMethod("getElementName", new Class[0]);
                    method.setAccessible(true);
                    Object elementVal = method.invoke(stub, new Object[0]);
                    String localName = (String)WSMUtils.invokeMethodOnObject(elementVal, "getLocalName");
                    String URI2 = (String)WSMUtils.invokeMethodOnObject(elementVal, "getURI");
                    String prefix = (String)WSMUtils.invokeMethodOnObject(elementVal, "getPrefix");
                    WSMUtils.getLogger().debug("localName=" + localName + " URI=" + URI2 + " prefix=" + prefix);
                }
            }
            catch (Throwable t) {
                WSMUtils.getLogger().error("WSClientFlexibleStartCorrelationTracertraceSOAPHeader exception " + WSMUtils.dumpStackTrace(t));
            }
        }
    }

    @Override
    public void ITracer_startTrace(int index, InvocationData data) {
        try {
            WSMUtils.refreshLogLevels();
            if (WSMUtils.getLogger().isDebugEnabled()) {
                WSMUtils.getLogger().debug("WSClientFlexibleStartCorrelationTracer ITracer_startTrace data =" + data + " data.getInvocationObject()=" + data.getInvocationObject() + " agent=" + this.getAgent() + " data.getClass()=" + data.getClass());
            }
            String correlationString = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
            String formattedName = WSFlexibleUtil.processClientString(this.getNameParameter(), correlationString);
            correlationString = correlationString.replaceAll("(?: )+", "SPACEQQ");
            this.initialiseParams(formattedName, data, correlationString);
            WSFlexibleUtil.setCorrelationId(this.dynamicProperties);
        }
        catch (Throwable t) {
            WSMUtils.getLogger().error("WSClientFlexibleStartCorrelationTracer ITracer_startTrace exception " + WSMUtils.dumpStackTrace(t));
        }
    }
}

