/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback.backend.log4j;

import com.wily.org.apache.log4j.Appender;
import com.wily.org.apache.log4j.BasicConfigurator;
import com.wily.org.apache.log4j.ConsoleAppender;
import com.wily.org.apache.log4j.Layout;
import com.wily.org.apache.log4j.Level;
import com.wily.org.apache.log4j.LogManager;
import com.wily.org.apache.log4j.Logger;
import com.wily.org.apache.log4j.PatternLayout;
import com.wily.org.apache.log4j.Priority;
import com.wily.org.apache.log4j.PropertyConfigurator;
import com.wily.util.feedback.Log4JSeverityLevel;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.feedback.backend.IFeedbackBackend;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;

public class Log4JBackend
implements IFeedbackBackend {
    private static final IFeedbackBackend sSingleton = new Log4JBackend();
    private static final String kLog4JPropertyPrefix = "log4j";

    public static IFeedbackBackend getLog4JBackend() {
        return sSingleton;
    }

    private Log4JBackend() {
    }

    public Object getLoggerByName(String name) {
        Logger l = LogManager.getLogger((String)name);
        return l;
    }

    public void setGlobalDefaults(String defaultOutputTarget) {
        String log4JTarget = Log4JBackend.mapLog4JTarget(defaultOutputTarget);
        PatternLayout layout = new PatternLayout("%d{M/dd/yy hh:mm:ss a z} [%-3p] [%c] %m%n");
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)layout, log4JTarget);
        BasicConfigurator.configure((Appender)consoleAppender);
        Logger.getRootLogger().setLevel((Level)Log4JSeverityLevel.INFO);
    }

    private static String mapLog4JTarget(String defaultOutputTarget) {
        if (defaultOutputTarget.equals("DefaultSystemOut")) {
            return "System.out";
        }
        if (defaultOutputTarget.equals("DefaultSystemError")) {
            return "System.err";
        }
        return "System.err";
    }

    public void setGlobalConfiguration(Properties props) {
        this.ensureLogDirectory(props);
        PropertyConfigurator.configure((Properties)props);
    }

    private void ensureLogDirectory(Properties props) {
        String kLogfilePropKey = "log4j.appender.logfile.File";
        String logfile = props.getProperty("log4j.appender.logfile.File");
        if (logfile != null) {
            try {
                File file = new File(logfile).getParentFile();
                if (file != null && !file.exists()) {
                    file.mkdirs();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void configureFromProperties(Properties properties) {
        this.ensureLogDirectory(properties);
        PropertyConfigurator.configure((Properties)properties);
    }

    public boolean containsLoggingConfiguration(Properties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String attribute = (String)e.nextElement();
            if (attribute.indexOf(kLog4JPropertyPrefix) < 0) continue;
            return true;
        }
        return false;
    }

    private Logger getLoggerFromObjectCookie(Object cookie) {
        return (Logger)cookie;
    }

    public void log(Object logger, SeverityLevel level, Object message, Throwable t) {
        this.getLoggerFromObjectCookie(logger).log((Priority)Log4JSeverityLevel.getLog4JSeverityLevel(level), message, t);
    }

    public SeverityLevel getEffectiveLevel(Object logger) {
        Level level = this.getLoggerFromObjectCookie(logger).getEffectiveLevel();
        return Log4JSeverityLevel.getSeverityLevelFromLog4J(level);
    }

    public SeverityLevel getLevel(Object logger) {
        Level level = this.getLoggerFromObjectCookie(logger).getLevel();
        return Log4JSeverityLevel.getSeverityLevelFromLog4J(level);
    }

    public void setLevel(Object logger, SeverityLevel level) {
        this.getLoggerFromObjectCookie(logger).setLevel((Level)Log4JSeverityLevel.getLog4JSeverityLevel(level));
    }

    public boolean isEnabledFor(Object logger, SeverityLevel level) {
        return this.getLoggerFromObjectCookie(logger).isEnabledFor((Priority)Log4JSeverityLevel.getLog4JSeverityLevel(level));
    }

    public void setRootLevel(SeverityLevel level) {
        LogManager.getRootLogger().setLevel((Level)Log4JSeverityLevel.getLog4JSeverityLevel(level));
    }

    public boolean isRootEnabledFor(SeverityLevel level) {
        return LogManager.getRootLogger().isEnabledFor((Priority)Log4JSeverityLevel.getLog4JSeverityLevel(level));
    }

    public String getName(Object logger) {
        return this.getLoggerFromObjectCookie(logger).getName();
    }
}

