/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.wilyassert.Assertion;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CoalescedListModel
extends AbstractListModel {
    private static final long serialVersionUID = -6740801465887407716L;
    private ListModelsOrderedList fSubModels = new ListModelsOrderedList();
    private ListDataListener fCoalescedListDataListener = new CoalescedListDataListener();

    public synchronized void addListModel(ListModel model) {
        this.fSubModels.addListModel(model);
        model.addListDataListener(this.fCoalescedListDataListener);
    }

    public synchronized void removeListModel(ListModel model) {
        model.removeListDataListener(this.fCoalescedListDataListener);
        this.fSubModels.removeListModel(model);
    }

    public int getSize() {
        return this.fSubModels.getTotalSize();
    }

    public Object getElementAt(int index) {
        ListModel targetModel = this.fSubModels.getListModelAtOffset(index);
        int adjustedIndex = index - this.fSubModels.getListModelOffset(targetModel);
        return targetModel.getElementAt(adjustedIndex);
    }

    protected void fireIntervalAdded(Object source, int index0, int index1) {
        super.fireIntervalAdded(source, index0, index1);
    }

    protected void fireIntervalRemoved(Object source, int index0, int index1) {
        super.fireIntervalRemoved(source, index0, index1);
    }

    protected void fireContentsChanged(Object source, int index0, int index1) {
        super.fireContentsChanged(source, index0, index1);
    }

    private class ListModelsOrderedList {
        private Vector fListModels = new Vector();

        public void addListModel(ListModel model) {
            this.fListModels.add(model);
        }

        public void removeListModel(ListModel model) {
            this.fListModels.remove(model);
        }

        public int getTotalSize() {
            int totalSize = 0;
            Enumeration models = this.fListModels.elements();
            while (models.hasMoreElements()) {
                ListModel aModel = (ListModel)models.nextElement();
                totalSize += aModel.getSize();
            }
            return totalSize;
        }

        public int getListModelOffset(ListModel targetModel) {
            int offset = 0;
            boolean targetFound = false;
            Enumeration models = this.fListModels.elements();
            while (models.hasMoreElements() && !targetFound) {
                ListModel aModel = (ListModel)models.nextElement();
                if (aModel == targetModel) {
                    targetFound = true;
                    continue;
                }
                offset += aModel.getSize();
            }
            Assertion.wilyAssert(offset < this.getTotalSize());
            return offset;
        }

        public ListModel getListModelAtOffset(int offset) {
            int runningOffset = 0;
            ListModel targetModel = null;
            Assertion.wilyAssert(offset < this.getTotalSize());
            for (int i = 0; i < this.fListModels.size() && targetModel == null; ++i) {
                ListModel aModel = (ListModel)this.fListModels.elementAt(i);
                if ((runningOffset += aModel.getSize()) <= offset) continue;
                targetModel = aModel;
            }
            return targetModel;
        }
    }

    private class CoalescedListDataListener
    implements ListDataListener {
        public void intervalAdded(ListDataEvent e) {
            Assertion.wilyAssert(e.getSource() != null && e.getSource() instanceof ListModel);
            ListModel sourceModel = (ListModel)e.getSource();
            int intervalOffset = CoalescedListModel.this.fSubModels.getListModelOffset(sourceModel);
            CoalescedListModel.this.fireIntervalAdded(CoalescedListModel.this, e.getIndex0() + intervalOffset, e.getIndex1() + intervalOffset);
        }

        public void intervalRemoved(ListDataEvent e) {
            Assertion.wilyAssert(e.getSource() != null && e.getSource() instanceof ListModel);
            ListModel sourceModel = (ListModel)e.getSource();
            int intervalOffset = CoalescedListModel.this.fSubModels.getListModelOffset(sourceModel);
            CoalescedListModel.this.fireIntervalRemoved(CoalescedListModel.this, e.getIndex0() + intervalOffset, e.getIndex1() + intervalOffset);
        }

        public void contentsChanged(ListDataEvent e) {
            Assertion.wilyAssert(e.getSource() != null && e.getSource() instanceof ListModel);
            ListModel sourceModel = (ListModel)e.getSource();
            int intervalOffset = CoalescedListModel.this.fSubModels.getListModelOffset(sourceModel);
            CoalescedListModel.this.fireContentsChanged(CoalescedListModel.this, e.getIndex0() + intervalOffset, e.getIndex1() + intervalOffset);
        }
    }
}

