/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.appmap.agent.BizDef;
import com.wily.introscope.appmap.agent.trace.AbstractStackBasedNameHelper;
import com.wily.introscope.appmap.agent.trace.AppMapApplicationCrossProcessHelper;
import com.wily.introscope.appmap.agent.trace.AppMapBtcCrossProcessHelper;
import com.wily.introscope.appmap.agent.trace.ICallbackOnLazyPushOwnerName;
import com.wily.introscope.spec.agent.beans.bizdef.IBizDefSupportBean;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.introscope.spec.server.appmap.IAppMapOwner;
import java.util.List;
import java.util.Stack;

public class BtcNameHelper
extends AbstractStackBasedNameHelper {
    private static final BtcNameHelper kInstance = new BtcNameHelper();
    private volatile IBizDefSupportBean fBizDefSupport = null;
    private volatile boolean fIsOldMode = false;
    private static ThreadLocal fStack = new ThreadLocal(){

        protected Object initialValue() {
            return new Stack();
        }
    };

    private BtcNameHelper() {
        AppMapBtcCrossProcessHelper.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BtcNameHelper getInstance(IAgent agent) {
        if (BtcNameHelper.kInstance.fBizDefSupport == null) {
            BtcNameHelper btcNameHelper = kInstance;
            synchronized (btcNameHelper) {
                if (BtcNameHelper.kInstance.fBizDefSupport == null) {
                    BtcNameHelper.kInstance.fBizDefSupport = (IBizDefSupportBean)agent.IAgent_getTracerAdministrator().loadTraceSupport("com.wily.introscope.agent.bizdef.BizDefAdministratorFactory", "").getTraceSupportInstance();
                    BtcNameHelper.kInstance.fIsOldMode = agent.IAgent_getComponentTracer().isAgentOldMode();
                }
            }
        }
        return kInstance;
    }

    @Override
    protected Stack getThreadLocalOwnerNameStack() {
        Stack currentApplicationNameStack = (Stack)fStack.get();
        return currentApplicationNameStack;
    }

    @Override
    protected void setOwnerNameInCrossProcess(SharedCrossProcessData cache, IAppMapOwner owner) {
        AppMapBtcCrossProcessHelper.getInstance().setCalledProcessOwner(cache, owner);
    }

    @Override
    protected List getOwnerNamesInCrossProcess(SharedCrossProcessData cache) {
        return AppMapBtcCrossProcessHelper.getInstance().getCallingProcessOwners(cache);
    }

    @Override
    public IAppMapOwner getNullOwner() {
        return BizDef.getNullInstance();
    }

    @Override
    protected IAppMapOwner getLastRemoteOwnerInCrossProcess(SharedCrossProcessData cache) {
        List ownerlist = AppMapApplicationCrossProcessHelper.getInstance().getCallingProcessOwners(cache);
        if (ownerlist != null && !ownerlist.isEmpty()) {
            return (IAppMapOwner)ownerlist.get(ownerlist.size() - 1);
        }
        return null;
    }

    @Override
    public IAppMapOwner getOwnerFromData(String name, InvocationData data, boolean isStartTrace) {
        if (data != null && (this.fIsOldMode || data.hasServletSupport())) {
            IBizTrx trx = this.fBizDefSupport.getBusinessTransactionComponent((Object)data, isStartTrace);
            if (trx != null) {
                return BizDef.getInstance(trx);
            }
            Boolean matchComplete = (Boolean)data.get("introscope.agent.bizDefIdentified");
            if (matchComplete != null && matchComplete.equals(Boolean.FALSE)) {
                return BizDef.getDelayedInstance();
            }
        }
        return BizDef.getNullInstance();
    }

    @Override
    public void pushCurrentOwnerNameForCrossProcess(SharedCrossProcessData cache, IAppMapOwner ownerName) {
        AppMapBtcCrossProcessHelper.getInstance().setCalledProcessOwner(cache, ownerName);
    }

    @Override
    public void popCurrentOwnerNameForCrossProcess(SharedCrossProcessData cache, IAppMapOwner owner) {
        AppMapBtcCrossProcessHelper.getInstance().setCalledProcessOwner(cache, null);
    }

    @Override
    public void popCurrentOwnerNameForCrossProcess(SharedCrossProcessData cache, String owner) {
        throw new UnsupportedOperationException("Cannot remove a owner by name from a Business Transaction Component Cross Process cache slot");
    }

    @Override
    public void lazyPushCurrentOwnerNameForCrossProcess(SharedCrossProcessData cache, ICallbackOnLazyPushOwnerName callback) {
        throw new UnsupportedOperationException("Cannot add lazily a owner to a Business Transaction Component Cross Process cache slot");
    }

    @Override
    public boolean reset() {
        this.getThreadLocalOwnerNameStack().clear();
        return true;
    }
}

