/*
 * Decompiled with CFR 0.152.
 */
package com.wily.EDU.oswego.cs.dl.util.concurrent;

import com.wily.EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import com.wily.EDU.oswego.cs.dl.util.concurrent.Sync;
import com.wily.EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.util.Collection;
import java.util.Iterator;

public class SyncCollection
implements Collection {
    protected final Collection c_;
    protected final Sync rd_;
    protected final Sync wr_;
    protected final SynchronizedLong syncFailures_ = new SynchronizedLong(0L);

    public SyncCollection(Collection collection, Sync sync) {
        this(collection, sync, sync);
    }

    public SyncCollection(Collection collection, ReadWriteLock rwl) {
        this(collection, rwl.readLock(), rwl.writeLock());
    }

    public SyncCollection(Collection collection, Sync readLock, Sync writeLock) {
        this.c_ = collection;
        this.rd_ = readLock;
        this.wr_ = writeLock;
    }

    public Sync readerSync() {
        return this.rd_;
    }

    public Sync writerSync() {
        return this.wr_;
    }

    public long syncFailures() {
        return this.syncFailures_.get();
    }

    protected boolean beforeRead() {
        try {
            this.rd_.acquire();
            return false;
        }
        catch (InterruptedException ex) {
            this.syncFailures_.increment();
            return true;
        }
    }

    protected void afterRead(boolean wasInterrupted) {
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        } else {
            this.rd_.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        boolean wasInterrupted = this.beforeRead();
        try {
            int n = this.c_.size();
            Object var4_3 = null;
            this.afterRead(wasInterrupted);
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean wasInterrupted = this.beforeRead();
        try {
            boolean bl = this.c_.isEmpty();
            Object var4_3 = null;
            this.afterRead(wasInterrupted);
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        boolean wasInterrupted = this.beforeRead();
        try {
            boolean bl = this.c_.contains(o);
            Object var5_4 = null;
            this.afterRead(wasInterrupted);
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        boolean wasInterrupted = this.beforeRead();
        try {
            Object[] objectArray = this.c_.toArray();
            Object var4_3 = null;
            this.afterRead(wasInterrupted);
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        boolean wasInterrupted = this.beforeRead();
        try {
            Object[] objectArray = this.c_.toArray(a);
            Object var5_4 = null;
            this.afterRead(wasInterrupted);
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection coll) {
        boolean wasInterrupted = this.beforeRead();
        try {
            boolean bl = this.c_.containsAll(coll);
            Object var5_4 = null;
            this.afterRead(wasInterrupted);
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o) {
        this.wr_.acquire();
        try {
            boolean bl = this.c_.add(o);
            {
                Object var4_4 = null;
                this.wr_.release();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                Object var4_5 = null;
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        this.wr_.acquire();
        try {
            boolean bl = this.c_.remove(o);
            {
                Object var4_4 = null;
                this.wr_.release();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                Object var4_5 = null;
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection coll) {
        this.wr_.acquire();
        try {
            boolean bl = this.c_.addAll(coll);
            {
                Object var4_4 = null;
                this.wr_.release();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                Object var4_5 = null;
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection coll) {
        this.wr_.acquire();
        try {
            boolean bl = this.c_.removeAll(coll);
            {
                Object var4_4 = null;
                this.wr_.release();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                Object var4_5 = null;
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection coll) {
        this.wr_.acquire();
        try {
            boolean bl = this.c_.retainAll(coll);
            {
                Object var4_4 = null;
                this.wr_.release();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                Object var4_5 = null;
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.wr_.acquire();
            try {
                this.c_.clear();
                Object var2_1 = null;
                this.wr_.release();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.wr_.release();
                throw throwable;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator unprotectedIterator() {
        boolean wasInterrupted = this.beforeRead();
        try {
            Iterator iterator = this.c_.iterator();
            Object var4_3 = null;
            this.afterRead(wasInterrupted);
            return iterator;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        boolean wasInterrupted = this.beforeRead();
        try {
            SyncCollectionIterator syncCollectionIterator = new SyncCollectionIterator(this.c_.iterator());
            Object var4_3 = null;
            this.afterRead(wasInterrupted);
            return syncCollectionIterator;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterRead(wasInterrupted);
            throw throwable;
        }
    }

    public class SyncCollectionIterator
    implements Iterator {
        protected final Iterator baseIterator_;

        SyncCollectionIterator(Iterator baseIterator) {
            this.baseIterator_ = baseIterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            boolean wasInterrupted = SyncCollection.this.beforeRead();
            try {
                boolean bl = this.baseIterator_.hasNext();
                Object var4_3 = null;
                SyncCollection.this.afterRead(wasInterrupted);
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                SyncCollection.this.afterRead(wasInterrupted);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            boolean wasInterrupted = SyncCollection.this.beforeRead();
            try {
                Object e = this.baseIterator_.next();
                Object var4_3 = null;
                SyncCollection.this.afterRead(wasInterrupted);
                return e;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                SyncCollection.this.afterRead(wasInterrupted);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            try {
                SyncCollection.this.wr_.acquire();
                try {
                    this.baseIterator_.remove();
                    Object var2_1 = null;
                    SyncCollection.this.wr_.release();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    SyncCollection.this.wr_.release();
                    throw throwable;
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }
}

