/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.xmlserialization;

import com.wily.util.xmlserialization.ICustomXmlizable;
import com.wily.util.xmlserialization.IXmlReferenceable;
import com.wily.util.xmlserialization.IXmlWriter;
import com.wily.util.xmlserialization.IXmlizable;
import com.wily.util.xmlserialization.XmlException;
import com.wily.utilities.properties.Messages;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Stack;

public class XmlWriter
implements IXmlWriter {
    private Writer writer;
    private Stack stack;
    private StringBuffer attrs;
    private boolean empty;
    private boolean closed;

    public XmlWriter(Writer writer) {
        this.writer = writer;
        this.closed = true;
        this.stack = new Stack();
    }

    @Override
    public void startElement(String name) throws XmlException {
        try {
            this.closeOpeningTag();
            this.closed = false;
            this.writer.write("<");
            this.writer.write(name);
            this.stack.add(name);
            this.empty = true;
        }
        catch (IOException ioe) {
            throw new XmlException(ioe);
        }
    }

    @Override
    public void writeElement(String name, IXmlizable element) throws XmlException {
        this.startElement(name);
        this.writeElement(element);
        this.endElement();
    }

    @Override
    public void writeElement(IXmlizable element) throws XmlException {
        if (element == null) {
            this.writeText("NULL");
        } else if (element instanceof ICustomXmlizable) {
            ((ICustomXmlizable)element).writeXML(this);
        } else {
            this.writeJavaObjectByReflection(element);
        }
    }

    private void writeJavaObjectByReflection(Object obj) throws XmlException {
        try {
            this.startElement("Object");
            this.writeAttribute("Type", obj.getClass().getName());
            if (obj instanceof IXmlReferenceable) {
                this.writeAttribute("UID", ((IXmlReferenceable)obj).getXmlReferenceUID());
            }
            Class<?> currentClass = obj.getClass();
            while (!currentClass.equals(Object.class)) {
                Field[] fields = currentClass.getDeclaredFields();
                int i = 0;
                while (i < fields.length) {
                    Field f = fields[i];
                    if (!Modifier.isTransient(f.getModifiers()) && !Modifier.isStatic(f.getModifiers())) {
                        int j;
                        int arrLen;
                        f.setAccessible(true);
                        this.startElement("Field");
                        Class<Number> type = f.getType();
                        this.writeAttribute("Name", this.stripFieldNamePrefix(f.getName()));
                        this.writeAttribute("Type", type.getName());
                        this.startElement("Value");
                        if (type.isPrimitive() || type.isAssignableFrom(Number.class) || type.equals(String.class)) {
                            Object val = f.get(obj);
                            this.writeText(val == null ? "NULL" : val.toString());
                        } else if (type.isArray()) {
                            Object arr = f.get(obj);
                            if (arr == null) {
                                this.writeText("NULL");
                            } else {
                                this.startElement("Array");
                                arrLen = Array.getLength(arr);
                                this.writeAttribute("Length", arrLen);
                                j = 0;
                                while (j < arrLen) {
                                    this.writeJavaObjectByReflection(Array.get(arr, j));
                                    ++j;
                                }
                                this.endElement();
                            }
                        } else if (List.class.isAssignableFrom(type)) {
                            List list = (List)f.get(obj);
                            if (list == null) {
                                this.writeText("NULL");
                            } else {
                                this.startElement("List");
                                arrLen = list.size();
                                this.writeAttribute("Length", arrLen);
                                j = 0;
                                while (j < arrLen) {
                                    this.writeJavaObjectByReflection(list.get(j));
                                    ++j;
                                }
                                this.endElement();
                            }
                        } else if (IXmlReferenceable.class.isAssignableFrom(type)) {
                            this.writeElementReference((IXmlReferenceable)f.get(obj));
                        } else if (IXmlizable.class.isAssignableFrom(type)) {
                            this.writeElement((IXmlizable)f.get(obj));
                        } else {
                            throw new XmlException(Messages.getString("XmlWriter.UnsupportedTypeError_Log", (Object)type.getName(), (Object)obj.getClass().getName(), (Object)f.getName()));
                        }
                        this.endElement();
                        this.endElement();
                    }
                    ++i;
                }
                currentClass = currentClass.getSuperclass();
            }
            this.endElement();
        }
        catch (IllegalAccessException e) {
            throw new XmlException(e);
        }
    }

    private String stripFieldNamePrefix(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("f")) {
            return name.substring("f".length());
        }
        return null;
    }

    @Override
    public void writeElementReference(String name, IXmlReferenceable element) throws XmlException {
        this.startElement(name);
        this.writeElementReference(element);
        this.endElement();
    }

    @Override
    public void writeElementReference(IXmlReferenceable element) throws XmlException {
        if (element == null) {
            this.writeText("NULL");
        } else {
            this.startElement("Reference");
            this.writeAttribute("TargetType", element.getClass().getName());
            this.writeAttribute("TargetUID", element.getXmlReferenceUID());
            this.endElement();
        }
    }

    @Override
    public void writeAttribute(String attr, String value) throws XmlException {
        if (this.attrs == null) {
            this.attrs = new StringBuffer();
        }
        this.attrs.append(" ");
        this.attrs.append(attr);
        this.attrs.append("=\"");
        this.attrs.append(XmlWriter.escapeXml(value));
        this.attrs.append("\"");
    }

    @Override
    public void writeAttribute(String attr, long value) throws XmlException {
        this.writeAttribute(attr, Long.toString(value));
    }

    @Override
    public void writeAttribute(String attr, int value) throws XmlException {
        this.writeAttribute(attr, Integer.toString(value));
    }

    @Override
    public void writeAttribute(String attr, short value) throws XmlException {
        this.writeAttribute(attr, Short.toString(value));
    }

    @Override
    public void writeAttribute(String attr, byte value) throws XmlException {
        this.writeAttribute(attr, Byte.toString(value));
    }

    @Override
    public void writeAttribute(String attr, boolean value) throws XmlException {
        this.writeAttribute(attr, Boolean.toString(value));
    }

    @Override
    public void writeAttribute(String attr, float value) throws XmlException {
        this.writeAttribute(attr, Float.toString(value));
    }

    @Override
    public void writeAttribute(String attr, double value) throws XmlException {
        this.writeAttribute(attr, Double.toString(value));
    }

    @Override
    public void endElement() throws XmlException {
        try {
            if (this.stack.empty()) {
                throw new XmlException(Messages.getString("XmlWriter.XmlException_Log"));
            }
            String name = (String)this.stack.pop();
            if (name != null) {
                if (this.empty) {
                    this.writeAttributes();
                    this.writer.write("/>");
                } else {
                    this.writer.write("</");
                    this.writer.write(name);
                    this.writer.write(">");
                }
                this.empty = false;
                this.closed = true;
            }
        }
        catch (IOException ioe) {
            throw new XmlException(ioe);
        }
    }

    @Override
    public void writeText(String text) throws XmlException {
        try {
            this.closeOpeningTag();
            this.empty = false;
            this.writer.write(XmlWriter.escapeXml(text));
        }
        catch (IOException ioe) {
            throw new XmlException(ioe);
        }
    }

    public void close() throws XmlException {
        if (!this.stack.empty()) {
            throw new XmlException(Messages.getString("XmlWriter.UnclosedTagsError_Log", this.stack.pop()));
        }
    }

    private void closeOpeningTag() throws IOException {
        if (!this.closed) {
            this.writeAttributes();
            this.closed = true;
            this.writer.write(">");
        }
    }

    private void writeAttributes() throws IOException {
        if (this.attrs != null) {
            this.writer.write(this.attrs.toString());
            this.attrs.setLength(0);
            this.empty = false;
        }
    }

    private static String escapeXml(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer(s.length());
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '&': {
                    buff.append("&amp;");
                    break;
                }
                case '<': {
                    buff.append("&lt;");
                    break;
                }
                case '>': {
                    buff.append("&gt;");
                    break;
                }
                case '\"': {
                    buff.append("&quot;");
                    break;
                }
                case '\'': {
                    buff.append("&apos;");
                    break;
                }
                default: {
                    buff.append(chars[i]);
                }
            }
            ++i;
        }
        return buff.toString();
    }
}

