/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.db;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionCallback;
import com.wily.introscope.agent.transformer.dynamic.IDeepInheritanceHelper;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.spec.server.beans.dynamicinstrumentationtrace.UnsupportedDIOperationException;
import com.wily.util.adt.ConcurrentAgingThreadLocalHashMap;
import com.wily.util.adt.DatedValue;
import com.wily.util.adt.IAgedMap;
import com.wily.util.classfile.ClassFileUtilities;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.heartbeat.WaitAndExecuteBehavior;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.io.ByteArrayInputStream;
import java.util.concurrent.ConcurrentHashMap;

public final class DeepInheritanceHelper
implements IDeepInheritanceHelper {
    private final ConcurrentHashMap<IClassName, ConcurrentHashMap<IClassName, Boolean>> fAnnotationMap;
    private final ConcurrentHashMap<IClassName, ConcurrentHashMap<IClassName, Boolean>> fParentMap;
    private final ConcurrentHashMap<IClassName, Boolean> fRootMap;
    private final MyClassCache fClassCache;
    public static final Module kModule = new Module("DeepInheritanceHelper");
    protected static final int kMaxRetry = 3;
    private static Boolean kTrue = Boolean.TRUE;
    public static String kDeepInheritanceAutoEnableKey = "introscope.autoprobe.deepinheritance.auto.turnoff.enable";
    public static boolean kDeepInheritanceAutoEnable_default = true;
    public static String kDeepInheritanceAutoEnableDesp = "IntroscopeAutoprobeDeepinheritanceAutoturnoffEnable";
    public static String kDeepInheritanceRequestsKey = "introscope.autoprobe.deepinheritance.auto.turnoff.requests.per.interval";
    public static int kDeepInheritanceRequests_default = 100;
    public static String kDeepInheritanceRequestsDesp = "IntroscopeAutoprobeDeepinheritanceAutoturnoffRequestsPerInterval";
    public static String kDeepInheritanceMaxTimeKey = "introscope.autoprobe.deepinheritance.auto.turnoff.maxtime.per.interval";
    public static int kDeepInheritanceMaxTime_default = 12000;
    public static String kDeepInheritanceMaxTimeDesp = "IntroscopeAutoprobeDeepinheritanceAutoturnoffMaxTimePerInterval";
    public static String kDeepInheritanceMaxTimeTotalKey = "introscope.autoprobe.deepinheritance.auto.turnoff.maxtime.total";
    public static int kDeepInheritanceMaxTimeTotal_default = 120000;
    public static String kDeepInheritanceMaxTimeTotalDesp = "IntroscopeAutoprobeDeepinheritanceAutoturnoffRequestsTotal";
    private volatile boolean fCfgAutoShutDownDeepInheritanceEnabled = kDeepInheritanceAutoEnable_default;
    private volatile int fCfgRequestsForDeepInheritance = kDeepInheritanceRequests_default;
    private volatile int fCfgMaxTimeSpentOnDeepInheritance = kDeepInheritanceMaxTime_default;
    private volatile int fCfgMaxTotalTimeSpentOnDeepInheritance = kDeepInheritanceMaxTimeTotal_default;
    private volatile int fTimeSpentOnDeepInheritance = 0;
    private volatile int fRequestsForDeepInheritance = 0;
    private volatile int fTotalTimeSpentOnDeepInheritance = 0;
    private volatile int fTotalRequestsForDeepInheritance = 0;
    private volatile boolean fAutoShutDownDeepInheritance = false;
    private volatile int fRedfineServiceDelay = 0;
    public static int kDeepInheritanceRedefinitionServiceDelayKey_default = 1000;
    public static String kDeepInheritanceRedefinitionServiceDelayKey = "introscope.autoprobe.deepinheritance.root.redefineService.delay";

    private DeepInheritanceHelper() {
        this.fAnnotationMap = new ConcurrentHashMap();
        this.fParentMap = new ConcurrentHashMap();
        this.fRootMap = new ConcurrentHashMap();
        this.fClassCache = new MyClassCache();
        this.initShutDownParameters();
    }

    public static DeepInheritanceHelper getInstance() {
        return DeepInheritanceHelperHolder.fInstance;
    }

    public final synchronized void startClassCache(IntervalHeartbeat beat, IModuleFeedbackChannel feedback, long agingTime, long updateAgingFrequency) {
        this.fClassCache.setFeedback(feedback);
        this.fClassCache.startAging(beat, agingTime, updateAgingFrequency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCfgAutoShutDownDeepInheritanceEnabled(boolean inValue) {
        boolean oldValue = false;
        DeepInheritanceHelper deepInheritanceHelper = this;
        synchronized (deepInheritanceHelper) {
            oldValue = this.fCfgAutoShutDownDeepInheritanceEnabled;
            this.fCfgAutoShutDownDeepInheritanceEnabled = inValue;
            if (oldValue != inValue) {
                this.fAutoShutDownDeepInheritance = false;
                this.fTimeSpentOnDeepInheritance = 0;
                this.fTotalTimeSpentOnDeepInheritance = 0;
                this.fRequestsForDeepInheritance = 0;
                this.fTotalRequestsForDeepInheritance = 0;
            }
        }
        IModuleFeedbackChannel log = DeepInheritanceHelper.getAgent().IAgent_getModuleFeedback();
        log.info(kModule, "auto turn off feature was " + oldValue + " ; Now it is : " + inValue);
    }

    private void setCfgRequestsForDeepInheritance(int inValue) {
        this.fCfgRequestsForDeepInheritance = inValue;
    }

    private void setCfgMaxTimeSpentOnDeepInheritance(int inValue) {
        this.fCfgMaxTimeSpentOnDeepInheritance = inValue;
    }

    private void setCfgMaxTotalTimeSpentOnDeepInheritance(int inValue) {
        this.fCfgMaxTotalTimeSpentOnDeepInheritance = inValue;
    }

    private final void initShutDownParameters() {
        IAgent agent = DeepInheritanceHelper.getAgent();
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        IStringLocalizer localizer = agent.IAgent_getStringLocalizer();
        ConfigurationManager configurationManager = agent.IAgent_getConfigurationManager();
        this.fRedfineServiceDelay = agent.IAgent_getIndexedProperties().safeGetPositiveIntProperty(kDeepInheritanceRedefinitionServiceDelayKey, kDeepInheritanceRedefinitionServiceDelayKey_default, feedback, localizer);
        BooleanConfigurationProperty autoShutDownEnable = new BooleanConfigurationProperty(kDeepInheritanceAutoEnableKey, kDeepInheritanceAutoEnable_default, kDeepInheritanceAutoEnableDesp, false, false, feedback, kModule, localizer){

            public void set(Object newValue) {
                DeepInheritanceHelper.this.setCfgAutoShutDownDeepInheritanceEnabled((Boolean)newValue);
            }
        };
        configurationManager.add((ConfigurationProperty)autoShutDownEnable, true);
        PositiveIntegerConfigurationProperty requests = new PositiveIntegerConfigurationProperty(kDeepInheritanceRequestsKey, kDeepInheritanceRequests_default, kDeepInheritanceRequestsDesp, null, false, false, feedback, kModule, localizer){

            public void set(Object value) {
                DeepInheritanceHelper.this.setCfgRequestsForDeepInheritance((Integer)value);
            }
        };
        configurationManager.add((ConfigurationProperty)requests, true);
        PositiveIntegerConfigurationProperty maxTimeSpent = new PositiveIntegerConfigurationProperty(kDeepInheritanceMaxTimeKey, kDeepInheritanceMaxTime_default, kDeepInheritanceMaxTimeDesp, null, false, false, feedback, kModule, localizer){

            public void set(Object value) {
                DeepInheritanceHelper.this.setCfgMaxTimeSpentOnDeepInheritance((Integer)value);
            }
        };
        configurationManager.add((ConfigurationProperty)maxTimeSpent, true);
        PositiveIntegerConfigurationProperty maxTimeTotalSpent = new PositiveIntegerConfigurationProperty(kDeepInheritanceMaxTimeTotalKey, kDeepInheritanceMaxTimeTotal_default, kDeepInheritanceMaxTimeTotalDesp, null, false, false, feedback, kModule, localizer){

            public void set(Object value) {
                DeepInheritanceHelper.this.setCfgMaxTotalTimeSpentOnDeepInheritance((Integer)value);
            }
        };
        configurationManager.add((ConfigurationProperty)maxTimeTotalSpent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateTimeOnDeepInheritance(long startTimestamp) {
        if (!this.fCfgAutoShutDownDeepInheritanceEnabled) {
            return;
        }
        long duration = System.currentTimeMillis() - startTimestamp;
        String logMsg = null;
        DeepInheritanceHelper deepInheritanceHelper = this;
        synchronized (deepInheritanceHelper) {
            if (!this.fAutoShutDownDeepInheritance) {
                this.fTimeSpentOnDeepInheritance = (int)((long)this.fTimeSpentOnDeepInheritance + duration);
                this.fTotalTimeSpentOnDeepInheritance = (int)((long)this.fTotalTimeSpentOnDeepInheritance + duration);
                ++this.fRequestsForDeepInheritance;
                ++this.fTotalRequestsForDeepInheritance;
                if (this.fTotalTimeSpentOnDeepInheritance > this.fCfgMaxTotalTimeSpentOnDeepInheritance) {
                    this.fAutoShutDownDeepInheritance = true;
                    logMsg = "Deep inheritance is automatically turned off due to large total delay. total time spent (ms) " + this.fTotalTimeSpentOnDeepInheritance + " ; total requests: " + this.fTotalRequestsForDeepInheritance + " ; interval time spent (ms): " + this.fTimeSpentOnDeepInheritance + " ; interval requests: " + this.fRequestsForDeepInheritance;
                } else if (this.fRequestsForDeepInheritance >= this.fCfgRequestsForDeepInheritance) {
                    if (this.fTimeSpentOnDeepInheritance > this.fCfgMaxTimeSpentOnDeepInheritance) {
                        this.fAutoShutDownDeepInheritance = true;
                        logMsg = "Deep inheritance is automatically turned off due to large delay in interval. total time spent (ms) " + this.fTotalTimeSpentOnDeepInheritance + " ; total requests: " + this.fTotalRequestsForDeepInheritance + " ; interval time spent (ms): " + this.fTimeSpentOnDeepInheritance + " ; interval requests: " + this.fRequestsForDeepInheritance;
                    } else {
                        this.fTimeSpentOnDeepInheritance = 0;
                        this.fRequestsForDeepInheritance = 0;
                    }
                }
            }
        }
        if (this.fAutoShutDownDeepInheritance && logMsg != null) {
            IModuleFeedbackChannel log = DeepInheritanceHelper.getAgent().IAgent_getModuleFeedback();
            String cfgLogMsg = "Deep inheritance configuration: max total time spent (ms) " + this.fCfgMaxTotalTimeSpentOnDeepInheritance + " ; max interval time spent (ms): " + this.fCfgMaxTimeSpentOnDeepInheritance + " ; requests in interval: " + this.fCfgRequestsForDeepInheritance;
            log.info(kModule, cfgLogMsg);
            log.info(kModule, logMsg);
        }
    }

    public final boolean isAutoShutDownDeepInheritance() {
        return this.fAutoShutDownDeepInheritance;
    }

    public final boolean addAnnotationMatchRequest(IModeledClass requesterClass, IClassName annotationClassName) {
        if (this.fAutoShutDownDeepInheritance) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        IAgent agent = DeepInheritanceHelper.getAgent();
        ConcurrentHashMap<IClassName, Boolean> interfaceNamesSet = this.fAnnotationMap.get(annotationClassName);
        if (interfaceNamesSet != null) {
            for (IClassName c : interfaceNamesSet.keySet()) {
                if (requesterClass.isInstanceOf(c)) {
                    if (this.getLog(agent).isTraceEnabled()) {
                        this.getLog(agent).trace(kModule, "[Annotation] Class " + requesterClass.getClassName().getReflectionFriendlyQualifiedNameString() + "IS deep instance of " + c.getReflectionFriendlyQualifiedNameString());
                    }
                    this.updateTimeOnDeepInheritance(startTime);
                    return true;
                }
                if (!this.getLog(agent).isTraceEnabled()) continue;
                this.getLog(agent).trace(kModule, "[Annotation] Class " + requesterClass.getClassName().getReflectionFriendlyQualifiedNameString() + "is not deep instance of " + c.getReflectionFriendlyQualifiedNameString());
            }
        } else if (this.getLog(agent).isTraceEnabled()) {
            this.getLog(agent).trace(kModule, "[Annotation] tempAnnotationName not loaded yet " + requesterClass.getClassName());
        }
        this.updateTimeOnDeepInheritance(startTime);
        return false;
    }

    private final IModuleFeedbackChannel getLog(IAgent agent) {
        return agent.IAgent_getModuleFeedback();
    }

    public final boolean addInheritanceMatchRequest(IModeledClass requesterClass, IClassName superClassOrInterfaceName) {
        if (this.fAutoShutDownDeepInheritance) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        IModuleFeedbackChannel log = DeepInheritanceHelper.getAgent().IAgent_getModuleFeedback();
        Boolean interfaceNamesSet = this.fRootMap.get(superClassOrInterfaceName);
        if (interfaceNamesSet != null) {
            block10: {
                if (!requesterClass.isInstanceOf(superClassOrInterfaceName)) break block10;
                if (log.isTraceEnabled()) {
                    log.trace(kModule, "[Deep Inheritance] Class " + requesterClass.getClassName().getReflectionFriendlyQualifiedNameString() + "is deep instance of " + superClassOrInterfaceName.getReflectionFriendlyQualifiedNameString());
                }
                this.updateTimeOnDeepInheritance(startTime);
                return true;
            }
            try {
                if (log.isTraceEnabled()) {
                    log.trace(kModule, "[Deep Inheritance] Class " + requesterClass.getClassName().getReflectionFriendlyQualifiedNameString() + "is not deep instance of " + superClassOrInterfaceName.getReflectionFriendlyQualifiedNameString());
                }
            }
            catch (Throwable t) {
                if (log.isDebugEnabled()) {
                    log.debug(kModule, "[Deep Inheritance] Unexpected error when checking " + requesterClass.getClassName() + " against " + superClassOrInterfaceName.getReflectionFriendlyQualifiedNameString(), t);
                }
                log.error(kModule, "[Deep Inheritance] Unexpected error when checking " + requesterClass.getClassName() + " against " + superClassOrInterfaceName.getReflectionFriendlyQualifiedNameString());
            }
        } else if (log.isTraceEnabled()) {
            log.trace(kModule, "[Deep Inheritance] Inheritance class " + superClassOrInterfaceName.getReflectionFriendlyQualifiedNameString() + " not loaded yet " + requesterClass.getClassName());
        }
        this.updateTimeOnDeepInheritance(startTime);
        return false;
    }

    public final void noticeFoundRoot(IClassName className) {
        IAgent agent = DeepInheritanceHelper.getAgent();
        if (this.getLog(agent).isTraceEnabled()) {
            DeepInheritanceHelper.getAgent().IAgent_getModuleFeedback().trace(kModule, "Found root " + className);
        }
        if (this.fRootMap.putIfAbsent(className, kTrue) == null) {
            this.redefineTree(className);
        }
    }

    public final void redefineTree(final IClassName className) {
        final boolean[] flagTerminate = new boolean[1];
        new WaitAndExecuteBehavior(DeepInheritanceHelper.getAgent().IAgent_getConfigHeartbeat(), this.fRedfineServiceDelay, String.valueOf(System.currentTimeMillis())){
            int count;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.count = 0;
            }

            protected boolean execute() {
                flagTerminate[0] = false;
                ++this.count;
                final IAgent agent = DeepInheritanceHelper.getAgent();
                DeepInheritanceHelper.this.getLog(agent).debug(kModule, "Running the background deep instrumentation process for class " + className + " after a delay of :" + DeepInheritanceHelper.this.fRedfineServiceDelay + " ms");
                IDynamicInstrumentationTransformer t = agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer();
                boolean succeded = t.redefineClassTree(className, new IClassRedefinitionCallback(){

                    public void executeOnRedefinition(Class redefinedClass, ByteArrayInputStream stream) {
                        if (DeepInheritanceHelper.this.getLog(agent).isTraceEnabled()) {
                            DeepInheritanceHelper.this.getLog(agent).trace(kModule, "Redefined " + redefinedClass.getName());
                        }
                    }

                    public void executeOnUnsupportedOperation(UnsupportedDIOperationException exception, Class candidate, ByteArrayInputStream stream) {
                        flagTerminate[0] = true;
                    }
                }, false, false);
                if (this.count > 3 || flagTerminate[0]) {
                    DeepInheritanceHelper.this.getLog(agent).info(kModule, "The background instrumentation process for EJB support has failed " + this.count + " times; won't retry");
                    return true;
                }
                return succeded;
            }
        };
    }

    public static final IAgent getAgent() {
        try {
            return AgentShim.getAgent();
        }
        catch (AgentNotAvailableException e) {
            e.printStackTrace();
            return null;
        }
    }

    public final void noticeFoundAnnotationRoot(IClassName rootName, IClassName annotationName) {
        IAgent agent = DeepInheritanceHelper.getAgent();
        if (this.getLog(agent).isTraceEnabled()) {
            DeepInheritanceHelper.getAgent().IAgent_getModuleFeedback().trace(kModule, "Found annotation root " + rootName + " for annotation " + annotationName);
        }
        if (this.storeAnnotationRelation(rootName, annotationName)) {
            this.redefineTree(rootName);
        }
    }

    private final boolean storeAnnotationRelation(IClassName rootName, IClassName annotationName) {
        ConcurrentHashMap<IClassName, Boolean> classesImplementingAnnotation = new ConcurrentHashMap<IClassName, Boolean>();
        classesImplementingAnnotation.put(rootName, kTrue);
        ConcurrentHashMap<IClassName, Boolean> interfaceNames = this.fAnnotationMap.putIfAbsent(annotationName, classesImplementingAnnotation);
        if (interfaceNames != null) {
            interfaceNames.putIfAbsent(rootName, kTrue);
            return false;
        }
        return true;
    }

    private final void storeParentChildRelation(IClassName parentName, IClassName childName) {
        ConcurrentHashMap<IClassName, Boolean> childrenOfParent = new ConcurrentHashMap<IClassName, Boolean>();
        childrenOfParent.put(childName, kTrue);
        ConcurrentHashMap<IClassName, Boolean> oldChildrenOfParent = this.fParentMap.putIfAbsent(parentName, childrenOfParent);
        if (oldChildrenOfParent != null) {
            oldChildrenOfParent.putIfAbsent(childName, kTrue);
        }
    }

    public final boolean addAnnotationShallowMatchRequest(IModeledClass requesterClass, IClassName annotationClassName) {
        IAgent agent = DeepInheritanceHelper.getAgent();
        ConcurrentHashMap<IClassName, Boolean> interfaceNamesSet = this.fAnnotationMap.get(annotationClassName);
        if (interfaceNamesSet != null) {
            for (IClassName c : interfaceNamesSet.keySet()) {
                if (requesterClass.hasSuperClass() && ClassFileUtilities.looselyMatches((IClassName)c, (IClassName)requesterClass.getSuperClassName())) {
                    if (this.getLog(agent).isTraceEnabled()) {
                        this.getLog(agent).trace(kModule, "[Shallow Annotation] Class " + requesterClass.getClassName().getReflectionFriendlyQualifiedNameString() + "IS deep instance of " + c.getReflectionFriendlyQualifiedNameString());
                    }
                    return true;
                }
                if (requesterClass.inheritsDirectlyFromInterface(c)) {
                    if (this.getLog(agent).isTraceEnabled()) {
                        this.getLog(agent).trace(kModule, "[Shallow Annotation] Class " + requesterClass.getClassName().getReflectionFriendlyQualifiedNameString() + "IS deep instance of " + c.getReflectionFriendlyQualifiedNameString());
                    }
                    return true;
                }
                if (!this.getLog(agent).isTraceEnabled()) continue;
                this.getLog(agent).trace(kModule, "[Annotation] Class " + requesterClass.getClassName().getReflectionFriendlyQualifiedNameString() + "is not deep instance of " + c.getReflectionFriendlyQualifiedNameString());
            }
        } else if (this.getLog(agent).isTraceEnabled()) {
            this.getLog(agent).trace(kModule, "[Annotation] tempAnnotationName not loaded yet " + requesterClass.getClassName());
        }
        return false;
    }

    public final void noticeFoundAnnotationShallowRoot(IClassName rootName, IClassName annotationName) {
        IAgent agent = DeepInheritanceHelper.getAgent();
        if (this.getLog(agent).isTraceEnabled()) {
            DeepInheritanceHelper.getAgent().IAgent_getModuleFeedback().trace(kModule, "Found annotation shallow root " + rootName + " for annotation " + annotationName);
        }
        if (this.storeAnnotationRelation(rootName, annotationName)) {
            this.redefineTree(rootName);
        }
    }

    public final IAgedMap getClassCache() {
        return this.fClassCache;
    }

    /* synthetic */ DeepInheritanceHelper(DeepInheritanceHelper deepInheritanceHelper) {
        this();
    }

    private static class DeepInheritanceHelperHolder {
        private static final DeepInheritanceHelper fInstance = new DeepInheritanceHelper(null);

        private DeepInheritanceHelperHolder() {
        }
    }

    private static final class MyClassCache
    extends ConcurrentAgingThreadLocalHashMap<String, Object>
    implements IAgedMap {
        private static final long serialVersionUID = -763834306071020193L;

        public Object addAged(Object key, Object value) {
            return this.putAged(key.toString(), value);
        }

        public Object getAged(Object key) {
            DatedValue dv = (DatedValue)this.get(key);
            if (dv == null) {
                return null;
            }
            dv.setDate(System.currentTimeMillis());
            return dv.get();
        }

        public Object addAgedIfAbsent(Object key, Object value) {
            return this.putAgedIfAbsent(key.toString(), value);
        }
    }
}

