/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives.builder;

import com.wily.diagnos.cmp.classmatcher.DGCompoundClassMatcher;
import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.directives.ClassModificationFilterBuilder;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.OptionalExtensionsManager;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IContainerName;
import com.wily.util.classfile.IContainerPrefix;
import com.wily.util.classfile.IPackageName;
import com.wily.util.classfile.IPackagePrefix;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.validate.ValidationException;
import com.wily.wilyassert.Assertion;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public final class TracerGroupBuilder {
    public static final TracerGroupBuilder[] kZeroLengthArray = new TracerGroupBuilder[0];
    private final FlagName fFlagName;
    private final DGCompoundClassMatcher fClassMatcher;
    private final List fDependencies;
    private boolean fDeclared;
    private boolean fEnabled;
    private boolean fLockDisabled;
    private boolean fChangeable;
    private boolean fNameMatchingOnly;
    private boolean fIsAggregate;
    private boolean fIsResolved;
    private int fOperator;
    private final ClassModificationFilterBuilder fFilter;
    private final ICompilerLog fLog;
    private TracerGroup fTracerGroup;
    private IAgent fAgent;
    private String fSource = null;
    public static final int OPERATOR_NONE = 0;
    public static final int OPERATOR_AND = 1;
    public static final int OPERATOR_OR = 2;
    public static final int OPERATOR_MATCH = 3;
    public static final int OPERATOR_XOR = 4;

    public TracerGroupBuilder(ICompilerLog log, FlagName flagName) {
        this.fLog = log;
        this.fFlagName = flagName;
        this.fClassMatcher = new DGCompoundClassMatcher();
        this.fDependencies = new ArrayList();
        this.fDeclared = false;
        this.fEnabled = false;
        this.fLockDisabled = false;
        this.fChangeable = true;
        this.fNameMatchingOnly = false;
        this.fIsResolved = false;
        this.fIsAggregate = false;
        this.fOperator = 0;
        this.fFilter = new ClassModificationFilterBuilder(this.fLog);
        this.fTracerGroup = null;
    }

    public TracerGroupBuilder(ICompilerLog log, TracerGroup tracerGroup) {
        this.fLog = log;
        this.fFlagName = tracerGroup.getName();
        this.fClassMatcher = new DGCompoundClassMatcher();
        this.fClassMatcher.addClassMatcher(tracerGroup.getClassMatcher());
        this.fDependencies = new ArrayList();
        this.fDeclared = true;
        this.fEnabled = tracerGroup.isEnabled();
        this.fLockDisabled = false;
        this.fChangeable = true;
        this.fNameMatchingOnly = false;
        this.fIsResolved = false;
        this.fIsAggregate = false;
        this.fOperator = 0;
        this.fFilter = new ClassModificationFilterBuilder(this.fLog);
        this.fFilter.addClassModificationFilter(tracerGroup.getClassFilter());
        this.fTracerGroup = null;
    }

    public boolean isDeclared() {
        return this.fDeclared;
    }

    public void setDeclared(boolean declared) {
        this.fDeclared = declared;
    }

    public FlagName getName() {
        return this.fFlagName;
    }

    public int getOperator() {
        return this.fOperator;
    }

    public void setOperator(int oper) {
        this.fOperator = oper;
    }

    public void setNameMatchingOnly() {
        this.fNameMatchingOnly = true;
    }

    private boolean usesNameMatchingOnly() {
        return this.fNameMatchingOnly;
    }

    public IClassMatcher getClassMatcher() {
        return this.fClassMatcher;
    }

    public void addClassMatcher(IClassMatcher matcher) {
        this.getCompoundClassMatcher().addClassMatcher(matcher);
    }

    private DGCompoundClassMatcher getCompoundClassMatcher() {
        return this.fClassMatcher;
    }

    private Iterator getFlagDependencyIterator() {
        return this.fDependencies.iterator();
    }

    public void addFlagDependency(TracerGroupBuilder tracerGroupBuilder) {
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        this.fDependencies.add(tracerGroupBuilder);
        this.setAggregate(true);
    }

    private void validate() throws ValidationException {
        if (!this.isDeclared()) {
            this.reportErrorToExtensionManager(this.fSource);
            throw new ValidationException(new FormattedLocalizableMessage("Diagnos_Exception_Invalid_Settings_Undeclared_Flag", this.getName().toString(), false));
        }
        if (this.usesNameMatchingOnly()) {
            Iterator iterator = this.getCompoundClassMatcher().getClassMatchers();
            while (iterator.hasNext()) {
                IClassMatcher matcher = (IClassMatcher)iterator.next();
                if (matcher.IClassMatcher_supportsNameMatching()) continue;
                this.reportErrorToExtensionManager(this.fSource);
                throw new ValidationException(new FormattedLocalizableMessage("Diagnos_Exception_Invalid_Settings_Flag_Uses_Name_Matching_Only", this.getName().toString(), false));
            }
        }
    }

    private TracerGroup resolve() throws ValidationException {
        if (this.isResolved()) {
            return this.fTracerGroup;
        }
        this.validate();
        if (!this.isAggregate()) {
            this.setResolved(true);
            return this.fTracerGroup;
        }
        boolean result = false;
        Object[] aList = this.fDependencies.toArray();
        int oper = this.getOperator();
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        TracerGroupBuilder tracerGroupBuilder = (TracerGroupBuilder)aList[0];
        result = tracerGroupBuilder.isEnabled();
        if (!tracerGroupBuilder.isResolved()) {
            Assertion.wilyFail("should never have an unresolved dependent tracer group!");
            return this.fTracerGroup;
        }
        if (oper == 3) {
            this.addClassFilter(tracerGroupBuilder.getClassFilter());
            this.addClassMatcher(tracerGroupBuilder.getCompoundClassMatcher());
        }
        int i = 1;
        while (i < aList.length) {
            tracerGroupBuilder = (TracerGroupBuilder)aList[i];
            if (!tracerGroupBuilder.isResolved()) {
                Assertion.wilyFail("should never have an unresolved dependent tracer group!");
                return this.fTracerGroup;
            }
            if (oper == 1) {
                result &= tracerGroupBuilder.isEnabled();
            } else if (oper == 2) {
                result |= tracerGroupBuilder.isEnabled();
            } else if (oper == 4) {
                result ^= tracerGroupBuilder.isEnabled();
            } else if (oper == 3) {
                this.addClassFilter(tracerGroupBuilder.getClassFilter());
                this.addClassMatcher(tracerGroupBuilder.getCompoundClassMatcher());
            }
            ++i;
        }
        if (result) {
            this.setEnabled(result);
            int j = 0;
            while (j < aList.length) {
                tracerGroupBuilder = (TracerGroupBuilder)aList[j];
                if (tracerGroupBuilder.isEnabled()) {
                    this.addClassFilter(tracerGroupBuilder.getClassFilter());
                    this.addClassMatcher(tracerGroupBuilder.getCompoundClassMatcher());
                }
                ++j;
            }
        }
        this.setResolved(true);
        return this.fTracerGroup;
    }

    public TracerGroup evaluate() throws ValidationException {
        Stack<TracerGroupBuilder> flagStack = new Stack<TracerGroupBuilder>();
        Stack<Iterator> iteratorStack = new Stack<Iterator>();
        flagStack.push(this);
        iteratorStack.push(this.getFlagDependencyIterator());
        while (!iteratorStack.empty()) {
            TracerGroupBuilder flag;
            Iterator iterator = (Iterator)iteratorStack.peek();
            if (!iterator.hasNext()) {
                flag = (TracerGroupBuilder)flagStack.peek();
                flag.resolve();
                iteratorStack.pop();
                flagStack.pop();
                continue;
            }
            flag = (TracerGroupBuilder)iterator.next();
            if (flagStack.contains(flag)) {
                this.reportErrorToExtensionManager(this.fSource);
                throw new ValidationException(new FormattedLocalizableMessage("Diagnos_Exception_Invalid_Settings_Circular_Dependencies", this.getName().toString(), false));
            }
            flagStack.push(flag);
            iteratorStack.push(flag.getFlagDependencyIterator());
        }
        return this.resolve();
    }

    public void skipInstrumentationInClass(IClassName className) {
        this.fFilter.skipClass(className);
    }

    public void skipInstrumentationInPackage(IPackageName packageName) {
        this.fFilter.skipPackage(packageName);
    }

    public void skipInstrumentationInPackagePrefix(IPackagePrefix prefix) {
        this.fFilter.skipPackagePrefix(prefix);
    }

    public void skipInstrumentationInMethod(IMethodMatcher matcher) {
        this.fFilter.skipMethod(matcher);
    }

    public void skipInstrumentationInContainer(IContainerName containerName) {
        this.fFilter.skipContainer(containerName);
    }

    public void skipInstrumentationInContainerPrefix(IContainerPrefix prefix) {
        this.fFilter.skipContainerPrefix(prefix);
    }

    public void skipInstrumentationInMatchingClasses(IClassMatcher matcher) {
        this.fFilter.skipMatchingClass(matcher);
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void setEnabled(boolean enabled) {
        if (!this.fLockDisabled) {
            this.fEnabled = enabled;
        }
    }

    public boolean isChangeable() {
        return this.fChangeable;
    }

    public void setChangeable(boolean value) {
        this.fChangeable = value;
    }

    public void lockDisabled() {
        this.fEnabled = false;
        this.fLockDisabled = true;
    }

    private ClassModificationFilterBuilder getClassFilter() {
        return this.fFilter;
    }

    private void addClassFilter(ClassModificationFilterBuilder filter) {
        this.fFilter.addClassModificationFilter(filter);
    }

    public boolean isResolved() {
        return this.fIsResolved;
    }

    private void setResolved(boolean isResolved) {
        this.fIsResolved = isResolved;
        this.fTracerGroup = new TracerGroup(this.fFlagName, this.fEnabled, this.fLockDisabled, this.fChangeable, this.fClassMatcher, this.fFilter.generateFilter());
    }

    public boolean isAggregate() {
        return this.fIsAggregate;
    }

    public void setAggregate(boolean isAggregate) {
        this.fIsAggregate = isAggregate;
    }

    public TracerGroup lookupTracerGroup(Map tracerGroups) {
        return (TracerGroup)tracerGroups.get(this.getName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof TracerGroupBuilder) {
            TracerGroupBuilder f = (TracerGroupBuilder)obj;
            return this.fFlagName.equals(f.fFlagName) && this.fEnabled == f.fEnabled && this.fNameMatchingOnly == f.fNameMatchingOnly && this.fClassMatcher.equals(f.fClassMatcher) && this.fFilter.equals(f.fFilter);
        }
        return false;
    }

    public int hashCode() {
        return this.fFlagName.hashCode();
    }

    public String toString() {
        return this.fFlagName.toString();
    }

    public TracerGroup generateTracerGroup() {
        if (!this.isResolved()) {
            throw new IllegalStateException("cannot generate tracer group for unresolved flag");
        }
        return this.fTracerGroup;
    }

    public boolean debug_hasClassMatcher() {
        return this.getCompoundClassMatcher().size() > 0;
    }

    public void setSource(String src) {
        this.fSource = src;
    }

    public String getSource() {
        return this.fSource;
    }

    private void reportErrorToExtensionManager(String fileName) {
        if (this.fAgent != null) {
            String strExt = String.valueOf(File.separatorChar) + "extensions" + File.separatorChar;
            int index = fileName.lastIndexOf(strExt);
            OptionalExtensionsManager oem = this.fAgent.IAgent_getExtensionAdministrator().getOptionalExtensionManager();
            if (oem != null && index != -1) {
                int indexOfSep = fileName.indexOf(File.separatorChar, index + strExt.length());
                String ext = fileName.substring(index + strExt.length(), indexOfSep);
                oem.addExtensionWithError(ext);
            }
        }
    }

    public void setAgent(IAgent agent) {
        this.fAgent = agent;
    }

    public IAgent getAgent() {
        return this.fAgent;
    }
}

