/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.validate;

import com.wily.diagnos.cmp.tracer.IMethodTracerValidator;
import com.wily.introscope.spec.metric.AgentMetricPrefix;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.util.properties.AttributeListing;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.util.validate.ValidationException;
import java.util.Iterator;

public class ConditionalDynamicResourceNameValidator
implements IMethodTracerValidator {
    @Override
    public void IMethodTracerValidator_validateParameters(AttributeListing parameters) throws ValidationException {
        String name = null;
        Iterator iterator = parameters.getKeys();
        while (iterator.hasNext()) {
            String parameter = (String)iterator.next();
            if (parameter.equals("name")) {
                name = parameters.get(parameter);
                continue;
            }
            if (parameter.equals("dynamic")) {
                parameters.get(parameter);
                continue;
            }
            if (parameter.equals("temporary") || parameter.equals("groupName") || parameter.equals("tracerName") || parameter.equals("label") || parameter.equals("callingClass") || parameter.equals("callingMethod")) continue;
            throw new ValidationException(new FormattedLocalizableMessage("Probe_Builder_Validation_Exception_Unexpected_Tracer_Parameter_Error", parameter));
        }
        if (name == null || name.length() == 0) {
            throw new ValidationException(new SimpleLocalizableMessage("Probe_Builder_Validation_Exception_Missing_Resource_Name_Error"));
        }
        try {
            AgentMetricPrefix.verifyValidResource(name);
        }
        catch (BadlyFormedNameException bfne) {
            throw new ValidationException(new FormattedLocalizableMessage("Probe_Builder_Validation_Exception_Invalid_Resource_Name_Error", bfne.ILocalizableException_getLocalizableMessage()));
        }
    }
}

