/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.GathererFactory;
import com.wily.introscope.stat.gatherer.IGatherer;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.util.ArrayUtilities;
import com.wily.util.clock.MasterClock;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BlameHandlingGatherer
implements IGatherer {
    private final int fTypeCookie;
    private Map fGatherers;
    private final Object fGathererLock = new Object();
    private final IGatherer fDefaultGatherer;
    private final boolean fCanCombine;
    private final Map fBlameStackSnapshot;
    private AgentMetric fMetric;

    public BlameHandlingGatherer(int typeCookie) {
        Assertion.wilyAssert(false);
        this.fTypeCookie = typeCookie;
        this.fGatherers = null;
        this.fDefaultGatherer = this.createUnderlyingGatherer();
        this.fMetric = null;
        this.fBlameStackSnapshot = null;
        this.fCanCombine = this.getGathererForBlameStackSnapshot(BlameStackSnapshot.kEmptyBlameStackSnapshot).IGatherer_canCombineData();
    }

    public BlameHandlingGatherer(int typeCookie, AgentMetric metric) {
        Assertion.wilyAssert(false);
        this.fTypeCookie = typeCookie;
        this.fGatherers = null;
        this.fDefaultGatherer = this.createUnderlyingGatherer();
        this.fMetric = metric;
        this.fBlameStackSnapshot = new HashMap(2);
        this.fCanCombine = this.getGathererForBlameStackSnapshot(BlameStackSnapshot.kEmptyBlameStackSnapshot).IGatherer_canCombineData();
    }

    private int getTypeCookie() {
        return this.fTypeCookie;
    }

    private IGatherer createUnderlyingGatherer() {
        return GathererFactory.newGathererByType(this.getTypeCookie(), MasterClock.currentTimeMillis());
    }

    public AgentMetric getMetric() {
        return this.fMetric;
    }

    protected Map getGatherersMap() {
        if (this.fGatherers == null) {
            this.fGatherers = new HashMap(2);
        }
        return this.fGatherers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGatherer getGathererForBlameStackSnapshot(BlameStackSnapshot blameStack) {
        if (blameStack.equals(BlameStackSnapshot.kEmptyBlameStackSnapshot)) {
            return this.fDefaultGatherer;
        }
        Object object = this.fGathererLock;
        synchronized (object) {
            IGatherer result;
            if (this.fGatherers == null) {
                this.fGatherers = new HashMap(2);
            }
            if ((result = (IGatherer)this.fGatherers.get(blameStack)) == null) {
                result = this.createUnderlyingGatherer();
                this.fGatherers.put(blameStack, result);
                if (!blameStack.equals(BlameStackSnapshot.kEmptyBlameStackSnapshot)) {
                    String metricResourceName = blameStack.getComponent(0);
                    if (this.fBlameStackSnapshot != null) {
                        Map blameStackSnapshotMap;
                        this.fBlameStackSnapshot.put(metricResourceName, blameStack);
                        Map map = blameStackSnapshotMap = GathererFactory.getBlameStackSnapshotCache(metricResourceName);
                        synchronized (map) {
                            ArrayList<BlameHandlingGatherer> gatherers = (ArrayList<BlameHandlingGatherer>)blameStackSnapshotMap.get(metricResourceName);
                            if (gatherers == null) {
                                gatherers = new ArrayList<BlameHandlingGatherer>(5);
                                blameStackSnapshotMap.put(metricResourceName, gatherers);
                            }
                            gatherers.add(this);
                        }
                    }
                }
            }
            return result;
        }
    }

    @Override
    public ATimeslicedValue[] IGatherer_harvestAndReset(long when, BlameStackSnapshot blameStack) {
        ATimeslicedValue[] result = ATimeslicedValue.kZeroLengthTimeslicedValueArray;
        IGatherer gatherer = this.getGathererForBlameStackSnapshot(blameStack);
        if (gatherer != null) {
            result = gatherer.IGatherer_harvestAndReset(when, blameStack);
        }
        return result;
    }

    @Override
    public ATimeslicedValue[] IGatherer_harvest(long when, BlameStackSnapshot blameStack) {
        ATimeslicedValue[] result = ATimeslicedValue.kZeroLengthTimeslicedValueArray;
        IGatherer gatherer = this.getGathererForBlameStackSnapshot(blameStack);
        if (gatherer != null) {
            result = gatherer.IGatherer_harvest(when, blameStack);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ATimeslicedValue[] IGatherer_harvestAndReset(long when) {
        ATimeslicedValue[] result = ATimeslicedValue.kZeroLengthTimeslicedValueArray;
        ATimeslicedValue[] deflt = this.fDefaultGatherer.IGatherer_harvestAndReset(when, BlameStackSnapshot.kEmptyBlameStackSnapshot);
        if (deflt != null) {
            result = this.combineValues(result, deflt);
        }
        HashMap tempGatherers = null;
        Object object = this.fGathererLock;
        synchronized (object) {
            if (this.fGatherers == null) {
                return result;
            }
            tempGatherers = new HashMap(this.fGatherers);
        }
        for (Map.Entry entry : tempGatherers.entrySet()) {
            BlameStackSnapshot blameStack = (BlameStackSnapshot)entry.getKey();
            IGatherer gatherer = (IGatherer)entry.getValue();
            ATimeslicedValue[] current = gatherer.IGatherer_harvestAndReset(when, blameStack);
            if (current == null) continue;
            result = this.combineValues(result, current);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ATimeslicedValue[] IGatherer_harvest(long when) {
        ATimeslicedValue[] result = ATimeslicedValue.kZeroLengthTimeslicedValueArray;
        ATimeslicedValue[] deflt = this.fDefaultGatherer.IGatherer_harvest(when, BlameStackSnapshot.kEmptyBlameStackSnapshot);
        if (deflt != null) {
            result = this.combineValues(result, deflt);
        }
        HashMap tempGatherers = null;
        Object object = this.fGathererLock;
        synchronized (object) {
            if (this.fGatherers == null) {
                return result;
            }
            tempGatherers = new HashMap(this.fGatherers);
        }
        for (Map.Entry entry : tempGatherers.entrySet()) {
            BlameStackSnapshot blameStack = (BlameStackSnapshot)entry.getKey();
            IGatherer gatherer = (IGatherer)entry.getValue();
            ATimeslicedValue[] current = gatherer.IGatherer_harvest(when, blameStack);
            if (current == null) continue;
            result = this.combineValues(result, current);
        }
        return result;
    }

    private ATimeslicedValue[] combineValues(ATimeslicedValue[] array1, ATimeslicedValue[] array2) {
        return (ATimeslicedValue[])ArrayUtilities.append(array1, array2, ATimeslicedValue.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void IGatherer_reset(long when) {
        this.fDefaultGatherer.IGatherer_reset(when);
        HashMap tempGatherers = null;
        Object object = this.fGathererLock;
        synchronized (object) {
            if (this.fGatherers == null) {
                return;
            }
            tempGatherers = new HashMap(this.fGatherers);
        }
        for (IGatherer gatherer : tempGatherers.values()) {
            gatherer.IGatherer_reset(when);
        }
    }

    @Override
    public void IGatherer_acceptAggregateTimeslicedValue(ATimeslicedValue newAggregate) throws IncompatibleTypesException {
        IGatherer gatherer = this.getGathererForBlameStackSnapshot(newAggregate.getBlameStackSnapshot());
        gatherer.IGatherer_acceptAggregateTimeslicedValue(newAggregate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void IGatherer_reinitialize() {
        this.fDefaultGatherer.IGatherer_reinitialize();
        HashMap tempGatherers = null;
        Object object = this.fGathererLock;
        synchronized (object) {
            if (this.fGatherers == null) {
                return;
            }
            tempGatherers = new HashMap(this.fGatherers);
        }
        for (IGatherer gatherer : tempGatherers.values()) {
            gatherer.IGatherer_reinitialize();
        }
    }

    @Override
    public int IGatherer_getESETypeCookie() {
        return this.getTypeCookie();
    }

    @Override
    public boolean IGatherer_canCombineData() {
        return this.fCanCombine;
    }

    @Override
    public void forceToExist(BlameStackSnapshot blameStack) {
        this.getGathererForBlameStackSnapshot(blameStack).forceToExist(blameStack);
    }

    @Override
    public void acceptValueNonSync(IMetricDataValue value) throws IncompatibleTypesException {
        Assertion.unimplemented();
    }

    @Override
    public IMetricDataValue harvestAndReinitializeNonSync(long harvestTimeMS) {
        Assertion.unimplemented();
        return null;
    }

    @Override
    public IMetricDataValue harvestAndAbandonNonSync(long harvestTimeMS) {
        Assertion.unimplemented();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGatherer(String metricResourceComponent) {
        Object object = this.fGathererLock;
        synchronized (object) {
            if (this.fBlameStackSnapshot != null) {
                BlameStackSnapshot blameStackSnapshot = (BlameStackSnapshot)this.fBlameStackSnapshot.remove(metricResourceComponent);
                if (this.fGatherers == null) {
                    return;
                }
                this.fGatherers.remove(blameStackSnapshot);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean IGatherer_hasNewData(int timeslice) {
        boolean newData = this.fDefaultGatherer.IGatherer_hasNewData(timeslice);
        Object object = this.fGathererLock;
        synchronized (object) {
            if (this.fGatherers == null) {
                return newData;
            }
            Iterator iterator = this.fGatherers.values().iterator();
            while (!newData && iterator.hasNext()) {
                IGatherer gatherer = (IGatherer)iterator.next();
                boolean bl = newData = newData || gatherer.IGatherer_hasNewData(timeslice);
            }
        }
        return newData;
    }

    @Override
    public long IGatherer_getStartTimestamp() {
        return 0L;
    }
}

