/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.concurrent;

import com.wily.EDU.oswego.cs.dl.util.concurrent.BoundedPriorityQueue;
import com.wily.EDU.oswego.cs.dl.util.concurrent.Channel;
import com.wily.EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.wily.EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import com.wily.util.concurrent.IPriorityExecutor;

public class PooledPriorityExecutor
extends PooledExecutor
implements IPriorityExecutor {
    private final int fMaxPoolSize;

    public PooledPriorityExecutor(String name, int maxPoolSize, int threadPriority) {
        super((Channel)new BoundedPriorityQueue(null), maxPoolSize);
        this.waitWhenBlocked();
        this.setThreadFactory(new PooledPriorityThreadFactory(name, threadPriority));
        this.setMinimumPoolSize(maxPoolSize);
        this.fMaxPoolSize = maxPoolSize;
    }

    public void IPriorityExecutor_execute(Runnable command, int priority) throws InterruptedException {
        PriorityRunnable runAtPriority = new PriorityRunnable(command, priority);
        this.execute(runAtPriority);
    }

    public void IPriorityExecutor_stop() {
        this.shutdownNow();
    }

    public void IPriorityExecutor_stopAfterProcessingQueue() {
        this.shutdownAfterProcessingCurrentlyQueuedTasks();
    }

    public int IPriorityExecutor_getMaxParallelExecutors() {
        return this.fMaxPoolSize;
    }

    private static class PooledPriorityThreadFactory
    implements ThreadFactory {
        private final String fName;
        private final int fThreadPriority;
        private int fThreadIndex;

        PooledPriorityThreadFactory(String name, int threadPriority) {
            this.fName = name;
            this.fThreadPriority = threadPriority;
            this.fThreadIndex = 1;
        }

        public Thread newThread(Runnable command) {
            Thread t = new Thread(command);
            t.setName(this.fName + " worker " + this.fThreadIndex);
            ++this.fThreadIndex;
            t.setPriority(this.fThreadPriority);
            return t;
        }
    }

    private static class PriorityRunnable
    implements Runnable,
    Comparable {
        Runnable fCommand;
        int fPriority;

        public PriorityRunnable(Runnable command, int priority) {
            this.fCommand = command;
            this.fPriority = priority;
        }

        public void run() {
            this.fCommand.run();
        }

        public int compareTo(Object o) {
            return this.fPriority - ((PriorityRunnable)o).fPriority;
        }

        public String toString() {
            return this.fCommand.toString();
        }
    }
}

