/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.jboss;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.ANameFormatter;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.WSNameCache;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.Map;

public class JBossServerNameFormatter
extends ANameFormatter {
    private IModuleFeedbackChannel logger = null;

    public JBossServerNameFormatter(IAgent agent) {
        super(agent);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    @Override
    public String getServiceName(InvocationData data) {
        String serviceURI = null;
        try {
            serviceURI = WSNameCache.getServiceName();
            if (serviceURI != null) {
                return serviceURI;
            }
            Object operationMetaData = this.getOperationMetaData(data);
            if (operationMetaData != null) {
                Object endpointMetaData = WSMUtils.invokeMethodOnObject(operationMetaData, "getEndpointMetaData");
                Object endpoint = WSMUtils.invokeMethodOnObject(endpointMetaData, "getEndpoint");
                serviceURI = (String)WSMUtils.invokeMethodOnObject(endpoint, "getAddress");
            }
        }
        catch (Throwable bomb) {
            String message = Thread.currentThread() + "JBossServerNameFormatter:: Caught unexpected exception while resolving web servicename" + bomb;
            WSMUtils.handleException(this.getAgent(), message, bomb);
        }
        this.getAgent().IAgent_getModuleFeedback().info("serviceURI = " + serviceURI);
        WSNameCache.setServiceName(serviceURI);
        return serviceURI == null || serviceURI.equals("") ? "UnknownService" : serviceURI;
    }

    public Object getOperationMetaData(InvocationData data) throws Exception {
        Object result = null;
        Object messageContext = this.getMessageContext(data);
        if (messageContext == null) {
            this.logger.debug("JBossServerNameFormatter getOperationMetaData (messageContext == null)");
            return null;
        }
        try {
            result = WSMUtils.invokeMethodOnObject(messageContext, "getOperationMetaData");
        }
        catch (Throwable throwable) {}
        return result;
    }

    @Override
    public String getNamespace(InvocationData data) {
        String namespaceURI = null;
        String operationName = null;
        try {
            namespaceURI = WSNameCache.getNamespaceURI();
            if (namespaceURI != null) {
                return namespaceURI;
            }
            Object operationMetaData = null;
            operationMetaData = this.getOperationMetaData(data);
            Object qName = null;
            if (operationMetaData != null) {
                try {
                    qName = WSMUtils.invokeMethodOnObject(operationMetaData, "getQName");
                    namespaceURI = (String)WSMUtils.invokeMethodOnObject(qName, "getNamespaceURI");
                    operationName = (String)WSMUtils.invokeMethodOnObject(operationMetaData, "getJavaName");
                }
                catch (Throwable throwable) {}
            } else {
                qName = this.getQName(data);
                namespaceURI = this.getNamespaceURIfromQName(qName);
                operationName = this.getOperationNamefromQName(qName);
            }
            if (namespaceURI == null || operationName == null) {
                Object soapMessage = this.getSoapMessage(data);
                qName = WSMUtils.invokeMethodOnObjectInClassHierarchy(soapMessage, "get", new Class[]{Object.class}, new Object[]{"javax.xml.ws.wsdl.operation"});
                namespaceURI = this.getNamespaceURIfromQName(qName);
                operationName = this.getOperationNamefromQName(qName);
            }
        }
        catch (Throwable bomb) {
            try {
                String message = "JBossServerNameFormatter:: Caught unexpected exception while resolving web service operation namespace URI from " + data.getInvocationObject().getClass() + " " + bomb;
                WSMUtils.handleException(this.getAgent(), message, bomb);
            }
            catch (Exception exception) {
                WSMUtils.handleException(this.getAgent(), "JBossServerNameFormatter:: Caught unexpected exception while resolving web service operation namespace URI", bomb);
            }
        }
        WSNameCache.setNamespaceURI(namespaceURI);
        WSNameCache.setOperationName(operationName);
        return namespaceURI == null || namespaceURI.equals("") ? "UnknownService" : namespaceURI;
    }

    public String getNamespaceURIfromQName(Object qName) {
        try {
            String operationInfo = (String)WSMUtils.invokeMethodOnObject(qName, "toString");
            if (operationInfo != null) {
                int beginIndex = operationInfo.indexOf(123);
                int endIndex = operationInfo.indexOf(125);
                return operationInfo.substring(beginIndex + 1, endIndex);
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    public String getOperationNamefromQName(Object qName) {
        try {
            String operationInfo = (String)WSMUtils.invokeMethodOnObject(qName, "toString");
            if (operationInfo != null) {
                int endIndex = operationInfo.indexOf(125);
                return operationInfo.substring(endIndex + 1);
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    public Object getMessageContext(InvocationData data) {
        Object result;
        block5: {
            result = null;
            try {
                if (data.getInvocationParameterCount() >= 2) break block5;
                this.logger.debug("JBossServerNameFormatter getOperationMetaData getInvocationParameterCount=" + data.getInvocationParameterCount() + " getInvocationObject()=" + data.getInvocationObject().getClass());
                return null;
            }
            catch (Throwable throwable) {}
        }
        Object invocation = data.getInvocationParameterAsObject(1);
        Object invocationContext = WSMUtils.invokeMethodOnObject(invocation, "getInvocationContext");
        ClassLoader threadClassLoader = invocationContext.getClass().getClassLoader();
        result = WSMUtils.invokeMethodOnObject(invocationContext, "getAttachment", new Class[]{Class.class}, new Object[]{Class.forName("javax.xml.ws.handler.MessageContext", true, threadClassLoader)});
        if (result == null) {
            result = WSMUtils.invokeMethodOnObject(invocationContext, "getAttachment", new Class[]{Class.class}, new Object[]{Class.forName("javax.xml.rpc.handler.MessageContext", true, threadClassLoader)});
        }
        if (result == null) {
            this.logger.debug("JBossServerNameFormatter getOperationMetaData (messageContext == null)");
            return null;
        }
        return result;
    }

    public Object getQName(InvocationData data) {
        Object result = null;
        Object messageContext = this.getMessageContext(data);
        if (messageContext != null) {
            try {
                result = WSMUtils.invokeMethodOnObjectInClassHierarchy(messageContext, "get", new Class[]{Object.class}, new Object[]{"javax.xml.ws.wsdl.operation"});
            }
            catch (Throwable throwable) {}
        }
        if (result == null) {
            Object endPoint = data.getInvocationParameterAsObject(0);
            try {
                WSMUtils.invokeMethodOnObject(endPoint, "getService");
                result = WSMUtils.invokeMethodOnObject(endPoint, "getName");
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    @Override
    public String getOperationName(InvocationData data) {
        Object qName;
        String operationName = null;
        try {
            operationName = WSNameCache.getOperationName();
            if (operationName != null) {
                return operationName;
            }
            Object operationMetaData = this.getOperationMetaData(data);
            if (operationMetaData != null) {
                operationName = (String)WSMUtils.invokeMethodOnObject(operationMetaData, "getJavaName");
                this.getAgent().IAgent_getModuleFeedback().debug("JBossServerNameFormatter:: getOperationName operationName= " + operationName);
            }
        }
        catch (Throwable bomb) {
            try {
                try {
                    Object objClientImpl = data.getInvocationObject();
                    Map mapRequestContext = (Map)objClientImpl.getClass().getMethod("getRequestContext", new Class[0]).invoke(objClientImpl, new Object[0]);
                    operationName = (String)mapRequestContext.get("com.wily.powerpack.webservices.trace.OperationNameKey");
                }
                catch (Exception exception) {}
                if (operationName == null) {
                    String message = "JBossServerNameFormatter::  Caught unexpected exception while resolving web service operation name from " + data.getInvocationObject().getClass() + " " + bomb;
                    WSMUtils.handleException(this.getAgent(), message, bomb);
                }
            }
            catch (Exception exception) {
                WSMUtils.handleException(this.getAgent(), "JBossServerNameFormatter:: Caught unexpected exception while resolving web service operation name", bomb);
            }
        }
        if ((operationName == null || "".equals(operationName)) && (qName = this.getQName(data)) != null) {
            operationName = this.getOperationNamefromQName(qName);
        }
        WSNameCache.setOperationName(operationName);
        return operationName == null || operationName.equals("") ? "UnknownOperationName" : operationName;
    }

    public Object getSoapMessage(InvocationData data) {
        Object result = null;
        try {
            Object messageContext = this.getMessageContext(data);
            if (messageContext != null) {
                result = WSMUtils.getField(messageContext, "message");
            }
        }
        catch (Throwable throwable) {}
        return result;
    }
}

