/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.remote;

import com.wily.introscope.agent.remote.IRemoteAgent;
import com.wily.introscope.agent.remote.arf.ArfMessage;
import com.wily.introscope.agent.trace.IMethodTracer;
import com.wily.introscope.agent.trace.IParameterizedMethodTracer;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class RemoteMethodTracer
implements IMethodTracer,
IParameterizedMethodTracer {
    private final IRemoteAgent fAgent;
    private Object fInvocationObject;
    private final Object fSampleTrObject;
    private final String fProbeClassName;
    private final String fProbeMethodName;
    private final String fProbeMethodDescriptor;
    private final String fTid;
    private final long fSequenceNumber;

    public RemoteMethodTracer(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, Object tracedObject, String tracerEncoding, IRemoteAgent agent) {
        this.fAgent = agent;
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        if (feedback.isDebugEnabled()) {
            String msg = "Remote Method Tracer: load trace ";
            if (tracedObject != null) {
                msg = String.valueOf(msg) + tracerEncoding;
            }
            feedback.debug(msg);
        }
        this.fSampleTrObject = tracedObject;
        this.fProbeClassName = probeClassName;
        this.fProbeMethodName = probeMethodName;
        this.fProbeMethodDescriptor = probeMethodDescriptor;
        this.fSequenceNumber = agent.getNextSequence();
        this.fTid = String.valueOf(agent.getThreadId()) + ": " + Thread.currentThread().getName();
    }

    @Override
    public void IParameterizedMethodTracer_setParameter(int index, byte value) {
    }

    @Override
    public void IParameterizedMethodTracer_setParameter(int index, char value) {
    }

    @Override
    public void IParameterizedMethodTracer_setParameter(int index, double value) {
    }

    @Override
    public void IParameterizedMethodTracer_setParameter(int index, float value) {
    }

    @Override
    public void IParameterizedMethodTracer_setParameter(int index, int value) {
    }

    @Override
    public void IParameterizedMethodTracer_setParameter(int index, long value) {
    }

    @Override
    public void IParameterizedMethodTracer_setParameter(int index, short value) {
    }

    @Override
    public void IParameterizedMethodTracer_setParameter(int index, boolean value) {
    }

    @Override
    public void IParameterizedMethodTracer_setParameter(int index, Object value) {
    }

    @Override
    public void IParameterizedMethodTracer_setReturnValue(byte value) {
    }

    @Override
    public void IParameterizedMethodTracer_setReturnValue(char value) {
    }

    @Override
    public void IParameterizedMethodTracer_setReturnValue(double value) {
    }

    @Override
    public void IParameterizedMethodTracer_setReturnValue(float value) {
    }

    @Override
    public void IParameterizedMethodTracer_setReturnValue(int value) {
    }

    @Override
    public void IParameterizedMethodTracer_setReturnValue(long value) {
    }

    @Override
    public void IParameterizedMethodTracer_setReturnValue(short value) {
    }

    @Override
    public void IParameterizedMethodTracer_setReturnValue(boolean value) {
    }

    @Override
    public void IParameterizedMethodTracer_setReturnValue(Object value) {
    }

    @Override
    public void IParameterizedMethodTracer_setThrownException(Object exception) {
    }

    @Override
    public void IMethodTracer_startTrace() {
        ArfMessage m = new ArfMessage("fnC");
        m.setFn(String.valueOf(this.fProbeClassName) + "." + this.fProbeMethodName + " " + this.fProbeMethodDescriptor);
        m.setTs(System.currentTimeMillis());
        m.setSeq(this.fSequenceNumber);
        m.setTid(this.fTid);
        this.fAgent.sendEventMessage(m.writeMessage());
    }

    @Override
    public void IMethodTracer_setInvocationObject(Object o) {
        this.fInvocationObject = o;
    }

    @Override
    public void IMethodTracer_finishTrace() {
        ArfMessage m = new ArfMessage("fnR");
        m.setCseq(this.fSequenceNumber);
        m.setTs(System.currentTimeMillis());
        m.setTid(this.fTid);
        this.fAgent.sendEventMessage(m.writeMessage());
    }

    @Override
    public boolean IMethodTracer_shouldStub() {
        return false;
    }

    @Override
    public void IMethodTracer_setShouldStub(boolean flag) {
    }

    @Override
    public void IMethodTracer_setReentrancyOverwrite(boolean flag) {
    }
}

