/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument.attach.transformers;

import com.wily.introscope.api.instrument.ContinuousRetransformer;
import com.wily.introscope.api.instrument.JavaAgent;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;

public class ClassLoaderTransformer
implements ClassFileTransformer {
    private void hackProtected(Method method) throws Exception {
        method.setAccessible(true);
        Field modifiersField = Method.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(method, method.getModifiers() & 0xFFFFFFFB | 1);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        String targetClassName = "java/lang/ClassLoader";
        if (className.equals(targetClassName) && classBeingRedefined != null) {
            try {
                System.out.println("CA APM: Gaining Access to ClassLoader");
                Method m = classBeingRedefined.getDeclaredMethod("findLoadedClass", String.class);
                this.hackProtected(m);
                JavaAgent.bootstrapRetransformLatch.countDown();
                ContinuousRetransformer.findLoadedClass = m;
            }
            catch (SecurityException securityException) {
                System.out.println("Failed to access findLoadedClass");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("Failed to find findLoadedClass");
            }
            catch (Exception exception) {
                System.out.println("Failed to modify findLoadedClass");
            }
        }
        return null;
    }
}

