/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.directives.parser.DGInvalidFlagNameException;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.IOverheadManager;
import com.wily.introscope.agent.transformer.dynamic.IDirectiveLoadListener;
import com.wily.introscope.agent.transformer.dynamic.IOverheadHandler;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.introscope.agent.transformer.dynamic.OverheadSettings;
import com.wily.introscope.autoprobe.AbsoluteLowModeOverheadHandler;
import com.wily.introscope.autoprobe.NormalModeOverheadHandler;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.Map;

public class OverheadManagementHelper
implements IDirectiveLoadListener {
    private IAgent fAgent;
    private IModuleFeedbackChannel fFeedback;
    private Module kModule = new Module("OverheadManagement");
    private final IOverheadManager fOverheadManager;
    public static final String AGENT_OBVERHEAD_CONTROL_KEY = "introscope.agent.overhead.level";
    private static volatile boolean defaultSettingsInitialized = false;
    private static volatile String overheadModeAsString;

    public OverheadManagementHelper(IAgent agent) {
        this.fAgent = agent;
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fOverheadManager = this.fAgent.IAgent_getOverheadManager();
        OverheadSettings.setInitialAgentProperties(agent.IAgent_getIndexedProperties());
        OverheadSettings.registerOverheadHandler(OverheadMode.ABSOLUTE_LOW, new AbsoluteLowModeOverheadHandler());
        OverheadSettings.registerOverheadHandler(OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND, new AbsoluteLowModeOverheadHandler());
        OverheadSettings.registerOverheadHandler(OverheadMode.DEFAULT, new NormalModeOverheadHandler());
    }

    public void updateTracerGroupBuilders(CompilerSettingsBuilder builder) {
        Map<String, Boolean> overheadMap;
        OverheadMode overheadMode = OverheadAdministrator.getOverheadMode();
        String overheadModeProperty = this.fAgent.IAgent_getIndexedProperties().getProperty(AGENT_OBVERHEAD_CONTROL_KEY, "Normal");
        if (overheadMode == null) {
            return;
        }
        overheadModeAsString = overheadModeProperty;
        if (overheadMode != null && (overheadMode == OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND || OverheadMode.ABSOLUTE_LOW == overheadMode || OverheadMode.DEFAULT == overheadMode)) {
            overheadMode.getOverheadSettings();
            IOverheadHandler overheadHandler = OverheadSettings.getOverheadHandler(overheadMode);
            if (overheadHandler != null) {
                overheadHandler.setCompilerSettingsBuilder(builder);
                overheadHandler.controlOverhead(overheadMode.getOverheadSettings());
                return;
            }
        }
        if (this.fOverheadManager != null && (overheadMap = this.fOverheadManager.getTracerGroupMap()) != null) {
            for (String tracerGroupName : overheadMap.keySet()) {
                try {
                    FlagName fn = FlagName.getFlagName(tracerGroupName);
                    TracerGroupBuilder tg = builder.findTracerGroupBuilder(fn);
                    if (tg == null) {
                        this.fFeedback.error(this.kModule, "Unknown tracer group: " + tracerGroupName);
                        continue;
                    }
                    if (!tg.isChangeable() || OverheadSettings.isUnchangeable(tg.getName().getName())) {
                        this.fFeedback.warn(this.kModule, "Changing tracer group: " + tracerGroupName + " requires agent restart.");
                        continue;
                    }
                    Boolean b = overheadMap.get(tracerGroupName);
                    this.fFeedback.trace(this.kModule, "Inspecting tracer group: " + tg.getName().toString() + " isChangeable =  " + tg.isChangeable());
                    if (b == null) continue;
                    tg.setEnabled(b);
                    this.fFeedback.debug(this.kModule, "Setting tracer group: " + tg.getName().toString() + " isEnabled = " + b);
                }
                catch (DGInvalidFlagNameException dGInvalidFlagNameException) {
                    this.fFeedback.error(this.kModule, "Invalid tracer group: " + tracerGroupName);
                }
            }
        }
    }

    @Override
    public void notifyDirectivesLoaded(Object dgCompilerSettigs) {
        Map<String, Boolean> overheadMap;
        if (dgCompilerSettigs instanceof DGCompilerSettings) {
            if (!defaultSettingsInitialized) {
                DGCompilerSettings cfr_ignored_0 = (DGCompilerSettings)dgCompilerSettigs;
            }
            String overheadModeProperty = this.fAgent.IAgent_getIndexedProperties().getProperty(AGENT_OBVERHEAD_CONTROL_KEY, "Normal");
            if (OverheadAdministrator.getOverheadMode() == null || "Normal".equalsIgnoreCase(overheadModeProperty)) {
                return;
            }
            DGCompilerSettings s = (DGCompilerSettings)dgCompilerSettigs;
            s.getGroupInstrumentableMap();
            OverheadMode overheadMode = OverheadAdministrator.getOverheadMode();
            if (overheadMode != null && (overheadMode == OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND || OverheadMode.ABSOLUTE_LOW == overheadMode)) {
                overheadMode.getOverheadSettings();
                IOverheadHandler overheadHandler = OverheadSettings.getOverheadHandler(overheadMode);
                if (overheadHandler != null) {
                    overheadHandler.controlOverhead(overheadMode.getOverheadSettings());
                    return;
                }
            }
        }
        DGCompilerSettings s = (DGCompilerSettings)dgCompilerSettigs;
        Map groups = s.getGroupInstrumentableMap();
        if (this.fOverheadManager != null && (overheadMap = this.fOverheadManager.getTracerGroupMap()) != null) {
            for (TracerGroup tg : groups.keySet()) {
                Boolean instrumentable = (Boolean)groups.get(tg);
                Boolean b = overheadMap.get(tg.getName().toString());
                this.fFeedback.trace(this.kModule, "Inspecting tracer group: " + tg.toString() + ", instrumentable = " + instrumentable.toString() + " isLockedDisabled =  " + tg.isLockedDisabled() + " isChangeable  =" + tg.isChangeable());
                if (b == null) continue;
                tg.setEnabled(b);
                this.fFeedback.info(this.kModule, "Setting tracer group: " + tg.toString() + " isEnabled = " + b);
            }
        }
    }

    @Override
    public void notifyRedefinitionComplete() {
    }

    public static String getOverheadMode() {
        return overheadModeAsString;
    }
}

