/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing.layout;

import com.wily.properties.KUIErrorMessagesKeys;
import com.wily.util.StringUtils;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.validate.IValidatable;
import com.wily.util.validate.IdentifiableObjectValidationException;
import com.wily.util.validate.KValidationConstants;
import com.wily.util.validate.ValidationException;
import java.awt.Component;

public class TitleComponentPair
implements KValidationConstants,
KUIErrorMessagesKeys {
    private String fTitle;
    private Component fComponent;
    private double fComponentWeightX;
    private int fComponentFill;
    private int fVerticalAnchor;
    private boolean fCustomConstraints = false;

    public TitleComponentPair(String title, Component component) {
        this(title, component, 10);
    }

    public TitleComponentPair(String title, Component component, int verticalAnchor) {
        this.fTitle = title;
        this.fComponent = component;
        this.fVerticalAnchor = verticalAnchor;
        this.fComponentWeightX = 0.0;
        this.fComponentFill = 0;
    }

    public void setVerticalAnchor(int anchor) {
        this.fVerticalAnchor = anchor;
    }

    public int getVerticalAnchor() {
        return this.fVerticalAnchor;
    }

    public int getComponentFill() {
        return this.fComponentFill;
    }

    public void setComponentFill(int componentFill) {
        this.fCustomConstraints = true;
        this.fComponentFill = componentFill;
    }

    public double getComponentWeightX() {
        return this.fComponentWeightX;
    }

    public void setComponentWeightX(double componentGridWidth) {
        this.fCustomConstraints = true;
        this.fComponentWeightX = componentGridWidth;
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public boolean isCustomConstraints() {
        return this.fCustomConstraints;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void IValidatable_validate() throws ValidationException {
        this.IValidatable_validate(0);
    }

    public void IValidatable_validate(int validationConstraints) throws ValidationException {
        Component component = this.getComponent();
        if (component instanceof IValidatable) {
            IValidatable validatableComponent = (IValidatable)((Object)component);
            try {
                validatableComponent.IValidatable_validate(validationConstraints);
            }
            catch (IdentifiableObjectValidationException e) {
                if (!StringUtils.isEmpty(this.getTitle())) {
                    FormattedLocalizableMessage invalidObjectIdentifier = new FormattedLocalizableMessage("Validation_Invalid_Object_Identifier", this.getTitle(), false);
                    throw new IdentifiableObjectValidationException(e.getUserMessagePrefix(), invalidObjectIdentifier, e.getInvalidObjectRequiredCondition());
                }
                throw e;
            }
        }
    }
}

