/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.db;

import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.db.ConnectionManager;
import com.wily.introscope.agent.db.DatabaseQueryDelegate;
import com.wily.introscope.agent.db.DeepInheritanceHelper;
import com.wily.introscope.agent.transformer.dynamic.IDeepInheritanceHelper;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationDelegate;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.autoprobe.IAutoProbeConfig;
import com.wily.introscope.autoprobe.ICompilerLogger;
import com.wily.util.INameChangeListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.task.IExecutableItem;
import java.lang.instrument.Instrumentation;

public class DatabaseManager {
    protected static boolean fHasInitialized = false;
    private static final Module fModule = new Module("Database Manager");
    private static final String kDeepInheritanceEnablingProperty = "introscope.autoprobe.deepinheritance.enabled";
    private final DeepInheritanceEnabledConfigurationProperty fDeepInheritanceEnabledProperty;

    public DatabaseManager(final IAgent agent, final IDynamicInstrumentationTransformer transformer, final ICompilerLogger logger, IAutoProbeConfig configRepository, Instrumentation instrumentation) {
        final IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        if (feedback.isDebugEnabled()) {
            feedback.debug(fModule, "Adding listener to EM");
        }
        INameChangeListener listener = new INameChangeListener(){

            public void INameChangeListener_nameChanged(String newName) {
                if (feedback.isDebugEnabled()) {
                    feedback.debug(fModule, "Dynamic Instrumentation is noticing that the negotiated name of the agent changed to " + newName);
                }
                transformer.getDynamicInstrumentationService().setRepositoryName(newName);
                if (feedback.isDebugEnabled()) {
                    feedback.debug(fModule, "Dynamic Instrumentation has reset the repository name");
                }
            }
        };
        agent.IAgent_addNameChangeListener(listener);
        if (feedback.isDebugEnabled()) {
            feedback.debug(fModule, "Listener to EM added");
        }
        if (feedback.isDebugEnabled()) {
            feedback.debug(fModule, "Adding Deep Inheritance helper to Service");
        }
        this.fDeepInheritanceEnabledProperty = new DeepInheritanceEnabledConfigurationProperty(agent);
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        cm.add((ConfigurationProperty)this.fDeepInheritanceEnabledProperty, true);
        if (this.fDeepInheritanceEnabledProperty.isEnabled()) {
            feedback.info(fModule, "Enabled support for deep inheritance");
            DeepInheritanceHelper.getInstance().startClassCache(agent.IAgent_getConfigHeartbeat(), feedback, 600000L, 30000L);
            transformer.getDynamicInstrumentationService().setDeepInheritanceHelper((IDeepInheritanceHelper)DeepInheritanceHelper.getInstance());
        }
        if (feedback.isDebugEnabled()) {
            feedback.debug(fModule, "Helper added to Service");
        }
        agent.IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem(new IExecutableItem(){

            public void IExecutableItem_execute() {
                DatabaseManager.this.registerDatabaseDelegate(agent, transformer, logger);
            }

            public void IExecutableItem_executionAborted() {
                agent.IAgent_getModuleFeedback().warn(fModule, "Registration of Database Manager aborted");
            }

            public boolean IExecutableItem_shouldStillExecute() {
                return true;
            }
        });
    }

    private void registerDatabaseDelegate(final IAgent agent, final IDynamicInstrumentationTransformer transformer, final ICompilerLogger logger) {
        IRegisteredBehavior behavior;
        final IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        WaitForConnectionRunnable target = new WaitForConnectionRunnable(){

            public void ITimestampedRunnable_execute(long nowInMillis) {
                IsengardServerConnectionManager manager = agent.IAgent_getIsengardServerConnection();
                if (manager != null && manager.getConnectedServer() != null && manager.getConnectedServer().isConnected() && transformer.getClassRedefinitionDelegate() != null) {
                    if (!fHasInitialized) {
                        feedback.info(fModule, "Initializing Database Delegate");
                        ICompilerLog log = logger.getCompilerLog();
                        ConnectionManager.setPath(log.ICompilerLog_getPath());
                        if (feedback.isDebugEnabled()) {
                            feedback.debug(fModule, "Adding database query delegate to agent");
                        }
                        DatabaseQueryDelegate databaseDelegate = new DatabaseQueryDelegate();
                        transformer.getDynamicInstrumentationService().addServiceDelegate((IDynamicInstrumentationDelegate)databaseDelegate);
                        if (feedback.isDebugEnabled()) {
                            feedback.debug(fModule, "Added database query delegate to agent");
                        }
                        feedback.info(fModule, "Database Delegate initialized successfully");
                        fHasInitialized = true;
                    }
                    if (fHasInitialized && this.behaviorHandle != null) {
                        this.behaviorHandle.close();
                    }
                }
            }
        };
        target.behaviorHandle = behavior = agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)target, "Waiting for Database Dynamic", true, 1000L, System.currentTimeMillis() + 1000L);
    }

    private static final class DeepInheritanceEnabledConfigurationProperty
    extends BooleanConfigurationProperty {
        boolean value;

        private DeepInheritanceEnabledConfigurationProperty(IAgent agent) {
            super(DatabaseManager.kDeepInheritanceEnablingProperty, Boolean.TRUE, agent.IAgent_getModuleFeedback(), fModule, agent.IAgent_getStringLocalizer());
        }

        public final boolean isEnabled() {
            return this.value;
        }

        public void set(Object newValue) {
            this.value = (Boolean)newValue;
        }
    }

    static abstract class WaitForConnectionRunnable
    implements ITimestampedRunnable {
        IRegisteredBehavior behaviorHandle;

        WaitForConnectionRunnable() {
        }
    }
}

