/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.utils.Multimap;
import com.wily.util.extension.IExtension;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JPMSClassFileTransformerImpl
implements ClassFileTransformer {
    private WeakReference<Instrumentation> instrumentationObj;
    private Set<Module> unnamedModules = new HashSet<Module>();
    private Multimap<String, String> exportList;
    private List<String> exportHistory = new ArrayList<String>();
    private boolean exportEverything;
    private IModuleFeedbackChannel logger;

    public JPMSClassFileTransformerImpl(Instrumentation instrumentation, String extraExports) throws Exception {
        try {
            this.logger = AgentShim.getAgent().IAgent_getModuleFeedback();
            this.logger.info("Using Modular (java9+) ClassFileTransformer");
            this.instrumentationObj = new WeakReference<Instrumentation>(instrumentation);
            this.initializeUnnamedModules();
            this.exportList = this.prepareExportOpenList(extraExports);
            this.logger.info("Module Export list: " + this.exportList);
            this.logDebugMsg(String.format(" Agent Loader: %s, Agent Module: %s", this.getClass().getClassLoader(), this.getClass().getModule()));
            this.processAlreadyLoadedClasses();
        }
        catch (Exception e) {
            this.logDebugMsg("UnExpected Error initialising JPMS ClassFileTransformer " + e);
            throw new Exception("UnExpected Error initialising JPMS ClassFileTransformer " + e);
        }
    }

    public void addExtensionCL(List<IExtension> extensionsList) {
        String log_prefix = "[IntroscopeAgent.Agent] ";
        try {
            System.out.println(log_prefix + "Giving access to agent core extensions...");
            for (IExtension extension : extensionsList) {
                try {
                    ClassLoader extensionCL = extension.IExtension_getClassLoader();
                    this.unnamedModules.add(extensionCL.getUnnamedModule());
                }
                catch (Exception log) {
                    System.out.println(log_prefix + "Error adding extensionCL unnamed module for extension: " + log);
                }
            }
        }
        catch (Exception suppress) {
            System.out.println(log_prefix + "Error adding extensionCL: " + suppress);
        }
    }

    private void processAlreadyLoadedClasses() {
        if (this.exportList.size() != 0 || this.exportEverything) {
            for (Class currentItem : ((Instrumentation)this.instrumentationObj.get()).getAllLoadedClasses()) {
                if (this.exportList.size() == 0 && !this.exportEverything) break;
                this.validateAndRedefine(currentItem.getModule(), currentItem.getName());
            }
        }
    }

    private void initializeUnnamedModules() {
        this.unnamedModules.add(this.getClass().getModule());
    }

    private Multimap<String, String> prepareExportOpenList(String extraExports) {
        Multimap<String, String> exportList = new Multimap<String, String>();
        exportList.put("jdk.management", "com.sun.management.internal");
        exportList.put("java.instrument", "sun.instrument");
        try {
            if (extraExports != null) {
                String[] modulesPackages;
                for (String item : modulesPackages = extraExports.split("#")) {
                    String exportItem = item.trim();
                    if (exportItem.equals("*") || exportItem.equals("*/*")) {
                        exportList.clear();
                        this.exportEverything = true;
                        return exportList;
                    }
                    String[] expKV = exportItem.split("/");
                    if (expKV == null || expKV.length != 2) continue;
                    String key1 = expKV[0].trim();
                    String val1 = expKV[1].trim();
                    if (exportList.get(key1).contains(val1)) continue;
                    exportList.put(key1, val1);
                }
            }
        }
        catch (Exception ignore) {
            this.logDebugMsg("Error in processing extra exports: " + ignore);
        }
        return exportList;
    }

    @Override
    public byte[] transform(Module module, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        this.validateAndRedefine(module, className);
        return null;
    }

    private void validateAndRedefine(Module m, String className) {
        block13: {
            try {
                if (this.exportList.size() == 0 && !this.exportEverything) {
                    this.logger.info("Removing JPMS CFL since all redefinitions are done.");
                    ((Instrumentation)this.instrumentationObj.get()).removeTransformer(this);
                    return;
                }
                if (m == null || m.getName() == null) {
                    return;
                }
                String moduleName = m.getName();
                if (this.instrumentationObj.get() != null && !((Instrumentation)this.instrumentationObj.get()).isModifiableModule(m)) {
                    this.logDebugMsg(String.format("Module %s is not modifiable ", moduleName));
                    return;
                }
                if (this.exportEverything) {
                    HashMap<String, Set<Module>> extraExports = new HashMap<String, Set<Module>>();
                    if (!this.exportHistory.contains(moduleName)) {
                        this.exportHistory.add(moduleName);
                        for (String currentPackage : m.getPackages()) {
                            extraExports.put(currentPackage, this.unnamedModules);
                        }
                        this.logDebugMsg("about to redefine " + className);
                        this.doRedefine(m, null, extraExports, null);
                    }
                    break block13;
                }
                if (!this.exportList.containsKey(moduleName)) break block13;
                Collection<String> packages = this.exportList.remove(moduleName);
                HashMap<String, Set<Module>> extraExports = new HashMap<String, Set<Module>>();
                Set<String> modulePackages = m.getPackages();
                if (packages.contains("*")) {
                    for (String currentPackage : modulePackages) {
                        extraExports.put(currentPackage, this.unnamedModules);
                    }
                } else {
                    for (String currentPackage : packages) {
                        if (!modulePackages.contains(currentPackage)) continue;
                        extraExports.put(currentPackage, this.unnamedModules);
                    }
                }
                this.logDebugMsg("about to redefine " + className);
                this.doRedefine(m, null, extraExports, null);
            }
            catch (Exception exp) {
                this.logDebugMsg("Exception in validateAndRedefine: " + exp);
            }
            catch (Error err) {
                this.logDebugMsg("Error in validateAndRedefine: " + err);
            }
        }
    }

    private void doRedefine(Module m, Set<Module> extraReads, Map<String, Set<Module>> extraExports, Map<String, Set<Module>> extraOpens) throws Exception {
        try {
            if (this.instrumentationObj.get() != null && extraExports.size() != 0) {
                this.logger.info("Redefining " + m.getName() + ": " + extraExports);
                ((Instrumentation)this.instrumentationObj.get()).redefineModule(m, extraReads == null ? Set.of() : extraReads, extraExports == null ? Map.of() : extraExports, extraOpens == null ? Map.of() : extraOpens, Set.of(), Map.of());
            }
        }
        catch (Exception e) {
            throw new Exception("Error in doRedefine: " + e);
        }
    }

    private void logDebugMsg(String msg) {
        try {
            this.logger.debug(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

