/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import java.net.URI;
import java.net.URISyntaxException;

public class NexusLocator {
    private String fNexusHostName;
    private int fNexusPort;
    private String fAutofillEnable;
    private String fNexusProxy;
    private String fNexusTenant;
    private String fNexusToken;
    private boolean fIsAxaToken;

    public NexusLocator() {
    }

    public NexusLocator(String nexusHostName, int nexusHostPort) {
        this.setNexusHostName(nexusHostName);
        this.setNexusPort(nexusHostPort);
    }

    public NexusLocator(String nexusHostName, String nexusHostPortString) {
        this.setNexusHostName(nexusHostName);
        this.setNexusPort(nexusHostPortString);
    }

    public NexusLocator(String nexusHostName, int nexusHostPort, String autofillEnable) {
        this.setNexusHostName(nexusHostName);
        this.setNexusPort(nexusHostPort);
        this.setNexusAutofillEnabled(autofillEnable);
    }

    public NexusLocator(String nexusHostName, String nexusHostPortString, String autofillEnable) {
        this.setNexusHostName(nexusHostName);
        this.setNexusPort(nexusHostPortString);
        this.setNexusAutofillEnabled(autofillEnable);
    }

    public String getNexusHostName() {
        return this.fNexusHostName;
    }

    public void setNexusHostName(String nexusHostName) {
        this.fNexusHostName = nexusHostName;
    }

    public String getNexusProxy() {
        return this.fNexusProxy;
    }

    public String getNexusToken() {
        return this.fNexusToken;
    }

    public boolean isAxaToken() {
        return this.fIsAxaToken;
    }

    public void setNexusProxy(String nexusProxy) {
        this.fNexusProxy = nexusProxy;
    }

    public String getNexusTenant() {
        return this.fNexusTenant;
    }

    public void setNexusTenant(String nexusTenant) {
        this.fNexusTenant = nexusTenant;
    }

    public void setNexusToken(String nexusToken) {
        this.fNexusToken = nexusToken;
    }

    public void setIsAxaToken(boolean isAxaToken) {
        this.fIsAxaToken = isAxaToken;
    }

    public int getNexusPort() {
        return this.fNexusPort;
    }

    public String getNexusPortString() {
        return Integer.toString(this.getNexusPort());
    }

    public void setNexusPort(String nexusPortName) {
        this.fNexusPort = Integer.parseInt(nexusPortName);
    }

    public void setNexusPort(int nexusPort) {
        this.fNexusPort = nexusPort;
    }

    public void setNexusAutofillEnabled(String autofillEnable) {
        this.fAutofillEnable = autofillEnable;
    }

    public String getNexusAutofillEnabled() {
        return this.fAutofillEnable;
    }

    public String toString() {
        if (this.fNexusProxy != null) {
            return "NexusLocator: proxy=" + this.getNexusProxy();
        }
        return "NexusLocator: host=" + this.getNexusHostName() + " port=" + this.getNexusPortString();
    }

    public String getNexusUiHostName() {
        if (this.fNexusHostName != null) {
            return this.fNexusHostName;
        }
        if (this.fNexusProxy != null) {
            try {
                UriBuilder uri = UriBuilder.fromString(this.fNexusProxy);
                return uri.getHost();
            }
            catch (Exception exception) {
                return this.fNexusProxy;
            }
        }
        return "";
    }

    public String getNexusUiPortString() {
        if (this.fNexusProxy != null) {
            try {
                UriBuilder uri = UriBuilder.fromString(this.fNexusProxy);
                if (uri.getPort() != -1) {
                    return Integer.toString(uri.getPort());
                }
            }
            catch (Exception exception) {}
        }
        return this.getNexusPortString();
    }

    public static class UriBuilder {
        private String scheme;
        private String host;
        private int port;
        private String path;
        private StringBuilder query;

        private UriBuilder(URI uri) {
            this.scheme = uri.getScheme();
            this.host = uri.getHost();
            this.port = uri.getPort();
            this.path = uri.getPath();
            this.query = new StringBuilder();
        }

        private UriBuilder(String host, int port) {
            this.host = host;
            this.port = port;
            this.query = new StringBuilder();
        }

        public static UriBuilder fromUri(URI uri) {
            return new UriBuilder(uri);
        }

        public static UriBuilder fromString(String uriStr) throws URISyntaxException {
            URI uri = new URI(uriStr);
            if (uri.getHost() == null) {
                int colonIdx = uriStr.indexOf(58);
                if (colonIdx > 0) {
                    int port = -1;
                    try {
                        port = Integer.parseInt(uriStr.substring(colonIdx + 1));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    return new UriBuilder(uriStr.substring(0, colonIdx), port);
                }
                return new UriBuilder(uriStr, -1);
            }
            return new UriBuilder(uri);
        }

        public UriBuilder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public UriBuilder host(String host) {
            this.host = host;
            return this;
        }

        public UriBuilder path(String path) {
            this.path = path;
            return this;
        }

        public UriBuilder queryParam(String key, String value) {
            if (this.query.length() != 0) {
                this.query.append('&');
            }
            this.query.append(key);
            this.query.append('=');
            this.query.append(value);
            return this;
        }

        public URI build() {
            try {
                return new URI(this.scheme, null, this.host, this.port, this.path, this.query.length() == 0 ? null : this.query.toString(), null);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException();
            }
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

