/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.FaultFeature;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.cas.AAgentMetricArray;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.SharedDataStructure2;
import com.wily.introscope.agent.trace.hc2.AverageMetricGathererWrapper;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.CountMetricGathererWrapper;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.powerpack.webservices.KConstants;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WebServiceBlamePointTracer
extends BlamePointTracer
implements IInvocationDataParameterCallback,
KConstants {
    private IModuleFeedbackChannel logger = null;
    private static final String kServiceTag = "service";
    private static final String faultsAttrSuffix = ":SOAP Faults Per Interval";

    protected boolean subscribeToDownstreamErrors() {
        return this.isServiceContext();
    }

    protected boolean subscribeToDownstreamStalls() {
        return true;
    }

    protected boolean subscribeToDownstreamFaults() {
        return this.isServiceContext();
    }

    public WebServiceBlamePointTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        data.setParameterCallback((IInvocationDataParameterCallback)this);
        this.doStartBlamePointTrace(tracerIndex, data);
    }

    protected boolean isServiceContext() {
        return this.getParameter(kServiceTag) != null;
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        String nameSpace = (String)data.get("com.wily.powerpack.webservices.trace.NamespaceKey");
        String serviceName = (String)data.get("com.wily.powerpack.webservices.trace.ServiceNameKey");
        String operationName = (String)data.get("com.wily.powerpack.webservices.trace.OperationNameKey");
        if (operationName == null || operationName.length() == 0) {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("WebServiceBlamePointTracer:ITracer_startTrace : operationname is null, using method name");
            }
            operationName = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("WebServiceBlamePointTracer : namespace" + nameSpace);
            this.logger.debug("WebServiceBlamePointTracer : serviceName" + serviceName);
            this.logger.debug("WebServiceBlamePointTracer : operationName" + operationName);
        }
        if (serviceName != null && serviceName.length() > 0) {
            parameters.put("namespace", serviceName);
        }
        if (nameSpace != null && nameSpace.length() > 0) {
            parameters.put("namespace", nameSpace);
        }
        if (operationName != null && operationName.length() > 0) {
            parameters.put("operationname", operationName);
        }
    }

    protected AgentMetric[] createFaultsMetric(String formattedMetricName) {
        int metricType = 8194;
        AgentMetric metric = this.getDataAccumulatorFactory().safeGetMetricOfType(formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        return new AgentMetric[]{metric};
    }

    protected String getFormattedMetricName(String componentName) {
        String formattedMetricName = null;
        if (componentName != null) {
            formattedMetricName = String.valueOf(componentName) + faultsAttrSuffix;
        }
        return formattedMetricName;
    }

    protected WilyTransactionElement constructTransactionElement(Object key, String metricName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, ProbeInformation info) {
        HashMap<IRepository, AgentMetric[]> metrics = new HashMap<IRepository, AgentMetric[]>(5);
        IRepository concurrentSds = null;
        IRepository existingSds = null;
        IRepository timerSds = null;
        IRepository stallSds = null;
        IRepository errorsSds = null;
        IRepository perIntervalSds = null;
        ArrayList<AgentMetric> metricsForGrouping = new ArrayList<AgentMetric>(6);
        AgentMetric[] concurrentMetric = this.createConcurrentInvocationMetric(this.getConcurrentInvocationMetricName(metricName));
        existingSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)new AAgentMetricArray(concurrentMetric), (IRepository)(concurrentSds = this.getSharedRepositoryNoSharedStructure(false)));
        if (existingSds != null) {
            concurrentSds = existingSds;
        }
        metricsForGrouping.add(concurrentMetric[0]);
        AgentMetric[] timerMetric = this.createTimerMetric(this.getTimerMetricName(metricName));
        AverageMetricGathererWrapper timerWrapper = AverageMetricGathererWrapper.getFactory((boolean)true);
        timerSds = this.getSharedRepository((ISharedElement)timerWrapper);
        metrics.put(timerSds, timerMetric);
        metricsForGrouping.add(timerMetric[0]);
        AgentMetric[] perIntervalMetric = this.createPerIntervalMetric(this.getPerIntervalMetricName(metricName));
        perIntervalSds = this.getSharedRepository(true);
        metrics.put(perIntervalSds, perIntervalMetric);
        metricsForGrouping.add(perIntervalMetric[0]);
        if (this.shouldForceStandardBlameMetrics()) {
            AgentMetric[] stallMetric = this.createStallsMetric(this.getStallsMetricName(metricName));
            stallSds = this.getSharedRepositoryNoSharedStructure(false);
            metrics.put(stallSds, stallMetric);
            metricsForGrouping.add(stallMetric[0]);
            AgentMetric[] errorMetric = this.createErrorsMetric(this.getErrorsMetricName(metricName));
            errorsSds = this.getSharedRepository(true);
            metrics.put(errorsSds, errorMetric);
            metricsForGrouping.add(errorMetric[0]);
        }
        AgentMetric[] faultMetric = this.createFaultsMetric(this.getFormattedMetricName(metricName));
        metricsForGrouping.add(faultMetric[0]);
        this.getAgent().IAgent_getMetricRecordingAdministrator().addMetricGroup(metricName, metricsForGrouping);
        return FaultFeature.createFaultedBlameTransactionElement((Object)key, (String)metricName, (int)blameStatus, (boolean)true, (ITransactionElement)parent, (IBlameTransactionElement)previous, (IBlameTransactionElement)start, metrics, (IRepository)timerSds, (IRepository)perIntervalSds, (IRepository)concurrentSds, (IRepository)errorsSds, (IRepository)stallSds, (ProbeInformation)info, (AgentMetric[])faultMetric, (boolean)this.subscribeToDownstreamErrors(), (boolean)this.subscribeToDownstreamStalls(), (boolean)this.subscribeToDownstreamFaults(), (long)8L);
    }

    private IRepository getSharedRepository(boolean shouldBeConsumedOnRead) {
        CountMetricGathererWrapper wrapper = CountMetricGathererWrapper.getFactory((boolean)shouldBeConsumedOnRead);
        return new SharedDataStructure2((ISharedElement)wrapper);
    }

    private IRepository getSharedRepository(ISharedElement wrapper) {
        return new SharedDataStructure2(wrapper);
    }
}

