/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.DynamicParamEntry;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;

public final class DynamicParamsProcessor {
    private static HashMap sInstance = new HashMap();
    private DynamicParamEntry[] fParams = new DynamicParamEntry[0];
    private boolean referencesInvocationReturn = false;
    private final IModuleFeedbackChannel fFeedback;

    public static final synchronized DynamicParamsProcessor getInstance(IModuleFeedbackChannel feedback, String formattingName, String ACTUAL_CORR_ID) throws Exception {
        DynamicParamsProcessor schema = (DynamicParamsProcessor)sInstance.get(formattingName);
        if (schema == null) {
            schema = new DynamicParamsProcessor(feedback, formattingName, ACTUAL_CORR_ID);
            sInstance.put(formattingName, schema);
        }
        return schema;
    }

    public DynamicParamsProcessor(IModuleFeedbackChannel feedback, String formattingName, String ACTUAL_CORR_ID) throws Exception {
        this.fFeedback = feedback;
        this.fFeedback.debug("Processing dynamic params with syntax: " + formattingName + ", ACTUAL_CORR_ID: " + ACTUAL_CORR_ID);
        this.initDynamicParams(formattingName, ACTUAL_CORR_ID);
    }

    public final DynamicParamEntry[] getDynamicParamEntries() {
        return this.fParams;
    }

    public final boolean isInvocationReturnReferenced() {
        return this.referencesInvocationReturn;
    }

    public final boolean hasParam(String paramName) {
        int i = 0;
        while (i < this.fParams.length) {
            if (this.fParams[i].getParamName().equals(paramName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private final void initDynamicParams(String formattingName, String ACTUAL_CORR_ID) throws Exception {
        LinkedList<String> permittedLocalVariables = new LinkedList<String>();
        StringTokenizer paramsStrs = new StringTokenizer(formattingName.trim(), ";");
        LinkedList<DynamicParamEntry> dynParamsList = new LinkedList<DynamicParamEntry>();
        while (paramsStrs.hasMoreTokens()) {
            String currParamString = paramsStrs.nextToken().trim();
            DynamicParamEntry paramEntry = new DynamicParamEntry(this.fFeedback, currParamString, permittedLocalVariables, ACTUAL_CORR_ID);
            permittedLocalVariables.add(paramEntry.getParamName());
            dynParamsList.add(paramEntry);
            if (paramEntry.isInvocationReturnReferenced()) {
                this.referencesInvocationReturn = true;
            }
            this.fFeedback.debug("Added Dynamic Param -- " + paramEntry);
        }
        this.fParams = new DynamicParamEntry[dynParamsList.size()];
        this.fParams = dynParamsList.toArray(this.fParams);
    }

    public final HashMap processDynamicParams(InvocationData data) {
        return this.processDynamicParams(data, this.fParams.length);
    }

    public final void addBuiltIns(HashMap localVariables) {
        String[] utilities = new String[]{"Collections"};
        try {
            int i = 0;
            while (i < utilities.length) {
                localVariables.put("Local_" + utilities[i], Class.forName("java.util." + utilities[i]));
                ++i;
            }
        }
        catch (ClassNotFoundException c) {
            this.fFeedback.debug("addBuiltIns Error while adding java.util classes" + c);
        }
        localVariables.put("Local_EMPTY_STRING", "");
    }

    public final HashMap processDynamicParams(InvocationData data, int stopAtIndex) {
        HashMap<String, Object> dynamicProperties = new HashMap<String, Object>();
        int numOfElements = 3 + data.getInvocationParameterCount() + this.fParams.length;
        int initialCapacity = 1 + (numOfElements + 1) * 4 / 3;
        HashMap<String, Object> localVariables = new HashMap<String, Object>(initialCapacity);
        localVariables.put("InvocationData", data);
        Object invocationObject = data.getInvocationObject();
        if (invocationObject != null) {
            localVariables.put("InvocationClass", invocationObject.getClass());
            localVariables.put("InvocationObject", invocationObject);
        }
        int i = 0;
        while (i < data.getInvocationParameterCount()) {
            localVariables.put("InvocationParam-" + i, data.getInvocationParameterAsObject(i));
            ++i;
        }
        Object retObject = data.getInvocationReturnValueAsObject();
        if (this.referencesInvocationReturn) {
            localVariables.put("InvocationReturn", retObject);
        }
        this.addBuiltIns(localVariables);
        int i2 = 0;
        while (i2 < this.fParams.length) {
            block10: {
                DynamicParamEntry thisEntry = this.fParams[i2];
                try {
                    boolean doProcessing;
                    if (stopAtIndex == i2) break;
                    Object invocationValue = thisEntry.getValue(localVariables);
                    String paramName = thisEntry.getParamName();
                    Object valToPopulate = invocationValue;
                    this.fFeedback.debug("DynamicParamsProcessor processDynamicParams paramName=" + paramName + " valToPopulate=" + valToPopulate + " valToPopulate class=" + valToPopulate.getClass());
                    if (!thisEntry.getIsLocal()) {
                        Object prevVal = dynamicProperties.get(paramName);
                        if (prevVal != null) {
                            valToPopulate = String.valueOf(prevVal.toString()) + valToPopulate.toString().trim();
                        }
                        this.fFeedback.debug("DynamicParamsProcessor processDynamicParams paramName=" + paramName + " valToPopulate=" + valToPopulate);
                        dynamicProperties.put(paramName, valToPopulate);
                        localVariables.put(paramName, valToPopulate);
                    } else {
                        localVariables.put(paramName, valToPopulate);
                        dynamicProperties.put(paramName, valToPopulate);
                    }
                    if (paramName.equals("DoProcessing") && !(doProcessing = new Boolean(valToPopulate.toString().trim()).booleanValue())) {
                        break;
                    }
                }
                catch (Exception e) {
                    this.fFeedback.debug("Error while processing Dynamic Param: " + thisEntry + " while instrumenting class: " + data.getProbeInformation().getProbeIdentification().getRuntimePackageAndClassName() + " and method: " + data.getProbeInformation().getProbeIdentification().getProbeMethodName() + ". Error: " + WSMUtils.dumpStackTrace(e));
                    if (!thisEntry.getParamName().equals("DoProcessing")) break block10;
                    dynamicProperties.put(thisEntry.getParamName(), "false");
                }
            }
            ++i2;
        }
        return dynamicProperties;
    }
}

