/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.websphere;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Method;
import java.util.Map;

public class JAXWSProxyHandlerNameFormatter
implements INameFormatter,
KConstants {
    protected final IAgent fAgent;
    protected IModuleFeedbackChannel logger;

    public JAXWSProxyHandlerNameFormatter(IAgent agent) {
        this.fAgent = agent;
        this.logger = this.fAgent.IAgent_getModuleFeedback();
    }

    private final String getNamespace(Object objJAXWSProxyHandler) {
        String namespace = "UnknownNamespace";
        try {
            Object objServiceDelegate = WSMUtils.invokeMethodOnObject(objJAXWSProxyHandler, "getServiceDelegate");
            Object serviceQName = WSMUtils.invokeMethodOnObject(objServiceDelegate, "getServiceName");
            namespace = WSMUtils.formatToBeResourceSafe((String)WSMUtils.invokeMethodOnObject(serviceQName, "getNamespaceURI"));
        }
        catch (Exception ex) {
            WSMUtils.getLogger().error("JAXWSProxyHandlerNameFormatter getNamespace exception: " + WSMUtils.dumpStackTrace(ex));
        }
        return namespace;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String operationName = "UnknownOperationName";
        String serviceName = "UnknownService";
        String namespace = "UnknownNamespace";
        if (name == null) {
            return null;
        }
        try {
            operationName = ((Method)data.getInvocationParameterAsObject(0)).getName();
            Object objJAXWSProxyHandler = data.getInvocationObject();
            Object objRequestContext = WSMUtils.invokeMethodOnObject(objJAXWSProxyHandler, "getRequestContext");
            Map mapRequestContext = (Map)objRequestContext;
            serviceName = (String)mapRequestContext.get("javax.xml.ws.service.endpoint.address");
            mapRequestContext.put("com.wily.powerpack.jaxws.client.was7.operation", operationName);
            namespace = this.getNamespace(objJAXWSProxyHandler);
            mapRequestContext.put("com.wily.powerpack.jaxws.client.was7.namespace", namespace);
            this.logger.info("JAXWSProxyHandlerNameFormatter.INameFormatter_format()..mapRequestContext" + mapRequestContext);
            if (name.indexOf("{namespace}", 0) >= 0) {
                if (namespace == null) {
                    namespace = serviceName;
                }
                if (namespace == null) {
                    namespace = "UnknownNamespace";
                }
                namespace = WSMUtils.formatToBeResourceSafe(namespace);
                name = StringUtils.replace((String)name, (String)"{namespace}", (String)namespace);
            }
            if (name.indexOf("{servicename}", 0) >= 0) {
                if (serviceName == null) {
                    serviceName = "UnknownService";
                }
                serviceName = WSMUtils.formatToBeResourceSafe(serviceName);
                name = StringUtils.replace((String)name, (String)"{servicename}", (String)serviceName);
            }
            if (name.indexOf("{operationname}", 0) >= 0) {
                if (operationName == null) {
                    operationName = "UnknownOperationName";
                }
                operationName = WSMUtils.formatToBeResourceSafe(operationName);
                name = StringUtils.replace((String)name, (String)"{operationname}", (String)operationName);
            }
        }
        catch (Exception ex) {
            WSMUtils.getLogger().error("JAXWSProxyHandlerNameFormatter INameFormatter_format exception: " + WSMUtils.dumpStackTrace(ex));
        }
        return name;
    }
}

