/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import com.wily.util.obfuscation.IStatefulByteTransformer;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class EncryptInputStream
extends FilterInputStream {
    private final IStatefulByteTransformer fDecryptor;

    public EncryptInputStream(InputStream input, IStatefulByteTransformer decryptor) {
        super(input);
        this.fDecryptor = decryptor;
    }

    @Override
    public final int read() throws IOException {
        int rawRead = super.read();
        if (rawRead == -1) {
            return rawRead;
        }
        return this.fDecryptor.transform((byte)rawRead) & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result > 0) {
            this.fDecryptor.transformInPlace(b, off, result);
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long num = super.skip(n);
        int i = 0;
        while ((long)i < num) {
            this.fDecryptor.transform((byte)0);
            ++i;
        }
        return num;
    }
}

