/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.IFactoryLevelParameterCallback;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.feature.StallFeatureBase;
import com.wily.introscope.agent.feature.ThreadMXBeanTimingFeature;
import com.wily.introscope.agent.stat.IIntegerAggregatingDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ICacheableInvocationDataTracerFactory;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.AAgentMetricArray;
import com.wily.introscope.agent.trace.cas.ACrossCorrelationElement;
import com.wily.introscope.agent.trace.cas.BlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.ICounterRepository;
import com.wily.introscope.agent.trace.cas.IGathererElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.IStringRepresentable;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElementProvider;
import com.wily.introscope.agent.trace.cas.ITransactionInstanceProvider;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.cas.RepositoryFactory;
import com.wily.introscope.agent.trace.cas.SharedDataStructure;
import com.wily.introscope.agent.trace.cas.SharedDataStructure3;
import com.wily.introscope.agent.trace.cas.SharedDataStructure4;
import com.wily.introscope.agent.trace.cas.SharedDataStructure5;
import com.wily.introscope.agent.trace.cas.SharedDataStructureCAS2;
import com.wily.introscope.agent.trace.cas.UpdaterFactory;
import com.wily.introscope.agent.trace.hc2.ASingleInstanceTracerFactoryHC;
import com.wily.introscope.agent.trace.hc2.AtomicCountMetricGathererWrapper;
import com.wily.introscope.agent.trace.hc2.AverageMetricGathererWrapper;
import com.wily.introscope.agent.trace.hc2.CPUTimingTransactionElement;
import com.wily.introscope.agent.trace.hc2.CountMetricGathererWrapper;
import com.wily.introscope.agent.trace.hc2.SocketTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.trace.intelligent.AutoTracingController;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.introscope.spec.agent.beans.bizdef.IBizDefSupportBean;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import com.wily.util.properties.IndexedProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class BlamePointTracer
extends ASingleInstanceTracerFactoryHC
implements ITracer,
ITransactionElementProvider,
ITransactionInstanceProvider,
IFactoryLevelParameterCallback,
ICacheableInvocationDataTracerFactory {
    private String responseTimeAttrSuffix;
    private String perIntervalAttrSuffix;
    private String concurrentAttrSuffix;
    private String errorsAttrSuffix;
    private String stallsAttrSuffix;
    private String renamedResponseTimeAttrSuffix = null;
    private String renamedPerIntervalAttrSuffix = null;
    private String renamedConcurrentAttrSuffix = null;
    private String renamedErrorsAttrSuffix = null;
    private String renamedStallsAttrSuffix = null;
    private ReentrancyLevel fReentrancyLevel;
    private static final String kStallAttr = "Stall Count";
    private static final String kResponseTimeAttr = "Average Response Time (ms)";
    private static final String kPerIntervalAttr = "Responses Per Interval";
    private static final String kConcurrentAttr = "Concurrent Invocations";
    private static final String kErrorsAttr = "Errors Per Interval";
    private static final String kUnformattedAutoTraceTriggerReason = "Response time of Component '%s' exceeded threshold %d ms";
    private static final String kUnformattedAutoTraceBaselineThresholdTriggerReason = "Response time of Component '%s' exceeded baseline threshold %d ms";
    private static final String kForceStandardBlameMetricsKey = "forcestandardmetrics";
    protected static final String kAppsMetricGroupPrefix = "Frontends|Apps|";
    private static final String kShouldComputeMetricsKey = "computemetrics";
    private static final String kShouldDoStallsKey = "dostalls";
    private static final String kShouldUseSharedSleepKey = "usesharedsleep";
    private static final String kShouldUseSynchronizedKey = "usesynchronized";
    private static final String kGenerateDebugMetric = "generatedebugmetric";
    public static final String kGenerateTransactionElementKey = "generatetransactionelement";
    private static final String kGenerateBusinessTransactionMetricsKey = "generatebusinesstransactionmetrics";
    private static final String kGenerateContextualMetricsKey = "generatecontextualmetrics";
    private static final String kNumberOfStripesKey = "numberofstripes";
    private static final String kShouldUseCASKey = "usecas";
    private IBizDefSupportBean fBizDefSupport = null;
    private static final String kShouldUseSameTypeAdditionalMetrics = "usesametype";
    private final boolean fShouldManageEJBContext;
    protected final boolean shouldCollectAllocatedBytes;
    private static final String ALLOCATEDBYTES_KEY = "allocatedbytes";
    private static final String ALLOCATEDBYTES_METHODNAME_KEY = "allocatedbytesmethodname";
    protected final boolean shouldCollectorCpuTiming;
    private static final String CPUTIMING_KEY = "cputiming";
    private static final String CPUTIMING_METHODNAME_KEY = "cputimingmethodname";
    protected final boolean fShouldDoStalls;
    protected final boolean fShouldComputeMetrics;
    private final boolean fShouldUseSharedSleep;
    private final boolean fShouldUseSynchronized;
    private final boolean fShouldUseCAS;
    private final boolean fShouldForceStandardBlameMetrics;
    protected final boolean kGenerateDebugMetrics;
    private final boolean kGenerateTransactionElement;
    private final boolean kGenerateBusinessTransactionMetrics;
    private final boolean kGenerateContextualMetrics;
    protected final int fNumberOfStripes;
    private final boolean fHasContextualMetrics;
    private final int fMaxStructurePathLength;
    static final Module kBlamePointTracer = new Module("BlamePointStack");
    private static final String kHasContextualMetricsKey = "hascontextualmetrics";
    private IInvocationDataParameterCallback callbackCPUTiming = new IInvocationDataParameterCallback(){

        @Override
        public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
            ThreadMXBeanTimingFeature.addParameters(data, parameters);
        }
    };
    protected static final IUpdater increaser = UpdaterFactory.getIncreasingUpdater();
    protected static final IUpdater decreaser = UpdaterFactory.getDecreasingUpdater();
    protected static final Updater updater = new Updater();
    static final NonCombiningUpdater ncupdater = new NonCombiningUpdater();
    private static final String kAdditionalResourceMapped = "mappedresource";
    private static final int kMaxAdditionalMetrics = 10;

    public static final IUpdater getIncreaser() {
        return UpdaterFactory.getIncreasingUpdater();
    }

    public static final IUpdater getDecreaser() {
        return UpdaterFactory.getDecreasingUpdater();
    }

    public static final IUpdater getUpdater() {
        return updater;
    }

    public static final IUpdater getNonCombiningUpdater() {
        return ncupdater;
    }

    public BlamePointTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);
        this.fShouldForceStandardBlameMetrics = this.resolveForceStandardMetricsToExistProperty();
        this.fShouldComputeMetrics = this.calculateBooleanParameter(kShouldComputeMetricsKey, true);
        this.fShouldDoStalls = this.calculateBooleanParameter(kShouldDoStallsKey, true);
        this.shouldCollectAllocatedBytes = this.calculateMethodInstanceLevel(ALLOCATEDBYTES_KEY, ALLOCATEDBYTES_METHODNAME_KEY);
        this.shouldCollectorCpuTiming = this.calculateMethodInstanceLevel(CPUTIMING_KEY, CPUTIMING_METHODNAME_KEY);
        this.fShouldUseSharedSleep = this.resolveUseSharedSleepProperty();
        this.fShouldUseSynchronized = this.resolveUseSynchronizedProperty();
        this.kGenerateDebugMetrics = this.resolveGenerateDebugMetrics() ? true : WilyTransactionStructure.fGenerateDebugMetrics;
        this.kGenerateTransactionElement = this.calculateBooleanParameter(kGenerateTransactionElementKey, true);
        this.kGenerateBusinessTransactionMetrics = this.calculateBooleanParameter(kGenerateBusinessTransactionMetricsKey, false);
        this.kGenerateContextualMetrics = this.calculateBooleanParameter(kGenerateContextualMetricsKey, WilyTransactionStructure.fGenerateContextualMetrics);
        this.fHasContextualMetrics = this.calculateBooleanParameter(kHasContextualMetricsKey, false);
        this.fNumberOfStripes = this.calculateIntegerParameter(kNumberOfStripesKey, WilyTransactionStructure.fSuggestHighConcurrency ? WilyTransactionStructure.fDefaultNumberOfStripes : 1);
        this.fMaxStructurePathLength = this.calculateIntegerParameter(kNumberOfStripesKey, WilyTransactionStructure.fTransactionStructureMetricsMaxLength);
        this.fShouldUseCAS = this.resolveUseCASProperty();
        if (this.kGenerateBusinessTransactionMetrics) {
            try {
                this.fBizDefSupport = (IBizDefSupportBean)((Object)this.getAgent().IAgent_getTracerAdministrator().loadTraceSupport("com.wily.introscope.agent.bizdef.BizDefAdministratorFactory", "").getTraceSupportInstance());
            }
            catch (Throwable t) {
                agent.IAgent_getModuleFeedback().warn(kBlamePointTracer, "Tracer failed initialization");
                agent.IAgent_getModuleFeedback().verbose(kBlamePointTracer, "Tracer failed initialization", t);
            }
        }
        this.responseTimeAttrSuffix = ":Average Response Time (ms)";
        String label = this.getParameter("responsetimemetric");
        if (label != null) {
            this.renamedResponseTimeAttrSuffix = ":" + label;
        }
        this.perIntervalAttrSuffix = ":Responses Per Interval";
        label = this.getParameter("perintervalmetric");
        if (label != null) {
            this.renamedPerIntervalAttrSuffix = ":" + label;
        }
        this.concurrentAttrSuffix = ":Concurrent Invocations";
        label = this.getParameter("concurrentmetric");
        if (label != null) {
            this.renamedConcurrentAttrSuffix = ":" + label;
        }
        this.stallsAttrSuffix = ":Stall Count";
        label = this.getParameter(kStallAttr);
        if (label != null) {
            this.renamedStallsAttrSuffix = ":" + label;
        }
        this.errorsAttrSuffix = ":Errors Per Interval";
        label = this.getParameter(kErrorsAttr);
        if (label != null) {
            this.renamedErrorsAttrSuffix = ":" + label;
        }
        this.fShouldManageEJBContext = new Boolean(this.getParameter("manageejbcontext"));
        ThreadMXBeanTimingFeature.loadThreadMXBean(agent);
    }

    protected final boolean resolveForceStandardMetricsToExistProperty() {
        String blameType;
        boolean shouldForce = true;
        boolean useBoundaryBlame = true;
        IndexedProperties props = this.getAgent().IAgent_getIndexedProperties();
        if (props != null && (blameType = props.getProperty("introscope.agent.blame.type")) != null) {
            useBoundaryBlame = blameType.equalsIgnoreCase("boundary");
        }
        if (!useBoundaryBlame) {
            shouldForce = this.calculateBooleanParameter(kForceStandardBlameMetricsKey, true);
        }
        return shouldForce;
    }

    protected final boolean resolveComputeMetricsProperty() {
        return this.calculateBooleanParameter(kShouldComputeMetricsKey, true);
    }

    protected final boolean resolveUseSharedSleepProperty() {
        return this.calculateBooleanParameter(kShouldUseSharedSleepKey, false);
    }

    protected final boolean resolveUseSynchronizedProperty() {
        this.getWilyTransactionStructureInstance();
        return this.calculateBooleanParameter(kShouldUseSynchronizedKey, WilyTransactionStructure.fSuggestSynchronizedProperty);
    }

    protected final boolean resolveGenerateDebugMetrics() {
        return this.calculateBooleanParameter(kGenerateDebugMetric, false);
    }

    protected final boolean resolveUseCASProperty() {
        return this.calculateBooleanParameter(kShouldUseCASKey, false);
    }

    @Override
    public void IFactoryLevelParameterCallback_addParameters(Map parameters) {
        String callingMethodName;
        String isDynamic;
        String labelName;
        String tracerName;
        String groupName;
        String declaringClassName = this.getParameter("declaringClass");
        if (declaringClassName != null && !declaringClassName.equals(parameters.get("Class"))) {
            parameters.put("Declaring Class", declaringClassName);
        }
        if ((groupName = this.getParameter("groupName")) != null) {
            parameters.put("Group Name", groupName);
        }
        if ((tracerName = this.getParameter("tracerName")) != null) {
            parameters.put("Tracer Name", tracerName);
        }
        if ((labelName = this.getParameter("label")) != null) {
            parameters.put("Label", labelName);
        }
        if ((isDynamic = this.getParameter("dynamic")) != null) {
            parameters.put("Is dynamic", isDynamic);
        } else {
            parameters.put("Is dynamic", "false");
        }
        String isTransitory = this.getParameter("temporary");
        if (isTransitory != null) {
            parameters.put("Is temporary", isTransitory);
        } else {
            parameters.put("Is temporary", "false");
        }
        String callingClassName = this.getParameter("callingClass");
        if (callingClassName != null) {
            parameters.put("Calling Class", callingClassName);
        }
        if ((callingMethodName = this.getParameter("callingMethod")) != null) {
            parameters.put("Calling Method", callingMethodName);
        }
    }

    protected String getFrontendNameForComponent(String rootName) {
        return kAppsMetricGroupPrefix + rootName;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        this.doStartBlamePointTrace(tracerIndex, data);
    }

    protected void doStartBlamePointTrace(int tracerIndex, InvocationData data) {
        data.storeWallClockStartTime();
        if (data.getMyThread() == null) {
            data.setMyThread(Thread.currentThread());
        }
        if ((data.hasServletSupport() || data.hasASPSupport()) && this.fBizDefSupport != null && !VirtualStack.staticHasFrontBoundary()) {
            this.fBizDefSupport.getBusinessTransactionComponent(data, true);
        }
        this.submitToTransactionStructureOnStartTrace(tracerIndex, data, this);
        if (this.fShouldManageEJBContext) {
            this.getComponentTracer().setInEJBTracingContext();
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        this.submitToTransactionStructureOnEndTrace(tracerIndex, data, this);
        if (this.fShouldManageEJBContext) {
            this.getComponentTracer().clearInEJBTracingContext();
        }
    }

    protected final IIntegerAggregatingDataAccumulator getTimerDataAccumulator(String component, String suffix) {
        return this.getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(String.valueOf(component) + suffix);
    }

    protected final IIntegerAggregatingDataAccumulator getTimerDataAccumulator(String component) {
        return this.getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(String.valueOf(component) + this.responseTimeAttrSuffix);
    }

    protected final ILongIntervalCounterDataAccumulator getPerIntervalDataAccumulator(String component, String suffix) {
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(String.valueOf(component) + suffix);
    }

    protected final ILongIntervalCounterDataAccumulator getPerIntervalDataAccumulator(String component) {
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(String.valueOf(component) + this.perIntervalAttrSuffix);
    }

    protected final ILongIntervalCounterDataAccumulator getErrorsDataAccumulator(String component, String suffix) {
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(String.valueOf(component) + suffix);
    }

    protected final ILongIntervalCounterDataAccumulator getErrorsDataAccumulator(String component) {
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(String.valueOf(component) + this.errorsAttrSuffix);
    }

    protected final IIntegerFluctuatingCounterDataAccumulator getConcurrentInvocationDataAccumulator(String component, String suffix) {
        return this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(String.valueOf(component) + suffix);
    }

    protected final IIntegerFluctuatingCounterDataAccumulator getConcurrentInvocationDataAccumulator(String component) {
        return this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(String.valueOf(component) + this.concurrentAttrSuffix);
    }

    protected final IIntegerFluctuatingCounterDataAccumulator getStallDataAccumulator(String component, String suffix) {
        return this.getDataAccumulatorFactory().safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(String.valueOf(component) + suffix);
    }

    protected final IIntegerFluctuatingCounterDataAccumulator getStallDataAccumulator(String component) {
        return this.getDataAccumulatorFactory().safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(String.valueOf(component) + this.stallsAttrSuffix);
    }

    protected String getTimerMetricName(String component) {
        if (this.renamedResponseTimeAttrSuffix == null) {
            return String.valueOf(component) + this.responseTimeAttrSuffix;
        }
        return String.valueOf(component) + this.renamedResponseTimeAttrSuffix;
    }

    protected String getPerIntervalMetricName(String component) {
        if (this.renamedPerIntervalAttrSuffix == null) {
            return String.valueOf(component) + this.perIntervalAttrSuffix;
        }
        return String.valueOf(component) + this.renamedPerIntervalAttrSuffix;
    }

    protected String getConcurrentInvocationMetricName(String component) {
        if (this.renamedConcurrentAttrSuffix == null) {
            return String.valueOf(component) + this.concurrentAttrSuffix;
        }
        return String.valueOf(component) + this.renamedConcurrentAttrSuffix;
    }

    protected String getErrorsMetricName(String component) {
        if (this.renamedErrorsAttrSuffix == null) {
            return String.valueOf(component) + this.errorsAttrSuffix;
        }
        return String.valueOf(component) + this.renamedErrorsAttrSuffix;
    }

    protected String getStallsMetricName(String component) {
        if (this.renamedStallsAttrSuffix == null) {
            return String.valueOf(component) + this.stallsAttrSuffix;
        }
        return String.valueOf(component) + this.renamedStallsAttrSuffix;
    }

    protected AgentMetric[] createTimerMetric(String formattedMetricName) {
        int metricType = 1025;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createPerIntervalMetric(String formattedMetricName) {
        int metricType = 8194;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createConcurrentInvocationMetric(String formattedMetricName) {
        int metricType = 257;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createErrorsMetric(String formattedMetricName) {
        int metricType = 8194;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createStallsMetric(String formattedMetricName) {
        int metricType = 385;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an aggregating integer fluctuating counter metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createAdditionalTimerMetric(String formattedMetricName) {
        int metricType = 1025;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createAdditionalPerIntervalMetric(String formattedMetricName) {
        int metricType = 8194;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createAdditionalConcurrentInvocationMetric(String formattedMetricName) {
        int metricType = 257;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createAdditionalErrorsMetric(String formattedMetricName) {
        int metricType = 8194;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createAdditionalStallsMetric(String formattedMetricName) {
        int metricType = 385;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an aggregating integer fluctuating counter metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createDefaultBackendTimerMetric(String formattedMetricName) {
        int metricType = 536871937;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createDefaultBackendPerIntervalMetric(String formattedMetricName) {
        int metricType = 0x20002002;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createDefaultBackendConcurrentInvocationMetric(String formattedMetricName) {
        int metricType = 0x20000101;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createDefaultBackendErrorsMetric(String formattedMetricName) {
        int metricType = 0x20002002;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createDefaultBackendStallsMetric(String formattedMetricName) {
        int metricType = 536871297;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an aggregating integer fluctuating counter metric");
        return new AgentMetric[]{metric};
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public boolean shouldForceStandardBlameMetrics() {
        return this.fShouldForceStandardBlameMetrics;
    }

    protected boolean hasContextualMetrics() {
        return this.fHasContextualMetrics;
    }

    @Override
    public ITransactionElement getElement(Object key, ITransactionElement parent) {
        return this.getElementOnStartTrace(key, 0, null, parent);
    }

    @Override
    public ITransactionElement getElementOnStartTrace(Object key, int tracerIndex, IStackElement elementData, ITransactionElement parent) {
        InvocationData data = (InvocationData)elementData;
        String metricName = data.getComponentNameAt(tracerIndex);
        if (metricName == null) {
            metricName = this.getComponentName(data);
            data.setComponentNameAt(metricName, tracerIndex);
        }
        IBlameTransactionElement previous = BlamePointTracer.getPreviousBlamePoint(parent);
        WilyTransactionElement result = this.constructTransactionElement(key, metricName, this.getBlameStatus(), true, parent, previous, null, data.getProbeInformation());
        this.createAdditionalMetrics(tracerIndex, data, result, previous);
        if (this.kGenerateBusinessTransactionMetrics && !VirtualStack.staticHasFrontBoundary()) {
            this.addBusinessTransactionMetrics(data, result);
        }
        if (this.kGenerateDebugMetrics) {
            this.generateSustainabilityCounter(key, result);
        }
        if (this.kGenerateContextualMetrics) {
            this.createContextualMetrics(tracerIndex, data, result, previous);
        }
        result.setAgentFeatureIndicant(this.getAgentComponent());
        return result;
    }

    protected WilyTransactionElement constructTransactionElement(Object key, String metricName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, ProbeInformation probeInformation) {
        IRepository concurrentSds = null;
        IRepository timerSds = null;
        IRepository stallSds = null;
        IRepository errorsSds = null;
        IRepository perIntervalSds = null;
        HashMap<IRepository, AgentMetric[]> metrics = null;
        IRepository cpuUserTimerSds = null;
        IRepository cpuSystemTimerSds = null;
        IRepository cpuWaitTimerSds = null;
        IRepository cpuBlockTimerSds = null;
        IRepository allocatedMemoryByteSds = null;
        boolean collectCPUTimingMetrics = false;
        if (this.fShouldComputeMetrics) {
            WilyTransactionStructure structure = this.getWilyTransactionStructureInstance();
            boolean hasContextualMetricss = this.computeHasContextualMetrics();
            if (hasContextualMetricss) {
                metrics = new HashMap<IRepository, AgentMetric[]>(4);
            }
            ArrayList<AgentMetric> metricsForGrouping = new ArrayList<AgentMetric>(4);
            AgentMetric[] concurrentMetric = this.createConcurrentInvocationMetric(this.getConcurrentInvocationMetricName(metricName));
            concurrentSds = this.getSharedRepositoryNoSharedStructure(false);
            concurrentSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent(new AAgentMetricArray(concurrentMetric), concurrentSds);
            metricsForGrouping.add(concurrentMetric[0]);
            AgentMetric[] timerMetric = this.createTimerMetric(this.getTimerMetricName(metricName));
            timerSds = this.getSharedRepository(AverageMetricGathererWrapper.getFactory(true), this.fNumberOfStripes);
            if (hasContextualMetricss) {
                metrics.put(timerSds, timerMetric);
            } else {
                timerSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent(new AAgentMetricArray(timerMetric), timerSds);
            }
            metricsForGrouping.add(timerMetric[0]);
            AgentMetric[] perIntervalMetric = this.createPerIntervalMetric(this.getPerIntervalMetricName(metricName));
            perIntervalSds = this.getSharedRepository(true, this.fNumberOfStripes);
            if (hasContextualMetricss) {
                metrics.put(perIntervalSds, perIntervalMetric);
            } else {
                perIntervalSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent(new AAgentMetricArray(perIntervalMetric), perIntervalSds);
            }
            metricsForGrouping.add(perIntervalMetric[0]);
            if (this.shouldForceStandardBlameMetrics()) {
                AgentMetric[] stallMetric = this.createStallsMetric(this.getStallsMetricName(metricName));
                stallSds = this.getSharedRepositoryNoSharedStructure(false);
                if (hasContextualMetricss) {
                    metrics.put(stallSds, stallMetric);
                } else {
                    stallSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent(new AAgentMetricArray(stallMetric), stallSds);
                }
                metricsForGrouping.add(stallMetric[0]);
                AgentMetric[] errorMetric = this.createErrorsMetric(this.getErrorsMetricName(metricName));
                errorsSds = this.getSharedRepository(true, this.fNumberOfStripes);
                if (hasContextualMetricss) {
                    metrics.put(errorsSds, errorMetric);
                } else {
                    errorsSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent(new AAgentMetricArray(errorMetric), errorsSds);
                }
                metricsForGrouping.add(errorMetric[0]);
            } else {
                stallSds = null;
                errorsSds = null;
            }
            collectCPUTimingMetrics = this.shouldCollectCPUTimingMetrics();
            if (collectCPUTimingMetrics) {
                AgentMetric[] cpuUserTimerMetric = this.createLongTypeMetric(String.valueOf(metricName) + ":Average User CPU Time (ms)");
                cpuUserTimerSds = this.getSharedRepository(AverageMetricGathererWrapper.getFactory(true), this.fNumberOfStripes);
                if (hasContextualMetricss) {
                    metrics.put(cpuUserTimerSds, cpuUserTimerMetric);
                } else {
                    cpuUserTimerSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent(new AAgentMetricArray(cpuUserTimerMetric), cpuUserTimerSds);
                }
                metricsForGrouping.add(cpuUserTimerMetric[0]);
                AgentMetric[] cpuSystemTimerMetric = this.createLongTypeMetric(String.valueOf(metricName) + ":Average System CPU Time (ms)");
                cpuSystemTimerSds = this.getSharedRepository(AverageMetricGathererWrapper.getFactory(true), this.fNumberOfStripes);
                if (hasContextualMetricss) {
                    metrics.put(cpuSystemTimerSds, cpuSystemTimerMetric);
                } else {
                    cpuSystemTimerSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent(new AAgentMetricArray(cpuSystemTimerMetric), cpuSystemTimerSds);
                }
                metricsForGrouping.add(cpuSystemTimerMetric[0]);
                AgentMetric[] cpuWaitTimerMetric = this.createLongTypeMetric(String.valueOf(metricName) + ":Average Wait Time (ms)");
                cpuWaitTimerSds = this.getSharedRepository(AverageMetricGathererWrapper.getFactory(true), this.fNumberOfStripes);
                if (hasContextualMetricss) {
                    metrics.put(cpuWaitTimerSds, cpuWaitTimerMetric);
                } else {
                    cpuWaitTimerSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent(new AAgentMetricArray(cpuWaitTimerMetric), cpuWaitTimerSds);
                }
                metricsForGrouping.add(cpuWaitTimerMetric[0]);
                AgentMetric[] cpuBlockTimerMetric = this.createLongTypeMetric(String.valueOf(metricName) + ":Average Block Time (ms)");
                cpuBlockTimerSds = this.getSharedRepository(AverageMetricGathererWrapper.getFactory(true), this.fNumberOfStripes);
                if (hasContextualMetricss) {
                    metrics.put(cpuBlockTimerSds, cpuBlockTimerMetric);
                } else {
                    cpuBlockTimerSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent(new AAgentMetricArray(cpuBlockTimerMetric), cpuBlockTimerSds);
                }
                metricsForGrouping.add(cpuBlockTimerMetric[0]);
                AgentMetric[] allocatedMemoryByteMetric = this.createLongTypeMetric(String.valueOf(metricName) + ":Average Bytes Allocated");
                allocatedMemoryByteSds = this.getSharedRepository(AverageMetricGathererWrapper.getFactory(true), this.fNumberOfStripes);
                if (hasContextualMetricss) {
                    metrics.put(allocatedMemoryByteSds, allocatedMemoryByteMetric);
                } else {
                    allocatedMemoryByteSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent(new AAgentMetricArray(allocatedMemoryByteMetric), allocatedMemoryByteSds);
                }
                metricsForGrouping.add(allocatedMemoryByteMetric[0]);
            }
            this.getAgent().IAgent_getMetricRecordingAdministrator().addMetricGroup(metricName, metricsForGrouping);
        }
        WilyTransactionElement result = collectCPUTimingMetrics ? new CPUTimingTransactionElement(key, metricName, this.getBlameStatus(), isStartTrace, parent, previous, start, metrics, timerSds, perIntervalSds, concurrentSds, errorsSds, stallSds, probeInformation, this.subscribeToDownstreamErrors(), this.subscribeToDownstreamStalls(), this.getFilterEnablerBit(), cpuUserTimerSds, cpuSystemTimerSds, cpuWaitTimerSds, cpuBlockTimerSds, allocatedMemoryByteSds) : this.constructTransactionElement(key, metricName, this.getBlameStatus(), isStartTrace, parent, previous, start, metrics, timerSds, perIntervalSds, concurrentSds, errorsSds, stallSds, probeInformation, this.subscribeToDownstreamErrors(), this.subscribeToDownstreamStalls(), this.getFilterEnablerBit());
        return result;
    }

    private boolean shouldCollectCPUTimingMetrics() {
        return (this.shouldCollectorCpuTiming || this.shouldCollectAllocatedBytes) && (ThreadMXBeanTimingFeature.allocatedMemoryEnabled || ThreadMXBeanTimingFeature.isMethodTimeBreakdownEnabled && ThreadMXBeanTimingFeature.isCPUMetricEnabled);
    }

    protected WilyTransactionElement constructTransactionElement(Object key, String componentName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, Map agentMetrics, IRepository fTimerDataStructure, IRepository fPerIntervalDataStructure, IRepository fConcurrentInvocationDataStructure, IRepository fErrorsDataStructure, IRepository fStallsDataStructure, ProbeInformation probeInformation, boolean isSubscribedForDownstreamErrors, boolean isSubscribedForDownstreamStalls, long filterEnablerBit) {
        return new WilyTransactionElement(key, componentName, blameStatus, isStartTrace, parent, previous, start, agentMetrics, fTimerDataStructure, fPerIntervalDataStructure, fConcurrentInvocationDataStructure, fErrorsDataStructure, fStallsDataStructure, probeInformation, isSubscribedForDownstreamErrors, isSubscribedForDownstreamStalls, filterEnablerBit);
    }

    private void generateSustainabilityCounter(Object key, WilyTransactionElement result) {
        String safeMetricName = this.getContectualSafePath(result);
        String keyString = null;
        keyString = key != null ? (key instanceof Object[] ? Arrays.asList((Object[])key).toString() : key.toString()) : "Error_Sustainability";
        String safeKeyString = keyString.replace(",", "_").replace("|", "_").replace("-->", "|").replace(":", "_").replace(";", "_").replace("?", "(QM)");
        IIntegerFluctuatingCounterDataAccumulator accumulator = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(String.valueOf(safeMetricName) + ":" + safeKeyString);
        accumulator.IIntegerFluctuatingCounterDataAccumulator_increment();
    }

    private String getContectualSafePath(WilyTransactionElement result) {
        StringBuilder iTKOMetric = new StringBuilder();
        Stack<WilyTransactionElement> stack = new Stack<WilyTransactionElement>();
        ITransactionElement leaf = result;
        while (leaf != null) {
            stack.push((WilyTransactionElement)leaf);
            leaf = leaf.getParent();
        }
        while (!stack.isEmpty()) {
            leaf = (ITransactionElement)stack.pop();
            if (leaf instanceof WilyTransactionElement) {
                iTKOMetric.append("<ReplaceWithPipe>").append(((WilyTransactionElement)leaf).getBlameName());
                continue;
            }
            if (!(leaf instanceof IStringRepresentable)) continue;
            iTKOMetric.append("<ReplaceWithPipe>").append(((IStringRepresentable)((Object)leaf)).getStringRepresentation());
        }
        String safeMetricName = iTKOMetric.toString().replace(",", "_").replace("|", "_").replace("<ReplaceWithPipe>", "|").replace(":", "_").replace(";", "_").replace("?", "(QM)");
        safeMetricName = "Agent Stats|Sustainability|Structure" + safeMetricName;
        boolean replaced = false;
        while (safeMetricName.length() > this.fMaxStructurePathLength) {
            safeMetricName = safeMetricName.substring(0, safeMetricName.lastIndexOf(124));
            replaced = true;
        }
        if (replaced) {
            safeMetricName = String.valueOf(safeMetricName) + "...";
        }
        return safeMetricName;
    }

    protected boolean computeHasContextualMetrics() {
        boolean forceHasContextualMetrics;
        boolean bl = forceHasContextualMetrics = this.hasContextualMetrics() || this.kGenerateBusinessTransactionMetrics;
        if (forceHasContextualMetrics) {
            return true;
        }
        return !this.fShouldUseSharedMetrics;
    }

    protected long getFilterEnablerBit() {
        return Long.MAX_VALUE;
    }

    protected boolean subscribeToDownstreamErrors() {
        return false;
    }

    protected boolean subscribeToDownstreamStalls() {
        return false;
    }

    public static IBlameTransactionElement getPreviousBlamePoint(ITransactionElement parent) {
        IBlameTransactionElement previous = null;
        ITransactionElement wElement = parent;
        if (wElement != null) {
            ITransactionElement superParent;
            if (wElement instanceof WilyTransactionElement) {
                WilyTransactionElement wte = (WilyTransactionElement)wElement;
                while (!wte.isStartTrace()) {
                    wte = (WilyTransactionElement)wte.getStartTraceBlamePoint();
                    wte = (WilyTransactionElement)wte.getParent();
                }
                previous = wte;
            } else if (wElement instanceof BlameTransactionElement) {
                previous = ((BlameTransactionElement)wElement).getPreviousBlamePoint();
            } else if (wElement instanceof ACrossCorrelationElement && (superParent = ((ACrossCorrelationElement)wElement).getParent()) != null && superParent instanceof IBlameTransactionElement) {
                previous = (IBlameTransactionElement)superParent;
            }
        }
        return previous;
    }

    protected String getAppMapName(Object key, InvocationData data, int tracerIndex, String fallBack) {
        return data.getComponentNameAt(tracerIndex);
    }

    protected String getBTCName(Object key, InvocationData data, int tracerIndex, String fallBack) {
        return data.getComponentNameAt(tracerIndex);
    }

    protected IRepository getSharedRepository(boolean shouldBeConsumedOnRead, int numberOfStripes) {
        if (this.fShouldUseSharedSleep) {
            return new SharedDataStructure(CountMetricGathererWrapper.getFactory(shouldBeConsumedOnRead).getSharedElementInstance());
        }
        if (this.fShouldUseCAS) {
            AtomicCountMetricGathererWrapper wrapper = new AtomicCountMetricGathererWrapper(shouldBeConsumedOnRead);
            return new SharedDataStructureCAS2(wrapper);
        }
        return new SharedDataStructure4(CountMetricGathererWrapper.getFactory(shouldBeConsumedOnRead), numberOfStripes);
    }

    protected IRepository getSharedRepository(ISharedElement wrapper, int numberOfStripes) {
        if (this.fShouldUseSharedSleep) {
            return new SharedDataStructure(wrapper);
        }
        return new SharedDataStructure4(wrapper, numberOfStripes);
    }

    protected IRepository getSharedRepositoryNoSharedStructure(boolean shouldBeConsumedOnRead) {
        if (this.fShouldUseSharedSleep) {
            return new SharedDataStructure(CountMetricGathererWrapper.getFactory(shouldBeConsumedOnRead).getSharedElementInstance());
        }
        if (this.fShouldUseSynchronized) {
            return new SharedDataStructure5(false);
        }
        if (this.fShouldUseCAS) {
            AtomicCountMetricGathererWrapper wrapper = new AtomicCountMetricGathererWrapper(shouldBeConsumedOnRead);
            return new SharedDataStructureCAS2(wrapper);
        }
        return new SharedDataStructure3(CountMetricGathererWrapper.getFactory(shouldBeConsumedOnRead));
    }

    public static IRepository getAverageMetricRepository() {
        return new SharedDataStructure4(AverageMetricGathererWrapper.getFactory(true), 1);
    }

    public static IRepository getCountQueuedRepository(boolean shouldBeConsumedOnRead) {
        return new SharedDataStructure4(CountMetricGathererWrapper.getFactory(shouldBeConsumedOnRead), 1);
    }

    public static IRepository getCountImmediateRepository(boolean shouldBeConsumedOnRead) {
        if (WilyTransactionStructure.fSuggestSynchronizedProperty) {
            return new SharedDataStructure5(false);
        }
        return new SharedDataStructure3(CountMetricGathererWrapper.getFactory(shouldBeConsumedOnRead));
    }

    @Override
    public void doOnStartTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        InvocationData data = (InvocationData)elementData;
        data.setStartCursorAt(element, tracerIndex);
        if (this.fShouldComputeMetrics) {
            long startTime = data.getWallClockStartTime();
            WilyTransactionElement we = (WilyTransactionElement)element;
            data.setComponentNameAt(we.getComponentName(), tracerIndex);
            BlamePointTracer.increaseConcurrentInvocationCounter(we, startTime);
        }
        if (this.fShouldDoStalls && WilyTransactionStructure.fSuggestStallTraceProperty) {
            StallFeatureBase.putStallPoint(data);
        }
        if (ThreadMXBeanTimingFeature.putStartDataPoint(data, this.shouldCollectorCpuTiming, this.shouldCollectAllocatedBytes)) {
            data.setParameterCallback(this.callbackCPUTiming);
        }
    }

    @Override
    protected void doOnAbortedTransactionEndTrace(int tracerIndex, IStackElement elementData) {
        try {
            if (this.fShouldComputeMetrics) {
                InvocationData data = (InvocationData)elementData;
                data.setFinished(true);
                long endTime = data.getWallClockFinishTime();
                ITransactionElement startElement = data.getStartCursorAt(tracerIndex);
                WilyTransactionElement start = (WilyTransactionElement)startElement;
                if (start != null) {
                    BlamePointTracer.decreaseConcurrentInvocationCounter(start, endTime);
                }
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.getAgent().IAgent_getModuleFeedback().error(kBlamePointTracer, "Unable to execute cleanup on aborted transaction");
                this.getAgent().IAgent_getModuleFeedback().debug(kBlamePointTracer, "Unable to execute cleanup on aborted transaction", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void doOnEndTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        if (this.fShouldComputeMetrics && element instanceof WilyTransactionElement) {
            long threshold;
            InvocationData data = (InvocationData)elementData;
            data.setFinished(true);
            int hashcode = data.getThreadHashCode();
            long startTime = data.getWallClockStartTime();
            long endTime = data.getWallClockFinishTime();
            long elapsed = endTime - startTime;
            WilyTransactionElement we = (WilyTransactionElement)element;
            WilyTransactionElement start = we.getWilyStartTraceBlamePoint();
            BlamePointTracer.decreaseConcurrentInvocationCounter(start, endTime);
            IRepository rep = start.getTimerRepository();
            if (rep != null) {
                rep.update((IUpdater)updater, elapsed, endTime, hashcode);
            }
            if ((rep = start.getPerIntervalRepository()) != null) {
                rep.update(increaser, 0L, endTime, hashcode);
            }
            this.updateCustomMetricsIfAny(start, data);
            Iterator i = data.getAppMapSocketCursorsForMetricUpdate();
            if (i != null) {
                while (i.hasNext()) {
                    SocketTransactionElement socketCursor = (SocketTransactionElement)i.next();
                    socketCursor.getTimerRepository().update((IUpdater)updater, elapsed, endTime, hashcode);
                    socketCursor.getPerIntervalRepository().update(increaser, 0L, endTime, hashcode);
                }
            }
            if ((threshold = start.getElapsedTimeAutoTraceThreshold()) > 0L) {
                if (Logger.isTraceEnabled()) {
                    Logger.logTraceMessage("Updating ART metric: auto trace threshold set to " + threshold + ", elapsed time " + elapsed);
                }
                if (elapsed > threshold) {
                    if (Logger.isTraceEnabled()) {
                        String message = String.format("Response time of Component '%s' exceeded baseline threshold %d msActual time %d ms. Requesting AutoTracingController to mark this transaction for tracing.", start.getComponentName(), threshold, elapsed);
                        Logger.logTraceMessage(message);
                    }
                    AutoTracingController.markForAutoTracing(data, String.format(kUnformattedAutoTraceBaselineThresholdTriggerReason, start.getComponentName(), threshold), start.getComponentName());
                }
            }
            ThreadMXBeanTimingFeature.putEndDataPoint(data);
            if (this.shouldCollectCPUTimingMetrics() && start instanceof CPUTimingTransactionElement) {
                CPUTimingTransactionElement cpuElement = (CPUTimingTransactionElement)start;
                rep = cpuElement.getCPUUserTimerRepository();
                Object time = data.get("CPU User Time");
                if (rep != null && time instanceof Long) {
                    rep.update(BlamePointTracer.getUpdater(), (long)((Long)time), endTime, hashcode);
                }
                rep = cpuElement.getCPUSystemTimerRepository();
                time = data.get("CPU System Time");
                if (rep != null && time instanceof Long) {
                    rep.update(BlamePointTracer.getUpdater(), (long)((Long)time), endTime, hashcode);
                }
                rep = cpuElement.getCPUWaitTimerRepository();
                time = data.get("Wait Time");
                if (rep != null && time instanceof Long) {
                    rep.update(BlamePointTracer.getUpdater(), (long)((Long)time), endTime, hashcode);
                }
                rep = cpuElement.getCPUBlockTimerRepository();
                time = data.get("Block Time");
                if (rep != null && time instanceof Long) {
                    rep.update(BlamePointTracer.getUpdater(), (long)((Long)time), endTime, hashcode);
                }
                rep = cpuElement.getAllocatedMemoryByteRepository();
                Object bytes = data.get("Allocated Memory (bytes)");
                if (rep != null && bytes instanceof Long) {
                    rep.update(BlamePointTracer.getUpdater(), (long)((Long)bytes), endTime, hashcode);
                }
            }
        }
        if (this.fShouldDoStalls) {
            StallFeatureBase.putValidParentInStallPoint(elementData);
        }
    }

    public static void doOnSetEmergencyMode(InvocationData data) {
        try {
            long endTime = data.getWallClockFinishTime();
            int i = 0;
            while (i < data.getStartCursorsCount()) {
                ITransactionElement startElement = data.getStartCursorAt(i);
                if (startElement instanceof WilyTransactionElement) {
                    BlamePointTracer.decreaseConcurrentInvocationCounter((WilyTransactionElement)startElement, endTime);
                }
                ++i;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.getAgent().IAgent_getModuleFeedback().error(kBlamePointTracer, "Unable to execute cleanup on set emergency mode");
                AgentShim.getAgent().IAgent_getModuleFeedback().debug(kBlamePointTracer, "Unable to execute cleanup on set emergency mode", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    protected static void increaseConcurrentInvocationCounter(WilyTransactionElement wte, long startTime) {
        ICounterRepository cin = wte.getConcurrentInvocations();
        if (cin != null) {
            cin.increase(startTime);
        } else {
            ICounterRepository[] repArray = wte.getConcurrentInvocationsRepositoryAsArray();
            int i = 0;
            while (i < repArray.length) {
                if (repArray[i] != null) {
                    repArray[i].increase(startTime);
                }
                ++i;
            }
        }
    }

    protected static void decreaseConcurrentInvocationCounter(WilyTransactionElement wte, long endTime) {
        ICounterRepository cin = wte.getConcurrentInvocations();
        if (cin != null) {
            cin.decrease(endTime);
        } else {
            ICounterRepository[] repArray = wte.getConcurrentInvocationsRepositoryAsArray();
            int i = 0;
            while (i < repArray.length) {
                if (repArray[i] != null) {
                    repArray[i].decrease(endTime);
                }
                ++i;
            }
        }
    }

    protected void updateCustomMetricsIfAny(WilyTransactionElement start, InvocationData data) {
    }

    @Override
    public ITransactionElement getElementOnEndTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
        String metricName = ((InvocationData)data).getComponentNameAt(tracerIndex);
        WilyTransactionElement startCursor = (WilyTransactionElement)data.getStartCursorAt(tracerIndex);
        WilyTransactionElement result = new WilyTransactionElement(key, metricName, this.getBlameStatus(), false, parent, null, startCursor, null, null, null, null, null, startCursor.getStallsRepository(), ((InvocationData)data).getProbeInformation(), null, null, null, null, null, null);
        ((InvocationData)data).setHasNewCursor();
        result.setAgentFeatureIndicant(this.getAgentComponent());
        return result;
    }

    protected int getBlameStatus() {
        return 0;
    }

    protected AgentMetric[] createTimerMetricBtc(String formattedMetricName) {
        int metricType = 0x40000401;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createPerIntervalMetricBtc(String formattedMetricName) {
        int metricType = 0x40002002;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createConcurrentInvocationMetricBtc(String formattedMetricName) {
        int metricType = 0x40000101;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createErrorsMetricBtc(String formattedMetricName) {
        int metricType = 0x40002002;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        return new AgentMetric[]{metric};
    }

    protected AgentMetric[] createStallsMetricBtc(String formattedMetricName) {
        int metricType = 1073742209;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an aggregating integer fluctuating counter metric");
        return new AgentMetric[]{metric};
    }

    protected void createContextualMetrics(int tracerIndex, InvocationData data, WilyTransactionElement result, IBlameTransactionElement previous) {
        boolean hasContextualMetricss = this.computeHasContextualMetrics();
        if (!hasContextualMetricss) {
            return;
        }
        ArrayList<AgentMetric> metricsForGrouping = new ArrayList<AgentMetric>(4);
        String safeMetricPath = this.getContectualSafePath(result);
        if (this.shouldForceStandardBlameMetrics()) {
            AgentMetric[] stallMetric = null;
            stallMetric = this.createStallsMetric(this.getStallsMetricName(safeMetricPath));
            result.addMetric(stallMetric, result.fStallsDataStructure);
            metricsForGrouping.add(stallMetric[0]);
        }
        if (this.shouldForceStandardBlameMetrics()) {
            AgentMetric[] errorMetric = null;
            errorMetric = this.createErrorsMetric(this.getErrorsMetricName(safeMetricPath));
            result.addMetric(errorMetric, result.fErrorsDataStructure);
            metricsForGrouping.add(errorMetric[0]);
        }
        AgentMetric[] timerMetric = null;
        timerMetric = this.createTimerMetric(this.getTimerMetricName(safeMetricPath));
        result.addMetric(timerMetric, result.fTimerDataStructure);
        metricsForGrouping.add(timerMetric[0]);
        AgentMetric[] perIntervalMetric = null;
        perIntervalMetric = this.createPerIntervalMetric(this.getPerIntervalMetricName(safeMetricPath));
        result.addMetric(perIntervalMetric, result.fPerIntervalDataStructure);
        metricsForGrouping.add(perIntervalMetric[0]);
        this.getAgent().IAgent_getMetricRecordingAdministrator().addMetricGroup(data.getComponentNameAt(tracerIndex), metricsForGrouping);
    }

    protected void createAdditionalMetrics(int tracerIndex, InvocationData data, WilyTransactionElement result, IBlameTransactionElement previous) {
        if (!this.hasContextualMetrics()) {
            return;
        }
        int i = 0;
        while (i < 10) {
            AgentMetric[] errorMetric;
            AgentMetric[] stallMetric;
            AgentMetric[] perIntervalMetric;
            AgentMetric[] timerMetric;
            String resourceMapped;
            String additionalName = this.getParameter("name" + i);
            if (additionalName == null) break;
            INameFormatter additionalMetricFormatter = kDefaultFormatter;
            String metricNameFormatter = this.getParameter("nameformatter" + i);
            if (metricNameFormatter != null) {
                additionalMetricFormatter = this.getAgent().IAgent_getTracerAdministrator().loadNameFormatter(metricNameFormatter);
            }
            if (additionalMetricFormatter == null) {
                this.getAgent().IAgent_getModuleFeedback().warn("Could not load name formatter for " + metricNameFormatter);
                continue;
            }
            ArrayList<AgentMetric> metricsForGrouping = new ArrayList<AgentMetric>(4);
            boolean useSameTypeForMetric = false;
            String useSameType = this.getParameter(kShouldUseSameTypeAdditionalMetrics + i);
            if (useSameType != null) {
                useSameTypeForMetric = Boolean.valueOf(useSameType);
            }
            if ((resourceMapped = this.getParameter(kAdditionalResourceMapped + i)) != null) {
                if (resourceMapped.equals(kStallAttr) && this.shouldForceStandardBlameMetrics()) {
                    AgentMetric[] stallMetric2 = null;
                    stallMetric2 = useSameTypeForMetric ? this.createStallsMetric(additionalMetricFormatter.INameFormatter_format(additionalName, data)) : this.createAdditionalStallsMetric(additionalMetricFormatter.INameFormatter_format(additionalName, data));
                    result.addMetric(stallMetric2, result.fStallsDataStructure);
                    metricsForGrouping.add(stallMetric2[0]);
                }
                if (resourceMapped.equals(kErrorsAttr) && this.shouldForceStandardBlameMetrics()) {
                    AgentMetric[] errorMetric2 = null;
                    errorMetric2 = useSameTypeForMetric ? this.createErrorsMetric(additionalMetricFormatter.INameFormatter_format(additionalName, data)) : this.createAdditionalErrorsMetric(additionalMetricFormatter.INameFormatter_format(additionalName, data));
                    result.addMetric(errorMetric2, result.fErrorsDataStructure);
                    metricsForGrouping.add(errorMetric2[0]);
                }
                if (resourceMapped.equals(kResponseTimeAttr)) {
                    timerMetric = null;
                    timerMetric = useSameTypeForMetric ? this.createTimerMetric(additionalMetricFormatter.INameFormatter_format(additionalName, data)) : this.createAdditionalTimerMetric(additionalMetricFormatter.INameFormatter_format(additionalName, data));
                    result.addMetric(timerMetric, result.fTimerDataStructure);
                    metricsForGrouping.add(timerMetric[0]);
                }
                if (resourceMapped.equals(kPerIntervalAttr)) {
                    AgentMetric[] perIntervalMetric2 = null;
                    perIntervalMetric2 = useSameTypeForMetric ? this.createPerIntervalMetric(additionalMetricFormatter.INameFormatter_format(additionalName, data)) : this.createAdditionalPerIntervalMetric(additionalMetricFormatter.INameFormatter_format(additionalName, data));
                    result.addMetric(perIntervalMetric2, result.fPerIntervalDataStructure);
                    metricsForGrouping.add(perIntervalMetric2[0]);
                }
            } else if (useSameTypeForMetric) {
                timerMetric = this.createTimerMetric(this.getTimerMetricName(additionalMetricFormatter.INameFormatter_format(additionalName, data)));
                result.addMetric(timerMetric, result.fTimerDataStructure);
                metricsForGrouping.add(timerMetric[0]);
                perIntervalMetric = this.createPerIntervalMetric(this.getPerIntervalMetricName(additionalMetricFormatter.INameFormatter_format(additionalName, data)));
                result.addMetric(perIntervalMetric, result.fPerIntervalDataStructure);
                metricsForGrouping.add(perIntervalMetric[0]);
                if (this.shouldForceStandardBlameMetrics()) {
                    stallMetric = this.createStallsMetric(this.getStallsMetricName(additionalMetricFormatter.INameFormatter_format(additionalName, data)));
                    result.addMetric(stallMetric, result.fStallsDataStructure);
                    metricsForGrouping.add(stallMetric[0]);
                    errorMetric = this.createErrorsMetric(this.getErrorsMetricName(additionalMetricFormatter.INameFormatter_format(additionalName, data)));
                    result.addMetric(errorMetric, result.fErrorsDataStructure);
                    metricsForGrouping.add(errorMetric[0]);
                }
            } else {
                timerMetric = this.createAdditionalTimerMetric(this.getTimerMetricName(additionalMetricFormatter.INameFormatter_format(additionalName, data)));
                result.addMetric(timerMetric, result.fTimerDataStructure);
                metricsForGrouping.add(timerMetric[0]);
                perIntervalMetric = this.createAdditionalPerIntervalMetric(this.getPerIntervalMetricName(additionalMetricFormatter.INameFormatter_format(additionalName, data)));
                result.addMetric(perIntervalMetric, result.fPerIntervalDataStructure);
                metricsForGrouping.add(perIntervalMetric[0]);
                if (this.shouldForceStandardBlameMetrics()) {
                    stallMetric = this.createAdditionalStallsMetric(this.getStallsMetricName(additionalMetricFormatter.INameFormatter_format(additionalName, data)));
                    result.addMetric(stallMetric, result.fStallsDataStructure);
                    metricsForGrouping.add(stallMetric[0]);
                    errorMetric = this.createAdditionalErrorsMetric(this.getErrorsMetricName(additionalMetricFormatter.INameFormatter_format(additionalName, data)));
                    result.addMetric(errorMetric, result.fErrorsDataStructure);
                    metricsForGrouping.add(errorMetric[0]);
                }
            }
            this.getAgent().IAgent_getMetricRecordingAdministrator().addMetricGroup(additionalName, metricsForGrouping);
            ++i;
        }
    }

    @Override
    public boolean canCacheInvocationData() {
        return true;
    }

    @Override
    public boolean canCacheTracerInstances() {
        return true;
    }

    @Override
    public boolean canCacheComponentNames() {
        return this.canUseCaching();
    }

    protected String getPrefixForBtcMetrics(InvocationData data) {
        return "";
    }

    protected void addBusinessTransactionMetrics(InvocationData data, WilyTransactionElement result) {
        IBizTrx businessTransaction = (IBizTrx)data.get("BusinessTrxData");
        if (businessTransaction != null && businessTransaction.isIdentifying()) {
            String metricName = businessTransaction.getBizFullName();
            String calledPrefix = this.getPrefixForBtcMetrics(data);
            ArrayList<AgentMetric> metricsForGrouping = new ArrayList<AgentMetric>(4);
            AgentMetric[] concurrentMetric = this.createConcurrentInvocationMetricBtc(String.valueOf(calledPrefix) + this.getConcurrentInvocationMetricName(metricName));
            IRepository concurrentSds = this.getSharedRepositoryNoSharedStructure(false);
            this.getWilyTransactionStructureInstance();
            IRepository existingSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent(new AAgentMetricArray(concurrentMetric), concurrentSds);
            if (existingSds != null) {
                concurrentSds = existingSds;
            }
            result.addConcurrentInvocation(concurrentSds);
            metricsForGrouping.add(concurrentMetric[0]);
            AgentMetric[] timerMetric = this.createTimerMetricBtc(String.valueOf(calledPrefix) + this.getTimerMetricName(metricName));
            result.addMetric(timerMetric, result.fTimerDataStructure);
            metricsForGrouping.add(timerMetric[0]);
            AgentMetric[] perIntervalMetric = this.createPerIntervalMetricBtc(String.valueOf(calledPrefix) + this.getPerIntervalMetricName(metricName));
            result.addMetric(perIntervalMetric, result.fPerIntervalDataStructure);
            metricsForGrouping.add(perIntervalMetric[0]);
            if (this.shouldForceStandardBlameMetrics()) {
                AgentMetric[] stallMetric = this.createStallsMetricBtc(String.valueOf(calledPrefix) + this.getStallsMetricName(metricName));
                result.addMetric(stallMetric, result.fStallsDataStructure);
                metricsForGrouping.add(stallMetric[0]);
                AgentMetric[] errorMetric = this.createErrorsMetricBtc(String.valueOf(calledPrefix) + this.getErrorsMetricName(metricName));
                result.addMetric(errorMetric, result.fErrorsDataStructure);
                metricsForGrouping.add(errorMetric[0]);
            }
            this.getAgent().IAgent_getMetricRecordingAdministrator().addMetricGroup(metricName, metricsForGrouping);
        }
    }

    @Override
    public boolean isActive() {
        return this.kGenerateTransactionElement;
    }

    protected AgentMetric[] createLongTypeMetric(String formattedMetricName) {
        int metricType = 1026;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
        return new AgentMetric[]{metric};
    }

    static final class NonCombiningUpdater
    implements IUpdater {
        NonCombiningUpdater() {
        }

        @Override
        public final void update(IGathererElement element, long value, long startTime, long endTime) {
            element.setValue(value);
            element.combineTime(startTime);
        }

        @Override
        public final void update(IGathererElement repository, long value, long time) {
            repository.setValue(value);
            repository.combineTime(time);
        }
    }

    static final class Updater
    implements IUpdater {
        Updater() {
        }

        @Override
        public final void update(IGathererElement element, long value, long startTime, long endTime) {
            element.combineValue(value);
            element.combineTime(startTime);
        }

        @Override
        public final void update(IGathererElement repository, long value, long time) {
            repository.combineValue(value);
            repository.combineTime(time);
        }
    }
}

