/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io.clamp;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.io.clamp.ASocketClampManager;
import com.wily.introscope.agent.trace.io.clamp.TracedSockets;
import com.wily.introscope.agent.trace.nio.SocketChannelMap;
import com.wily.util.properties.AttributeListing;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;

public class ChannelClampManager
extends ASocketClampManager {
    public ChannelClampManager(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected void decideOnClamp(InvocationData data) {
        SocketChannel channel = (SocketChannel)data.getInvocationObject();
        if (SocketChannelMap.isClientConnection(channel)) {
            this.decideForClient(channel, data);
        } else {
            this.decideForServer(channel, data);
        }
    }

    private void decideForServer(SocketChannel channel, InvocationData data) {
        boolean traced = false;
        try {
            traced = TracedSockets.isTraced(channel.socket().getLocalPort());
            if (!traced) {
                data.setSocketClamp(!traced);
            }
        }
        catch (Exception e) {
            this.getModuleFeedback().error(e);
        }
    }

    protected void decideForClient(SocketChannel channel, InvocationData data) {
        boolean traced = false;
        try {
            InetSocketAddress address = (InetSocketAddress)channel.socket().getRemoteSocketAddress();
            traced = TracedSockets.isTraced(address);
            if (!traced) {
                data.setSocketClamp(!traced);
            }
        }
        catch (Exception e) {
            this.getModuleFeedback().error(e);
        }
    }
}

