/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.standalone;

import com.wily.introscope.agent.upgrade.merge.MergeAdministrator;
import com.wily.introscope.agent.upgrade.merge.MergeException;

public class MergeMain {
    public static final String kLine = System.getProperty("line.separator");
    public static final String kTab = "    ";
    public static final String kCustomerDirParam = "customerDir";
    public static final String kUpgradeDirParam = "upgradeDir";
    public static final String kMergeRulePath = "rule";

    private static void usage() {
        StringBuffer usageBuffer = new StringBuffer();
        usageBuffer.append(String.valueOf(kLine) + kLine + "Usage: java -jar MergeUtility.jar customerDir=<customerDir> upgradedir=<upgradeDir> rule=<rule file path>(OPTIONAL)");
        usageBuffer.append(String.valueOf(kLine) + kLine + "Where:").append(String.valueOf(kLine) + kTab + kTab + "<customerDir>    is the location of a directory containing").append(String.valueOf(kLine) + kTab + kTab + "                 customer's config files like profile,pbl and pbd").append(String.valueOf(kLine) + kTab + kTab + "<upgradeDir>     is the location of a directory containing").append(String.valueOf(kLine) + kTab + kTab + "                 upgrade configuration files").append(String.valueOf(kLine) + kTab + kTab + "<rule>           is the absolute path of the merge rule file (OPTIONAL)");
        usageBuffer.append(String.valueOf(kLine) + kLine + "Example (with merge rule supplied):").append(String.valueOf(kLine) + "java -jar MergeUtility.jar customerDir=\"C:/wily/core/config\" upgradedir=\"C:/upgrade/core/config\" rule=\"C:/patch/upgrade/merge_rules.xml\"");
        usageBuffer.append(String.valueOf(kLine) + kLine + "Example (without merge rules):").append(String.valueOf(kLine) + "java -jar MergeUtility.jar customerDir=\"C:/wily/core/config\" upgradedir=\"C:/upgrade/core/config\"");
        usageBuffer.append(String.valueOf(kLine) + kLine + "For a detailed explanation of this utility's full functionality, see the").append(String.valueOf(kLine) + "Java Agent Guide.");
        System.out.println(usageBuffer);
    }

    private static void merge(String[] args) {
        String customerDir = null;
        String upgradeDir = null;
        String mergeRulePath = null;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            String[] tokens = arg.split("=");
            if (tokens.length != 2) {
                System.out.println("Invalid parameter: " + arg);
                MergeMain.usage();
                System.exit(0);
            }
            if (kCustomerDirParam.equalsIgnoreCase(tokens[0])) {
                customerDir = tokens[1];
            } else if (kUpgradeDirParam.equalsIgnoreCase(tokens[0])) {
                upgradeDir = tokens[1];
            } else if (kMergeRulePath.equalsIgnoreCase(tokens[0])) {
                mergeRulePath = tokens[1];
            } else {
                System.out.println("Invalid parameter: " + arg);
                MergeMain.usage();
                System.exit(0);
            }
            ++n2;
        }
        if (customerDir == null) {
            System.out.println("Missing customerDir");
            MergeMain.usage();
            System.exit(0);
        }
        if (upgradeDir == null) {
            System.out.println("Missing upgradeDir");
            MergeMain.usage();
            System.exit(0);
        }
        try {
            MergeAdministrator.doMergeMain(upgradeDir, customerDir, mergeRulePath);
            System.out.println("***** Merge Tool has finished operation.");
        }
        catch (MergeException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length == 0 || args[0] != null && args[0].equals("usage")) {
            MergeMain.usage();
        } else {
            MergeMain.merge(args);
        }
    }
}

