/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.service;

import com.wily.isengard.postoffice.Address;
import com.wily.util.io.IConstructorExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;

public class MessageServiceInfo
implements IConstructorExternalizable {
    private final String fServiceName;
    private final Map fProperties;
    private final Address fAddress;

    public MessageServiceInfo(Address address, String serviceName, Map properties) {
        this.fAddress = address;
        this.fServiceName = serviceName;
        this.fProperties = properties;
    }

    public MessageServiceInfo(ObjectInput in) throws ClassNotFoundException, IOException {
        this.fAddress = (Address)in.readObject();
        this.fServiceName = in.readUTF();
        this.fProperties = (Map)in.readObject();
    }

    public String getServiceName() {
        return this.fServiceName;
    }

    public Address getServiceAddress() {
        return this.fAddress;
    }

    public Class getServiceClass() throws ClassNotFoundException {
        return Class.forName((String)this.fProperties.get("Interface"));
    }

    public Map getProperties() {
        return this.fProperties;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fAddress);
        out.writeUTF(this.fServiceName);
        out.writeObject(this.fProperties);
    }

    public String toString() {
        return "Service=" + this.fServiceName + ", " + this.fAddress + ", Properties=" + this.fProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MessageServiceInfo) {
            MessageServiceInfo compareTo = (MessageServiceInfo)o;
            if (this.fServiceName != compareTo.fServiceName) {
                return false;
            }
            if (!this.fProperties.equals(compareTo.fProperties)) {
                return false;
            }
            return this.fAddress.equals(compareTo.fAddress);
        }
        return false;
    }

    public int hashCode() {
        return this.fServiceName.hashCode();
    }
}

