/*
 * Decompiled with CFR 0.152.
 */
package com.wily.net;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.BlameStackAnnotationHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.IBlameStackAnnotator;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.intelligent.detection.AutomaticBoundaryDetectionAdmin;
import com.wily.introscope.agent.probe.net.ManagedSocketMapHelper;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.io.SocketBackendTracer;
import com.wily.introscope.agent.trace.io.SocketFormatMetricsCache;
import com.wily.introscope.agent.trace.io.SocketFormatterCache;
import com.wily.util.adt.ConcurrentWeakThreadLocalHashMap;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.adt.QueueWrapper;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.net.SocketOutputStream;
import java.util.Iterator;

public final class AgentSocketOutputStream {
    private static final IWeakIdentityMap kMap;
    private static final int kDefaultMaxSize = 256;
    private static final int kMaxQueueSize;
    private static final String kAnnotateTitle = "Socket Write";
    private WeakReference<Socket> fWilySocket;
    private volatile SocketFormatMetricsCache fCache;

    static {
        try {
            ManagedSocketMapHelper.initializeIfNeccessary();
        }
        catch (Throwable t) {
            AgentShim.handleError("Exception in initializing ManagedSocketMapHelper", t);
        }
        IWeakIdentityMap LRUHighConcurrencyMap = null;
        int valueForMaxQueue = 256;
        try {
            IAgent agent = ManagedSocketMapHelper.getAgent();
            if (agent != null) {
                IConcurrentMapFactory factory = agent.IAgent_getConcurrentMapFactory();
                if (factory != null) {
                    LRUHighConcurrencyMap = factory.getConcurrentCappedWeakIdentityMap("managedSocketOutput");
                }
                valueForMaxQueue = agent.IAgent_getIndexedProperties().getIntProperty("concurrentMapPolicy.managedSocketOutput.maxqueuesize", 256);
            }
        }
        catch (Throwable t) {
            AgentShim.handleError("Exception in initializing ManagedSocketOutputStreamHighPerformanceNew", t);
        }
        if (LRUHighConcurrencyMap != null) {
            kMap = LRUHighConcurrencyMap;
        } else {
            AgentShim.handleDebug("Exception in initializing ManagedSocketOutputStreamHighPerformanceNew. No map for handling matching of stream with sockets.", new Exception());
            kMap = null;
        }
        kMaxQueueSize = valueForMaxQueue;
    }

    public static void postFlight(Socket socket, SocketFormatMetricsCache cache) {
        QueueWrapper list;
        if (kMap != null && (list = (QueueWrapper)kMap.getWeak(socket)) != null) {
            Iterator<?> i = list.iterator();
            while (i.hasNext()) {
                Socket s;
                WeakReference wr = (WeakReference)i.next();
                AgentSocketOutputStream element = (AgentSocketOutputStream)wr.get();
                if (element == null || (s = element.getWilySocket()) == null || s != socket || element.fCache != null) continue;
                element.fCache = cache;
                list.removeCurrentInIterator(i);
            }
        }
    }

    protected SocketFormatMetricsCache getCache() {
        return this.fCache;
    }

    public void setCache(Socket socket) {
        this.fWilySocket = new WeakReference<Socket>(socket);
        ConcurrentWeakThreadLocalHashMap<Socket, SocketFormatMetricsCache> map = SocketFormatterCache.kSocketMetricCache;
        this.fCache = map.getWeak(socket);
        if (this.fCache == null) {
            QueueWrapper listInMap = (QueueWrapper)kMap.getWeak(socket);
            if (listInMap == null) {
                listInMap = new QueueWrapper(kMaxQueueSize);
            }
            listInMap.offer(new WeakReference<AgentSocketOutputStream>(this));
            if (kMap.containsWeakKey(socket)) {
                QueueWrapper existingList = (QueueWrapper)kMap.getWeak(socket);
                existingList.offer(new WeakReference<AgentSocketOutputStream>(this));
            } else {
                kMap.putWeak(socket, listInMap);
            }
        }
    }

    public final boolean addToConcurrentWriters(String methodName) throws IOException {
        boolean addedConcurrentWriter = false;
        try {
            this.fCache.addToConcurrentWriters();
            addedConcurrentWriter = true;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception preparing " + methodName + " in High Performance Output Stream ", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return addedConcurrentWriter;
    }

    public void addToOutputBandwidth(int byteWritten) {
        try {
            this.fCache.addToOutputBandwidth(byteWritten);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public void removeFromConcurrentWriters(boolean addedConcurrentWriter, String methodName) {
        try {
            if (addedConcurrentWriter) {
                this.fCache.removeFromConcurrentWriters();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception ending " + methodName + " in High Performance Output Stream ", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    public final int addToAppMap(String methodName) {
        int result = 0;
        try {
            String component = this.fCache.getFormattedMetrics(10);
            if (component != null) {
                result = ManagedSocketMapHelper.addToAppMapIfEnabled(component);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception preparing " + methodName + " in High Performance Output Stream ", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    public final void removeFromAppMap(int addedAppMapInfo, String methodName) {
        try {
            String component;
            if (this.fCache.isClientConnection() && (component = this.fCache.getFormattedMetrics(10)) != null) {
                ManagedSocketMapHelper.removeFromAppMapIfEnabled(addedAppMapInfo, component);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception ending " + methodName + " in High Performance Output Stream ", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    public final Socket getWilySocket() {
        return (Socket)this.fWilySocket.get();
    }

    public final void annotateBlameStack() {
        String formattedMetricName = this.fCache.getFormattedMetrics(9);
        SocketBackendTracer.annotateBlameStack(formattedMetricName, kAnnotateTitle, this.fCache);
    }

    public final void annotateBlameStack(SocketOutputStream socketOutputStream) {
        IBlameStackAnnotator defaultBackendBlameStackAnnotator;
        IStackElement currentData = VirtualStack.peekIfNew(socketOutputStream);
        if (currentData == null) {
            return;
        }
        ITransactionElement currentCursor = currentData.getCursor();
        if (currentCursor != null && (defaultBackendBlameStackAnnotator = BlameStackAnnotationHelper.getBlameStackAnnotator(BlameStackAnnotationHelper.kDefaultBackendBlameStackAnnotator)) != null) {
            String formattedMetricName = this.fCache.getFormattedMetrics(9);
            defaultBackendBlameStackAnnotator.annotateBlameStack((Object)formattedMetricName, this.fCache.getLocalAddress(), this.fCache.getHostName(), this.fCache.getHostAddress(), this.fCache.getPort(), currentCursor, currentData, true);
        }
    }

    public final boolean suggestStackTraceRecording() {
        return AutomaticBoundaryDetectionAdmin.getInstance().getStrackTraceRecorder().record();
    }
}

