/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.parent.instrumentation.helper;

import com.ca.apm.parent.instrumentation.helper.IntegerPropertyHandler;
import com.ca.apm.parent.instrumentation.helper.JMSInstrumentationConstants;
import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SimpleModuleFeedbackChannel;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.text.IStringLocalizer;

public class ParentInstrumentationConfig {
    private IAgent agent;
    private IModuleFeedbackChannel moduleFeedbackChannel = new SimpleModuleFeedbackChannel("JMS Parent Instrumentation");
    private Module module = new Module("JMSParentInstrumentation");
    private ConfigurationManager configManager;
    private static IntegerPropertyHandler persistenceTraceDirectivesClampSize;
    private static IntegerPropertyHandler persistenceClampSize;
    private static IntegerPropertyHandler receiveStackDataClampSize;
    private static IntegerPropertyHandler parentMethodIdentificationStaticIndexSize;
    private static BooleanConfigurationProperty threadStartDetectionProperty;
    private static volatile boolean threadStartDetectionEnabled;

    static {
        threadStartDetectionEnabled = true;
    }

    public void init(IAgent agent) {
        if (agent != null) {
            this.agent = agent;
            this.moduleFeedbackChannel = agent.IAgent_getModuleFeedback();
            this.configManager = agent.IAgent_getConfigurationManager();
            this.initProperties();
        }
    }

    private void initProperties() {
        IStringLocalizer localizer = this.agent.IAgent_getStringLocalizer();
        persistenceTraceDirectivesClampSize = new PersistenceTraceDirectivesClampSize("jms.receive.parent.methods.count.max", JMSInstrumentationConstants.persistenceTraceDirectivesClampDefault, this.moduleFeedbackChannel, this.module, localizer);
        this.configManager.add((ConfigurationProperty)persistenceTraceDirectivesClampSize, true);
        persistenceClampSize = new PersistenceClampSize("jms.receive.parent.identification.persistent.queue.size", JMSInstrumentationConstants.persistenceQueueSizeDefault, this.moduleFeedbackChannel, this.module, localizer);
        this.configManager.add((ConfigurationProperty)persistenceClampSize, true);
        receiveStackDataClampSize = new ReceiveStackDataClampSize("jms.receive.parent.identification.stackTrace.queue.size", JMSInstrumentationConstants.receiveStackDataMapSizeDefault, this.moduleFeedbackChannel, this.module, localizer);
        this.configManager.add((ConfigurationProperty)receiveStackDataClampSize, true);
        parentMethodIdentificationStaticIndexSize = new ParentMethodIdentificationStaticIndexSize("jms.receive.parent.lookupFallback.maximumDepth", 7, this.moduleFeedbackChannel, this.module, localizer);
        this.configManager.add((ConfigurationProperty)parentMethodIdentificationStaticIndexSize, true);
        threadStartDetectionProperty = new BooleanConfigurationProperty("jms.receive.parent.enable.threadStartDetection", Boolean.TRUE, this.moduleFeedbackChannel, this.module, localizer){

            public void set(Object newValue) {
                threadStartDetectionEnabled = (Boolean)newValue;
            }
        };
        this.configManager.add((ConfigurationProperty)threadStartDetectionProperty);
    }

    public static final boolean isThreadStartDetectionEnabled() {
        return threadStartDetectionEnabled;
    }

    public static final int getPersistenceTraceDirectivesClampSize() {
        if (persistenceTraceDirectivesClampSize != null) {
            return persistenceTraceDirectivesClampSize.getIntegerValue();
        }
        return JMSInstrumentationConstants.persistenceTraceDirectivesClampDefault;
    }

    public static final int getPersistenceQueueClampSize() {
        if (persistenceClampSize != null) {
            return persistenceClampSize.getIntegerValue();
        }
        return JMSInstrumentationConstants.persistenceQueueSizeDefault;
    }

    public static final int getReceiveStackDataClampSize() {
        if (receiveStackDataClampSize != null) {
            return receiveStackDataClampSize.getIntegerValue();
        }
        return JMSInstrumentationConstants.receiveStackDataMapSizeDefault;
    }

    public static final int getParentIdentificationStaticIndexValue() {
        if (parentMethodIdentificationStaticIndexSize != null) {
            return parentMethodIdentificationStaticIndexSize.getIntegerValue();
        }
        return 7;
    }

    private static class ParentMethodIdentificationStaticIndexSize
    extends IntegerPropertyHandler {
        public ParentMethodIdentificationStaticIndexSize(String name, Integer defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, feedback, module, localizer);
        }

        @Override
        public void set(Object newValue) {
            if ((Integer)newValue > 15) {
                super.set(15);
            } else {
                super.set(newValue);
            }
        }
    }

    private static class PersistenceClampSize
    extends IntegerPropertyHandler {
        public PersistenceClampSize(String name, Integer defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, feedback, module, localizer);
        }

        @Override
        public void set(Object newValue) {
            super.set(newValue);
        }
    }

    private static class PersistenceTraceDirectivesClampSize
    extends IntegerPropertyHandler {
        public PersistenceTraceDirectivesClampSize(String name, Integer defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, feedback, module, localizer);
        }

        @Override
        public void set(Object newValue) {
            if ((Integer)newValue > 250) {
                super.set(250);
            } else {
                super.set(newValue);
            }
        }
    }

    private static class ReceiveStackDataClampSize
    extends IntegerPropertyHandler {
        public ReceiveStackDataClampSize(String name, Integer defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, feedback, module, localizer);
        }

        @Override
        public void set(Object newValue) {
            super.set(newValue);
        }
    }
}

