/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.validate;

import com.wily.util.datetime.DateTimeUtilities;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.validate.IdentifiableObjectValidationException;

public class ValidationInvalidBoundedLongException
extends IdentifiableObjectValidationException {
    private static final long serialVersionUID = -4180257098802039639L;
    private long fMin;
    private long fMax;

    public ValidationInvalidBoundedLongException(long min, long max) {
        this.fMin = min;
        this.fMax = max;
    }

    public ValidationInvalidBoundedLongException(ILocalizableMessage invalidObjectIdentifier, long min, long max) {
        super(invalidObjectIdentifier);
        this.fMin = min;
        this.fMax = max;
    }

    public ILocalizableMessage getInvalidObjectRequiredCondition() {
        ILocalizableMessage minMessage = DateTimeUtilities.getHoursMinutesSecondsDuration(this.getMin());
        ILocalizableMessage maxMessage = DateTimeUtilities.getHoursMinutesSecondsDuration(this.getMax());
        return new FormattedLocalizableMessage("Validation_Invalid_Bounded_Long_Condition", minMessage, maxMessage);
    }

    protected long getMin() {
        return this.fMin;
    }

    protected long getMax() {
        return this.fMax;
    }
}

