/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.platform;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.platform.AggregateCPUUtilizationPoller;
import com.wily.introscope.agent.platform.IPlatformStatistics;
import com.wily.introscope.agent.platform.PlatformLibraryException;
import com.wily.introscope.agent.platform.PlatformLibraryNotSupportedException;
import com.wily.introscope.agent.platform.PlatformStatUnavailableException;
import com.wily.introscope.agent.platform.ProcessCPUUtilizationPoller;
import com.wily.introscope.agent.poll.IMetricRecordingAwareDataPoller;
import com.wily.introscope.agent.recording.MetricRecordingPollerHandler;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.util.properties.IndexedProperties;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public final class PlatformStatisticsHandler {
    private static final String kPlatformMonitorNameKey = "Platform-Monitor-Name";
    private static final String kPlatformMonitorClassKey = "Platform-Monitor-Class";
    private static final Class[] kPlatformStatisticsConstructorParameterTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PlatformStatisticsHandler.class$("java.lang.String")) : class$java$lang$String, class$com$wily$introscope$agent$IAgent == null ? (class$com$wily$introscope$agent$IAgent = PlatformStatisticsHandler.class$("com.wily.introscope.agent.IAgent")) : class$com$wily$introscope$agent$IAgent};
    private final IPlatformStatistics fPlatformStatistics;
    private MetricRecordingPollerHandler fProcessCPUHandler;
    private MetricRecordingPollerHandler[] fAggregateCPUHandlers;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$wily$introscope$agent$IAgent;

    public PlatformStatisticsHandler(IAgent agent, Map parameters) {
        this.fPlatformStatistics = this.loadPlatformMonitor(agent, parameters);
        if (this.fPlatformStatistics != null) {
            this.initializePlatformMetrics(agent);
            agent.IAgent_getModuleFeedback().info(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Platform_Monitor_Initialized_Message", this.fPlatformStatistics.IPlatformStatistics_getName()));
        }
    }

    IPlatformStatistics getPlatformStatistics() {
        return this.fPlatformStatistics;
    }

    private IPlatformStatistics loadPlatformMonitor(IAgent agent, Map parameters) {
        String platformMonitorName = (String)parameters.get(kPlatformMonitorNameKey);
        if (platformMonitorName == null) {
            agent.IAgent_getModuleFeedback().error(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Platform_Monitor_Name_Parameter_Not_Found_Message", kPlatformMonitorNameKey));
            return null;
        }
        String platformMonitorClassName = (String)parameters.get(kPlatformMonitorClassKey);
        if (platformMonitorClassName == null) {
            agent.IAgent_getModuleFeedback().error(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Platform_Monitor_Class_Parameter_Not_Found_Message", platformMonitorName, kPlatformMonitorClassKey));
            return null;
        }
        return this.createPlatformMonitor(agent, platformMonitorName, platformMonitorClassName);
    }

    private IPlatformStatistics createPlatformMonitor(IAgent agent, String platformMonitorName, String platformMonitorClassName) {
        try {
            Class<?> platformMonitorClass = Class.forName(platformMonitorClassName);
            Constructor<?> constructor = platformMonitorClass.getConstructor(kPlatformStatisticsConstructorParameterTypes);
            return (IPlatformStatistics)constructor.newInstance(platformMonitorName, agent);
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            if (target instanceof PlatformLibraryException) {
                if (target instanceof PlatformLibraryNotSupportedException) {
                    agent.IAgent_getModuleFeedback().verbose(((PlatformLibraryException)target).ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(agent.IAgent_getStringLocalizer()));
                } else {
                    agent.IAgent_getModuleFeedback().error(((PlatformLibraryException)target).ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(agent.IAgent_getStringLocalizer()));
                }
                agent.IAgent_getModuleFeedback().debug(target);
            } else if (target instanceof SecurityException) {
                agent.IAgent_getModuleFeedback().error(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Platform_Monitor_Security_Exception_Message", platformMonitorName));
                agent.IAgent_getModuleFeedback().verbose(target);
            } else if (target instanceof UnsatisfiedLinkError) {
                agent.IAgent_getModuleFeedback().error(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Platform_Monitor_Missing_Native_Library_Message", platformMonitorName));
                agent.IAgent_getModuleFeedback().verbose(target);
            } else {
                agent.IAgent_getModuleFeedback().error(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Platform_Monitor_Creation_Failed_Message", platformMonitorName, target.toString()));
                agent.IAgent_getModuleFeedback().verbose(target);
            }
        }
        catch (Throwable t) {
            agent.IAgent_getModuleFeedback().error(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Platform_Monitor_Unable_To_Load_Platform_Monitor_Message", platformMonitorName, platformMonitorClassName));
            agent.IAgent_getModuleFeedback().verbose(t);
        }
        return null;
    }

    private void initializePlatformMetrics(IAgent agent) {
        DataAccumulatorFactory factory = agent.IAgent_getDataAccumulatorFactory();
        this.initializeProcessID(factory);
        IndexedProperties props = agent.IAgent_getIndexedProperties();
        Assertion.wilyAssert(props != null);
        boolean disableProcessCPU = props.getBooleanProperty("introscope.agent.disableProcessCPUUtilization");
        if (!disableProcessCPU) {
            this.initializeProcessCPUUtilizationPoller(agent, factory);
        } else {
            agent.IAgent_getModuleFeedback().info(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Platform_Monitor_Process_CPU_Utilization_Disabled_Message", ""));
        }
        boolean disableAggregateCPU = props.getBooleanProperty("introscope.agent.disableAggregateCPUUtilization");
        if (!disableAggregateCPU) {
            int cpuCount = this.initializeCPUCount(factory);
            this.initializeAggregateCPUUtilizationPollers(agent, factory, cpuCount);
        } else {
            agent.IAgent_getModuleFeedback().info(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Platform_Monitor_Aggregate_CPU_Utilization_Disabled_Message", ""));
        }
        this.initializePlatformSpecificStatistics(agent);
    }

    private void initializeProcessID(DataAccumulatorFactory factory) {
        try {
            long pid = this.fPlatformStatistics.IPlatformStatistics_getProcessID();
            factory.safeGetStringConstantDataAccumulator("ProcessID", String.valueOf(pid));
        }
        catch (PlatformLibraryException ple) {
        }
        catch (PlatformStatUnavailableException platformStatUnavailableException) {
            // empty catch block
        }
    }

    private int initializeCPUCount(DataAccumulatorFactory factory) {
        int cpuCount = 1;
        try {
            cpuCount = this.fPlatformStatistics.IPlatformStatistics_getCPUCount();
            factory.safeGetIntegerConstantDataAccumulator("CPU:Processor Count", cpuCount);
        }
        catch (PlatformLibraryException ple) {
        }
        catch (PlatformStatUnavailableException platformStatUnavailableException) {
            // empty catch block
        }
        return cpuCount;
    }

    private void initializeProcessCPUUtilizationPoller(IAgent agent, DataAccumulatorFactory factory) {
        ProcessCPUUtilizationPoller poller = new ProcessCPUUtilizationPoller(factory, this.fPlatformStatistics);
        this.fProcessCPUHandler = new MetricRecordingPollerHandler(agent, (IMetricRecordingAwareDataPoller)poller);
    }

    private void initializeAggregateCPUUtilizationPollers(IAgent agent, DataAccumulatorFactory factory, int cpuCount) {
        this.fAggregateCPUHandlers = new MetricRecordingPollerHandler[cpuCount];
        for (int linearZeroBaseCPUIndex = 0; linearZeroBaseCPUIndex < cpuCount; ++linearZeroBaseCPUIndex) {
            AggregateCPUUtilizationPoller poller = new AggregateCPUUtilizationPoller(agent.IAgent_getModuleFeedback(), factory, this.fPlatformStatistics, linearZeroBaseCPUIndex, this.fPlatformStatistics.IPlatformStatistics_mapLinearZeroBasedCPUIndexToOSName(linearZeroBaseCPUIndex));
            this.fAggregateCPUHandlers[linearZeroBaseCPUIndex] = new MetricRecordingPollerHandler(agent, (IMetricRecordingAwareDataPoller)poller);
        }
    }

    private void initializePlatformSpecificStatistics(IAgent agent) {
        try {
            this.fPlatformStatistics.IPlatformStatistics_initializePlatformSpecificStatistics();
        }
        catch (PlatformLibraryException ple) {
            agent.IAgent_getModuleFeedback().debug(ple.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(agent.IAgent_getStringLocalizer()));
            agent.IAgent_getModuleFeedback().debug(ple);
        }
    }

    public static String constructProcessorSpecificResource(int osProcessorName) {
        return "CPU|Processor " + Integer.toString(osProcessorName);
    }

    IPlatformStatistics debug_getPlatformStatistics() {
        return this.fPlatformStatistics;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

