/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.metric.calculator;

import com.wily.introscope.agent.metric.calculator.CalculatorService;
import com.wily.introscope.agent.metric.calculator.MetricPatternUtils;
import com.wily.introscope.agent.metric.calculator.Operation;
import com.wily.introscope.agent.metric.calculator.Variables;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Calculator {
    private String metricPattern;
    private String metricRegex;
    private final List<Operation> operations = new ArrayList<Operation>();
    private Pattern metricRegexPattern;
    private CalculatorService service;

    public Calculator setMetricRegex(String metricRegex) {
        this.metricRegex = metricRegex;
        this.metricRegexPattern = Pattern.compile(metricRegex);
        return this;
    }

    public Calculator setMetricPattern(String pattern) {
        this.metricPattern = pattern;
        this.metricRegex = MetricPatternUtils.convertPatternToRegex(this.metricPattern);
        this.metricRegexPattern = Pattern.compile(this.metricRegex);
        return this;
    }

    public void calculate(Map<String, IMetricDataValue> input) {
        if (this.metricRegexPattern == null) {
            if (this.metricRegex == null) {
                this.metricRegex = MetricPatternUtils.convertPatternToRegex(this.metricPattern);
            }
            this.metricRegexPattern = Pattern.compile(this.metricRegex);
        }
        HashSet<Variables> variableSet = new HashSet<Variables>();
        for (String metric : input.keySet()) {
            this.calculate(metric, variableSet);
        }
    }

    public Calculator setService(CalculatorService service) {
        this.service = service;
        for (Operation op : this.operations) {
            op.setService(service);
        }
        return this;
    }

    private void calculate(String metric, Set<Variables> variableSet) {
        Matcher m = this.metricRegexPattern.matcher(metric);
        if (m.lookingAt()) {
            int varCount = m.groupCount();
            String[] vars = new String[varCount];
            int i = 0;
            while (i < varCount) {
                vars[i] = m.group(i + 1);
                if (vars[i] == null) {
                    return;
                }
                ++i;
            }
            if (variableSet.add(new Variables(vars))) {
                this.invokeOperations(vars);
            }
        }
    }

    public Calculator addOperation(Operation op) {
        op.setService(this.service);
        this.operations.add(op);
        return this;
    }

    public void invokeOperations(String[] vars) {
        for (Operation op : this.operations) {
            op.invoke(vars);
        }
    }

    public int operationCount() {
        return this.operations.size();
    }
}

