/*
 * Decompiled with CFR 0.152.
 */
package com.ca.wily.introscope.agent.webappsupport.jboss;

import com.ca.wily.introscope.agent.webappsupport.AWebAppAgentNamer;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.environment.CallbackFailedPermanentlyException;
import com.wily.introscope.agent.environment.CallbackFailedTemporarilyException;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.LocalizedMessage;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JBossAgentNamer
extends AWebAppAgentNamer {
    private IAgent fAgent;
    private IModuleFeedbackChannel fFeedback;

    public JBossAgentNamer(IAgent agent) {
        super(agent);
        this.fAgent = agent;
        this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
    }

    public String IAppserverEnvironmentInfoCallback_getAgentName() throws CallbackFailedTemporarilyException, CallbackFailedPermanentlyException {
        String clusterPartitionName = null;
        String serverName = null;
        ObjectName serviceName = null;
        MBeanServer localServer = ManagementFactory.getPlatformMBeanServer();
        try {
            serviceName = new ObjectName("jboss.as:core-service=server-environment");
            Object serverAttribute = localServer.getAttribute(serviceName, "serverName");
            if (serverAttribute != null) {
                serverName = localServer.getAttribute(serviceName, "serverName").toString();
            }
            if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug("JBAN: server name = -->" + (serverName == null ? "null" : serverName) + "<--");
            }
        }
        catch (Exception e) {
            throw new CallbackFailedPermanentlyException((ILocalizableMessage)new LocalizedMessage("Problem accessing MBeans"), (Throwable)e);
        }
        if (StringUtils.isEmpty(serverName)) {
            if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug("JBAN: server name is null");
            }
            return null;
        }
        if (StringUtils.isEmpty(clusterPartitionName)) {
            if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug("JBAN: cluster partition name is null");
            }
            return serverName;
        }
        return StringUtils.concatAndEscapeStrings(clusterPartitionName, serverName, '/', '_');
    }
}

