/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.pmi;

import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.pmi.PMIDataPoller;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public final class PMIService
implements IAgentService {
    private static final String kPMIDataPollerName = "PMI Data Poller";

    public final int IAgentService_getServiceVersion() {
        return 2;
    }

    public final void IAgentService_startService(IAgent agent, Map parameters) throws Exception {
        Assertion.wilyAssert(false);
        String[] modules = this.parseModuleRequestsFromAgentConfig(agent.IAgent_getIndexedProperties(), agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        PMIDataPoller poller = new PMIDataPoller(agent, modules);
        agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)poller, kPMIDataPollerName, true, 7500L, false);
        agent.IAgent_getModuleFeedback().info(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_PMI_PMI_Activated_Message"));
    }

    String[] parseModuleRequestsFromAgentConfig(IndexedProperties config, IModuleFeedbackChannel feedback, IStringLocalizer localizer) throws Exception {
        Vector<String> requestedModules = new Vector<String>();
        Enumeration<?> enumeration = config.propertyNames();
        DataDescriptor[] ddaPMIDataDescriptors = PmiRegistry.listMembers();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith("introscope.agent.pmi.enable.") || key.length() <= "introscope.agent.pmi.enable.".length() || !config.safeGetBooleanProperty(key, false, feedback, localizer)) continue;
            String requestedModule = key.substring("introscope.agent.pmi.enable.".length());
            boolean matchFound = false;
            int iDDIterator = 0;
            while (iDDIterator < ddaPMIDataDescriptors.length) {
                String fullModuleName = ddaPMIDataDescriptors[iDDIterator].getName();
                if (fullModuleName.startsWith(requestedModule)) {
                    matchFound = true;
                    requestedModules.addElement(fullModuleName);
                    break;
                }
                ++iDDIterator;
            }
            if (matchFound) continue;
            requestedModules.addElement(requestedModule);
        }
        Object[] modulesArray = new String[requestedModules.size()];
        requestedModules.copyInto(modulesArray);
        return modulesArray;
    }
}

