/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.pbl;

import com.wily.introscope.agent.upgrade.merge.IMetadataEntry;
import com.wily.introscope.agent.upgrade.merge.Line;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PBLKey
implements IMetadataEntry {
    private String fKey;
    private boolean fCommented;
    private List<Line> fComments;

    public PBLKey(String key, boolean commented, List<Line> comments) {
        this.fKey = key;
        this.fCommented = commented;
        this.fComments = new ArrayList<Line>();
        this.addComment(comments);
    }

    @Override
    public String getKey() {
        return this.fKey;
    }

    public boolean isCommented() {
        return this.fCommented;
    }

    private void addComment(List<Line> otherCommentList) {
        for (Line aLine : otherCommentList) {
            if (aLine == null) continue;
            Line line = new Line(aLine.getContent(), aLine.getIndex());
            this.fComments.add(line);
        }
    }

    public List<Line> getComments() {
        return Collections.unmodifiableList(this.fComments);
    }

    public int hashCode() {
        int result = 17;
        int hash = this.fKey == null ? 0 : this.fKey.hashCode();
        result = 31 * result + hash;
        return result;
    }

    public boolean equals(Object obj) {
        boolean retValue = false;
        if (this == obj) {
            retValue = true;
        } else if (obj instanceof PBLKey) {
            PBLKey otherObj = (PBLKey)obj;
            if (this.fKey != null && this.fKey.equals(otherObj.fKey) && this.fCommented == otherObj.fCommented) {
                retValue = true;
            }
        }
        return retValue;
    }

    public String toString() {
        StringBuilder strBldr = new StringBuilder("Class: PBLKey");
        strBldr.append("\n\tPBLKey:   " + this.fKey);
        return strBldr.toString();
    }
}

