/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.introscope.agent.launch.core.BootstrapAgentLogger;
import com.wily.introscope.agent.launch.core.Logger;
import com.wily.introscope.agent.launch.util.BootstrapAgentConstants;
import com.wily.introscope.agent.launch.util.BootstrapAgentUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Level;

public class JavaAgentLauncher
implements BootstrapAgentConstants {
    private static final Logger LOGGER = BootstrapAgentLogger.getLogger();

    private static void prepareJvmEnv(Map<String, String> startupParams, Instrumentation instrumentation) {
        String agentJarLocation = startupParams.get("core.agent.jar.location");
        JavaAgentLauncher.updateClassloaderSerachPaths(agentJarLocation, instrumentation);
        JavaAgentLauncher.updateProfileProperty(startupParams);
    }

    public static void premain(String agentArgs, Instrumentation instrumentation, Map<String, String> startupParams) {
        JavaAgentLauncher.prepareJvmEnv(startupParams, instrumentation);
        LOGGER.finer("JavaAgentLauncher going to launch Java Agent");
        boolean success = JavaAgentLauncher.safeStartAgent("premain", agentArgs, startupParams, instrumentation);
        if (success) {
            LOGGER.info("Successfully launched Java Agent");
        } else {
            LOGGER.severe("Failed to lauch Java Agent. Please check logs for errors.");
        }
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation, Map<String, String> startupParams) {
        boolean success;
        JavaAgentLauncher.prepareJvmEnv(startupParams, instrumentation);
        LOGGER.finer("JavaAgentLauncher going to launch Java Agent");
        String agentOptionsPath = "/tmp/ca-apm-java-agent.options";
        if (agentArgs.equals(agentOptionsPath)) {
            agentArgs = null;
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(agentOptionsPath));
                String line = bufferedReader.readLine();
                bufferedReader.close();
                if (line != null) {
                    agentArgs = line;
                }
                int indexBegin = agentArgs.indexOf("com.wily.introscope.agentProfile=");
                int indexEnd = agentArgs.indexOf(44, indexBegin);
                agentArgs = String.valueOf(agentArgs.substring(0, indexBegin + 1)) + agentArgs.substring(indexEnd + 1);
            }
            catch (IOException ioe) {
                System.out.println("CA APM: Exception reading provided agentOptions. Agent Loading Terminated. Please correct agent options and redeploy UMA");
                ioe.printStackTrace();
                return;
            }
        }
        if (success = JavaAgentLauncher.safeStartAgent("agentmain", agentArgs, startupParams, instrumentation)) {
            LOGGER.info("Successfully launched Java Agent");
        } else {
            LOGGER.severe("Failed to lauch Java Agent. Please check logs for errors.");
        }
    }

    private static void updateClassloaderSerachPaths(String agentJarLocation, Instrumentation instrumentation) {
        LOGGER.finer("JavaAgentLauncher updating classloader search paths with: " + agentJarLocation);
        String url = "file:/" + agentJarLocation;
        url = url.replace('\\', '/');
        try {
            JarFile jarFile = new JarFile(new File(agentJarLocation));
            BootstrapAgentUtil.appendToBootstrapClassLoaderSearch(instrumentation, jarFile);
            if (Boolean.parseBoolean(System.getProperty("com.wily.agent.appendToSystemClassLoaderSearch", "false"))) {
                LOGGER.finer("Appending agent to system classloader search paths");
                BootstrapAgentUtil.appendToSystemClassLoaderSearch(instrumentation, jarFile);
            }
        }
        catch (ThreadDeath td) {
            LOGGER.log(Level.SEVERE, "ThreadDeath Exception occurred while launching Java Agent", td);
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOGGER.log(Level.SEVERE, "Exception occurred while launching Java Agent", t);
        }
    }

    private static void updateProfileProperty(Map<String, String> parameters) {
        String profileAbsoluteLocation = parameters.get("absolute.profile.location");
        LOGGER.info("Using agent profile " + profileAbsoluteLocation);
        System.setProperty("com.wily.introscope.agentProfile", profileAbsoluteLocation);
    }

    private static boolean safeStartAgent(String method, String args, Map parameters, Instrumentation instrumentation) {
        try {
            Class<?> agentLaunchClass = Class.forName("com.wily.introscope.api.instrument.JavaAgent");
            Method m = agentLaunchClass.getMethod(method, String.class, Instrumentation.class);
            m.invoke(null, args, instrumentation);
            return true;
        }
        catch (ThreadDeath td) {
            LOGGER.log(Level.SEVERE, "ThreadDeath Exception occurred while launching Java Agent", td);
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOGGER.log(Level.SEVERE, "Exception occurred while launching Java Agent", t);
            return false;
        }
    }
}

