/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JSplitPane;

public class ExtendedJSplitPane
extends JSplitPane {
    private static final long serialVersionUID = -348654540456994366L;
    private double fRelativeSize = -1.0;
    private RelativeSizeSplitPaneAdapter fRelativeSizeAdapter = new RelativeSizeSplitPaneAdapter();
    private Dimension fCachedSizeForRebalance = null;
    private AutoRebalanceSplitPaneAdapter fRebalanceAdapter = new AutoRebalanceSplitPaneAdapter();

    public ExtendedJSplitPane(int newOrientation) {
        this(newOrientation, false);
    }

    public ExtendedJSplitPane(int newOrientation, boolean newContinuousLayout) {
        this(newOrientation, false, null, null);
    }

    public ExtendedJSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        this(newOrientation, false, newLeftComponent, newRightComponent);
    }

    public ExtendedJSplitPane(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newContinuousLayout, newLeftComponent, newRightComponent);
        this.addComponentListener(this.fRebalanceAdapter);
    }

    public void setRelativeSize(double relativeSize) {
        if (relativeSize < 0.0 || relativeSize > 1.0) {
            throw new IllegalArgumentException("relative size must be between 0.0 and 1.0");
        }
        if (!this.hasRelativeSize()) {
            this.removeComponentListener(this.fRebalanceAdapter);
            this.addComponentListener(this.fRelativeSizeAdapter);
        }
        this.fRelativeSize = relativeSize;
        this.forceRelativeSize();
    }

    public void clearRelativeSize() {
        if (this.hasRelativeSize()) {
            this.removeComponentListener(this.fRelativeSizeAdapter);
            this.addComponentListener(this.fRebalanceAdapter);
        }
        this.fRelativeSize = -1.0;
    }

    public boolean hasRelativeSize() {
        return this.fRelativeSize >= 0.0;
    }

    public double getRelativeSize() {
        return this.fRelativeSize;
    }

    private void forceRelativeSize() {
        Dimension size = this.getSize();
        int dividerLocation = this.getOrientation() == 1 ? (int)(this.getRelativeSize() * size.getWidth()) : (int)(this.getRelativeSize() * size.getHeight());
        if (this.getDividerLocation() != dividerLocation) {
            this.setDividerLocation(dividerLocation);
        }
    }

    private void rebalance() {
        Dimension oldSize = this.fCachedSizeForRebalance;
        Dimension newSize = this.getSize();
        if (this.isRealResize(newSize)) {
            int newDividerLocation;
            this.fCachedSizeForRebalance = newSize;
            if (this.isShowing() && oldSize != null && newSize != null && this.sizeDifferenceIsRelevant(oldSize, newSize) && this.newDividerLocationIsLegal(newDividerLocation = this.computeNewDividerLocation(oldSize, newSize))) {
                this.setDividerLocation(newDividerLocation);
            }
        }
    }

    private boolean isRealResize(Dimension newSize) {
        Dimension minSize = this.getMinimumSize();
        return newSize.width >= minSize.width && newSize.height >= minSize.height;
    }

    private int computeNewDividerLocation(Dimension oldSize, Dimension newSize) {
        int oldDiv;
        int width_delta = Math.abs(oldSize.width - newSize.width);
        int height_delta = Math.abs(oldSize.height - newSize.height);
        int newDiv = oldDiv = this.getDividerLocation();
        if (this.getOrientation() == 1) {
            double oldPos = (double)oldDiv / oldSize.getWidth();
            newDiv = (int)(oldPos * (double)newSize.width);
        } else {
            double oldPos = (double)oldDiv / oldSize.getHeight();
            newDiv = (int)(oldPos * (double)newSize.height);
        }
        return newDiv;
    }

    private boolean sizeDifferenceIsRelevant(Dimension oldSize, Dimension newSize) {
        boolean result = true;
        result = this.getOrientation() == 1 ? oldSize.getWidth() != newSize.getWidth() : oldSize.getHeight() != newSize.getHeight();
        return result;
    }

    private boolean newDividerLocationIsLegal(int newDividerLocation) {
        boolean isLegal = true;
        int orientation = this.getOrientation();
        if (orientation == 1) {
            if (this.getLeftComponent().getMinimumSize().width > newDividerLocation) {
                isLegal = false;
            }
        } else {
            Component top = this.getTopComponent();
            if (top.getMinimumSize().height > newDividerLocation) {
                isLegal = false;
            }
        }
        return isLegal;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.hasRelativeSize()) {
            this.forceRelativeSize();
        }
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        if (this.hasRelativeSize()) {
            this.forceRelativeSize();
        }
    }

    private class AutoRebalanceSplitPaneAdapter
    extends ComponentAdapter {
        private AutoRebalanceSplitPaneAdapter() {
        }

        public void componentResized(ComponentEvent e) {
            try {
                ExtendedJSplitPane splitPane = (ExtendedJSplitPane)e.getComponent();
                if (splitPane != null) {
                    splitPane.rebalance();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class RelativeSizeSplitPaneAdapter
    extends ComponentAdapter {
        private RelativeSizeSplitPaneAdapter() {
        }

        public void componentResized(ComponentEvent e) {
            try {
                ExtendedJSplitPane splitPane = (ExtendedJSplitPane)e.getComponent();
                if (splitPane != null) {
                    splitPane.forceRelativeSize();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

