/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.extension.DelegatingClassLoader;
import com.wily.util.extension.IExtension;
import com.wily.util.extension.IExtensionBroker;
import com.wily.util.extension.IExtensionLocator;
import com.wily.util.extension.IExtensionProxy;
import com.wily.util.extension.IPlugin;
import com.wily.util.extension.InvalidExtensionException;
import com.wily.util.extension.KExtensionConstants;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.topologicalsort.CycleExistsException;
import com.wily.util.topologicalsort.TopologicalSorter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExtensionBroker
implements IExtensionBroker {
    private List fExtensionList = null;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final IExtensionLocator[] fLocatorArray;

    public ExtensionBroker(IExtensionLocator locator, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this(new IExtensionLocator[]{locator}, feedback, localizer);
    }

    public ExtensionBroker(IExtensionLocator[] locatorArray, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fLocatorArray = locatorArray;
    }

    public void loadExtensions() {
        this.loadExtensions(null);
    }

    public void loadExtensions(String[] extensionTypeMask) {
        List<String> types = null;
        if (extensionTypeMask != null) {
            types = Arrays.asList(extensionTypeMask);
        }
        this.fExtensionList = this.locateAndLoadExtensions(this.fLocatorArray, types);
    }

    public IExtension[] IExtensionBroker_getFilteredExtensionList(String extensionTypeFilter) {
        Iterator allExtensions = this.getExtensionsList().iterator();
        ArrayList<IExtension> bag = new ArrayList<IExtension>();
        while (allExtensions.hasNext()) {
            IExtension currentExtension = (IExtension)allExtensions.next();
            if (!currentExtension.IExtension_getType().equals(extensionTypeFilter)) continue;
            bag.add(currentExtension);
        }
        return bag.toArray(KExtensionConstants.kZeroLengthExtensionArray);
    }

    public IPlugin[] IExtensionBroker_getFilteredPluginList(String extensionTypeFilter, String pluginTypeFilter) {
        ArrayList<IPlugin> pluginBag = new ArrayList<IPlugin>();
        List<IExtension> extensionList = Arrays.asList(this.IExtensionBroker_getFilteredExtensionList(extensionTypeFilter));
        Iterator<IExtension> filteredExtensions = extensionList.iterator();
        while (filteredExtensions.hasNext()) {
            IExtension currentExtension = filteredExtensions.next();
            List<IPlugin> pluginsList = Arrays.asList(currentExtension.IExtension_getFilteredPluginList(pluginTypeFilter));
            Iterator<IPlugin> plugins = pluginsList.iterator();
            while (plugins.hasNext()) {
                IPlugin currentPlugin = plugins.next();
                if (!currentPlugin.IPlugin_getType().equals(pluginTypeFilter)) continue;
                pluginBag.add(currentPlugin);
            }
        }
        return pluginBag.toArray(KExtensionConstants.kZeroLengthPluginArray);
    }

    private List getExtensionsList() {
        if (this.fExtensionList == null) {
            this.loadExtensions();
        }
        return this.fExtensionList;
    }

    private List locateAndLoadExtensions(IExtensionLocator[] locatorArray, Collection typeFilter) {
        HashMap<String, IExtensionProxy> extensionProxies = new HashMap<String, IExtensionProxy>();
        int z = 3;
        for (int x = 0; x < locatorArray.length; ++x) {
            IExtensionProxy[] locatedExtensionProxies = locatorArray[x].IExtensionLocator_locateExtensionProxies();
            for (int i = 0; i < locatedExtensionProxies.length; ++i) {
                IExtensionProxy extensionProxy = locatedExtensionProxies[i];
                if (typeFilter != null && !typeFilter.contains(extensionProxy.IExtensionProxy_getType())) {
                    this.fFeedback.verbose("Ignoring extension " + extensionProxy.IExtensionProxy_getName() + " of type " + extensionProxy.IExtensionProxy_getType() + ".");
                    continue;
                }
                if (extensionProxies.containsKey(extensionProxy.IExtensionProxy_getName())) {
                    this.fFeedback.warn(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Extension_Duplicate_Message", new String[]{extensionProxy.IExtensionProxy_getName()}));
                    continue;
                }
                this.fFeedback.debug("adding extension proxy " + extensionProxy.IExtensionProxy_getName());
                extensionProxies.put(extensionProxy.IExtensionProxy_getName(), extensionProxy);
            }
        }
        return this.loadExtensionsFromProxies(extensionProxies);
    }

    private List loadExtensionsFromProxies(Map extensionProxies) {
        ArrayList extensionProxyList = new ArrayList(extensionProxies.values());
        try {
            TopologicalSorter.sort(extensionProxyList);
        }
        catch (CycleExistsException e) {
            this.fFeedback.error("Cycle exists in proxy list", e);
        }
        HashMap<String, IExtension> loadedExtensions = new HashMap<String, IExtension>();
        for (int i = 0; i < extensionProxyList.size(); ++i) {
            IExtensionProxy extensionProxy = (IExtensionProxy)extensionProxyList.get(i);
            String extensionProxyName = extensionProxy.IExtensionProxy_getName();
            String[] dependencies = extensionProxy.IExtensionProxy_getDependencies();
            IExtension extension = null;
            this.fFeedback.debug("Extension Name ### ->" + extensionProxyName);
            this.fFeedback.debug("Dependency ->" + dependencies);
            this.fFeedback.debug("Loaded Extensions ########### ->" + loadedExtensions);
            if (dependencies == null || dependencies.length == 0) {
                extension = this.loadExtension(extensionProxy, this.getClass().getClassLoader());
            } else {
                ClassLoader[] parentClassLoaders = new ClassLoader[dependencies.length];
                for (int j = 0; j < dependencies.length; ++j) {
                    IExtension aParentExtension = (IExtension)loadedExtensions.get(dependencies[j]);
                    if (aParentExtension != null) {
                        parentClassLoaders[j] = aParentExtension.IExtension_getClassLoader();
                        continue;
                    }
                    this.fFeedback.error(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Extension_Invalid_Dependency_Message", new String[]{extensionProxyName, dependencies[j]}));
                }
                ClassLoader theParentLoader = null;
                theParentLoader = parentClassLoaders.length == 1 ? parentClassLoaders[0] : new DelegatingClassLoader(parentClassLoaders);
                extension = this.loadExtension(extensionProxy, theParentLoader);
            }
            if (extension == null) continue;
            loadedExtensions.put(extensionProxy.IExtensionProxy_getName(), extension);
        }
        return new ArrayList(loadedExtensions.values());
    }

    private IExtension loadExtension(IExtensionProxy extensionProxy, ClassLoader parentClassLoader) {
        try {
            IExtension extension = extensionProxy.IExtensionProxy_newInstance(this.fFeedback, parentClassLoader);
            return extension;
        }
        catch (InvalidExtensionException iee) {
            String message = iee.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.fLocalizer);
            this.fFeedback.warn(message);
        }
        catch (Throwable t) {
            this.fFeedback.error("Unexpected error loading extension ", t);
        }
        return null;
    }

    public static void finalizeClassLoaderDependencies(IModuleFeedbackChannel feedback, IExtension[] extensions, ClassLoader parentLoader) {
        HashMap<String, ClassLoader> loaderMap = new HashMap<String, ClassLoader>();
        try {
            TopologicalSorter.sort(extensions);
        }
        catch (CycleExistsException e) {
            feedback.error("Extensions contain circular dependency", e);
        }
        for (int i = 0; i < extensions.length; ++i) {
            ClassLoader parent;
            String[] dependencies = extensions[i].IExtension_getDependencies();
            if (dependencies == null || dependencies.length == 0) {
                parent = parentLoader;
            } else {
                ClassLoader[] parentLoaders = new ClassLoader[dependencies.length];
                for (int j = 0; j < dependencies.length; ++j) {
                    parentLoaders[j] = (ClassLoader)loaderMap.get(dependencies[j]);
                    if (parentLoaders[j] != null) continue;
                    feedback.error("Extension Depending Error. Extension: " + extensions[i].IExtension_getName() + " depends on extension " + dependencies[j] + " which wasn't found");
                }
                parent = parentLoaders.length == 1 ? parentLoaders[0] : new DelegatingClassLoader(parentLoaders);
            }
            try {
                extensions[i].IExtension_setParentClassLoader(parent);
            }
            catch (InvalidExtensionException e) {
                feedback.error("Invalid extension", e);
            }
            loaderMap.put(extensions[i].IExtension_getName(), extensions[i].IExtension_getClassLoader());
        }
    }
}

