/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.jdbc;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.jdbc.DBNameFormatterLoader;
import com.wily.introscope.agent.trace.jdbc.IDBNameFormatter;
import com.wily.introscope.agent.trace.jdbc.IGenericDBNameFormatter;
import com.wily.introscope.agent.trace.jdbc.IOracleDBNameFormatter;
import com.wily.introscope.agent.trace.jdbc.ISybaseDBNameFormatter;
import com.wily.introscope.agent.trace.jdbc.SybasePoolFormatter;
import com.wily.introscope.agent.trace.jdbc.SybaseProxyFormatter;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.adt.WeakIdentityHashMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.PooledConnection;

public class SQLNameFormatterUtilities {
    private static final Module kModule;
    private static final String kCacheConnectionsURLs = "introscope.agent.sqlagent.cacheConnectionsURLs";
    private static final String ignoreUnknownUrlTypePropertyName = "introscope.agent.sqlagent.ignoreUnknownUrlType";
    private static volatile boolean ignoreUnknownUrlType;
    public static final String IGNORE_UNKNOWNURL = "ignoreUnknownUrlType";
    protected static final Map fDispatchTable;
    private static final String kDBNameEquals = "databasename=";
    private static final String kLocEquals = "location=";
    private static final String kServerNameEquals = "&server=";
    private static final String kRealApplicationCluster = "Real Application Cluster";
    private static final IAgent kAgent;
    private static final Set sKnownDBTypes;
    private static Field fOracleRacConnection;
    private static Field fWLConnection;
    private static Method getUnderlyingConnectionMethod;
    private static final String kWrappedConnectionJDK6ClassName = "org.jboss.resource.adapter.jdbc.jdk6.WrappedConnectionJDK6";
    private static final String kLogicalConnectionClassName = "oracle.jdbc.driver.LogicalConnection";
    private static final String kWrappedConnectionClassName = "org.jboss.resource.adapter.jdbc.WrappedConnection";
    private static final String kGetUnderlyingConnectionMethodName = "getUnderlyingConnection";
    private static final int sConsecutiveErrorThreshold = 10;
    private static final ThreadLocal sConsecutiveFailuresThreadLocal;
    private static Field fAuth;
    private static Field fSessionProps;
    private static final int kMaxSize = 100;
    private static final Map sUrlCache;
    private static final IWeakIdentityMap sUrlCacheMap;
    private static final WeakIdentityHashMap sNameCache;
    private static final ThreadLocal sNameCacheThreadLocal;
    private static final IWeakIdentityMap datasourceConnectionMap;
    private static final SQLNameFormatterUtilities sInstance;
    private static volatile boolean fCacheConnectionsUrls;
    private static final String JDBC_DRIVER_NAME_PREFIX_WEBLOGIC_SQLSERVER_10_3_3 = "jdbc:weblogic:sqlserver";
    private static final Pattern sHostPattern;

    static {
        IConcurrentMapFactory factory;
        kModule = new Module("SQLNameFormatterUtilities");
        ignoreUnknownUrlType = false;
        fDispatchTable = new HashMap(23);
        fOracleRacConnection = null;
        fWLConnection = null;
        getUnderlyingConnectionMethod = null;
        sInstance = new SQLNameFormatterUtilities();
        fCacheConnectionsUrls = false;
        sKnownDBTypes = new HashSet(24);
        sKnownDBTypes.add("jdbc:oracle");
        sKnownDBTypes.add("jdbc:db2");
        sKnownDBTypes.add("jdbc:as400");
        sKnownDBTypes.add("jdbc:bea:db2");
        sKnownDBTypes.add("jdbc:datadirect:db2");
        sKnownDBTypes.add("sqlserver");
        sKnownDBTypes.add("jdbc:microsoft:sqlserver");
        sKnownDBTypes.add("jdbc:datadirect:sqlserver");
        sKnownDBTypes.add("jdbc:nwmss:sqlserver");
        sKnownDBTypes.add("jdbc:ibm:sqlserver");
        sKnownDBTypes.add("jdbc:bea:sqlserver");
        sKnownDBTypes.add(JDBC_DRIVER_NAME_PREFIX_WEBLOGIC_SQLSERVER_10_3_3);
        sKnownDBTypes.add("jdbc:sqlserver");
        sKnownDBTypes.add("jdbc:bea:oracle");
        sKnownDBTypes.add("jdbc:introscope:net");
        sKnownDBTypes.add("jdbc:sapdb");
        sKnownDBTypes.add("jdbc:informix-sqli");
        sKnownDBTypes.add("jdbc:pointbase");
        sKnownDBTypes.add("jdbc:derby");
        sKnownDBTypes.add("jdbc:sybase:tds");
        sKnownDBTypes.add("jdbc:neon");
        sKnownDBTypes.add("jdbc:clarity:oracle");
        sKnownDBTypes.add("jdbc:clarity:sqlserver");
        sKnownDBTypes.add("jdbc:tibcosoftwareinc");
        sKnownDBTypes.add("jdbc:wm");
        sKnownDBTypes.add("jdbc:mysql");
        sKnownDBTypes.add("jdbc:hsqldb");
        sKnownDBTypes.add("jdbc:mongodb");
        sKnownDBTypes.add("jdbc:postgresql");
        sKnownDBTypes.add("com.sybase.jdbc4.jdbc.sybpooledconnection");
        sKnownDBTypes.add("com.sybase.jdbc4.jdbc.sybconnectionproxy");
        sNameCache = new WeakIdentityHashMap();
        sNameCacheThreadLocal = new ThreadLocal(){

            protected Object initialValue() {
                return new WeakIdentityHashMap();
            }
        };
        sConsecutiveFailuresThreadLocal = new ThreadLocal(){

            protected Object initialValue() {
                return new WeakHashMap();
            }
        };
        IAgent workingAgent = null;
        try {
            workingAgent = AgentShim.getAgent();
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
        kAgent = workingAgent;
        Map workingUrlCache = null;
        IWeakIdentityMap workingUrlConnectionCache = null;
        if (kAgent != null && (factory = kAgent.IAgent_getConcurrentMapFactory()) != null) {
            workingUrlCache = factory.getConcurrentCappedMap("urlToFormatString");
            workingUrlConnectionCache = factory.getConcurrentCappedWeakIdentityMap("connectionToURL");
        }
        sUrlCache = workingUrlCache;
        sUrlCacheMap = workingUrlConnectionCache;
        if (kAgent != null) {
            kAgent.IAgent_getConfigurationManager().add((ConfigurationProperty)new CacheConnectionsURLsProperty(kAgent), true);
            kAgent.IAgent_getConfigurationManager().add((ConfigurationProperty)new IgnoreUnknownUrlTypeProperty(kAgent), true);
        }
        datasourceConnectionMap = kAgent.IAgent_getConcurrentMapFactory().getConcurrentWeakIdentityMap("DataSourceConnectionCache");
        SQLNameFormatterUtilities.loadGenericDatabasePlugins();
        sHostPattern = Pattern.compile("[(\\s]host");
    }

    private SQLNameFormatterUtilities() {
        fDispatchTable.put("jdbc:oracle", new OracleFormatter());
        fDispatchTable.put("jdbc:db2", new DB2Formatter());
        fDispatchTable.put("jdbc:as400", new DB2Formatter());
        fDispatchTable.put("jdbc:bea:db2", new DB2Formatter());
        fDispatchTable.put("jdbc:datadirect:db2", new DB2Formatter());
        fDispatchTable.put("sqlserver", new SQLServerFormatter());
        fDispatchTable.put("jdbc:microsoft:sqlserver", new SQLServerFormatter());
        fDispatchTable.put("jdbc:datadirect:sqlserver", new SQLServerFormatter());
        fDispatchTable.put("jdbc:nwmss:sqlserver", new SQLServerFormatter());
        fDispatchTable.put("jdbc:sqlserver", new SQLServerFormatter());
        fDispatchTable.put("jdbc:bea:oracle", new BEAOracleFormatter());
        fDispatchTable.put("jdbc:introscope:net", new IntroscopeDataSourceFormatter());
        fDispatchTable.put("jdbc:sapdb", new SAPMaxDBFormatter());
        fDispatchTable.put("jdbc:ibm:sqlserver", new SQLServerFormatter());
        fDispatchTable.put("jdbc:bea:sqlserver", new SQLServerFormatter());
        fDispatchTable.put(JDBC_DRIVER_NAME_PREFIX_WEBLOGIC_SQLSERVER_10_3_3, new SQLServerFormatter());
        fDispatchTable.put("jdbc:informix-sqli", new InformixSQLiFormatter());
        fDispatchTable.put("jdbc:pointbase", new JDBCPointbaseFormatter());
        fDispatchTable.put("jdbc:derby", new DerbyFormatter());
        fDispatchTable.put("jdbc:sybase:tds", new SybaseFormatter());
        fDispatchTable.put("jdbc:neon", new NeonDB2Formatter());
        fDispatchTable.put("jdbc:clarity:oracle", new ClarityOracleFormatter());
        fDispatchTable.put("jdbc:clarity:sqlserver", new SQLServerFormatter());
        fDispatchTable.put("jdbc:tibcosoftwareinc", new TibcoAndWebmethodsFormatter(true));
        fDispatchTable.put("jdbc:wm", new TibcoAndWebmethodsFormatter(false));
        fDispatchTable.put("jdbc:mysql", new MySQLFormatter());
        fDispatchTable.put("jdbc:hsqldb", new HypersonicFormatter());
        fDispatchTable.put("jdbc:mongodb", new MongoDBFormatter());
        fDispatchTable.put("jdbc:postgresql", new PostgresSQLFormatter());
        fDispatchTable.put("com.sybase.jdbc4.jdbc.sybpooledconnection", new SybasePoolFormatter());
        fDispatchTable.put("com.sybase.jdbc4.jdbc.sybconnectionproxy", new SybaseProxyFormatter());
    }

    public static final SQLNameFormatterUtilities getInstance() {
        return sInstance;
    }

    public String getFormattedString(Statement stmt, IModuleFeedbackChannel feedback, IStringLocalizer localizer) throws SQLException {
        Connection c = stmt.getConnection();
        return this.getFormattedString(c, SQLNameFormatterUtilities.getSafeCachedURL(feedback, c), feedback, localizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormattedString(Connection conn, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        DatabaseMetaData md;
        String formattedName = null;
        formattedName = (String)this.getThreadLocalNameCache().get((Object)conn);
        if (formattedName == null) {
            WeakIdentityHashMap weakIdentityHashMap = sNameCache;
            synchronized (weakIdentityHashMap) {
                formattedName = (String)sNameCache.get((Object)conn);
                if (formattedName != null) {
                    this.getThreadLocalNameCache().put((Object)conn, (Object)formattedName);
                }
            }
        }
        if (formattedName == null && (md = this.getMetaData(conn, feedback)) != null) {
            String url = this.getURL(conn, md, feedback);
            if (url != null) {
                String lcURL = url.toLowerCase();
                formattedName = this.formatNameFromURL(lcURL, conn, localizer);
                if (formattedName != null) {
                    WeakIdentityHashMap weakIdentityHashMap = sNameCache;
                    synchronized (weakIdentityHashMap) {
                        sNameCache.put((Object)conn, (Object)formattedName);
                    }
                    this.getThreadLocalNameCache().put((Object)conn, (Object)formattedName);
                } else {
                    formattedName = this.getDriverName(md, feedback);
                    if (formattedName == null) {
                        formattedName = lcURL;
                    }
                }
            } else {
                formattedName = this.getDriverName(md, feedback);
            }
        }
        if (formattedName != null) {
            formattedName = formattedName.replace(':', '%');
        }
        return formattedName;
    }

    public String getFormattedString(Connection conn, String url, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        String formattedName;
        boolean hasBeenComputed = false;
        String string = formattedName = sUrlCache == null ? null : (String)sUrlCache.get(url);
        if (formattedName == null) {
            formattedName = this.formatNameFromURL(url, conn, localizer);
            hasBeenComputed = true;
            if (formattedName != null) {
                formattedName = formattedName.replace(':', '%');
            } else {
                formattedName = this.getDriverName(this.getMetaData(conn, feedback), feedback);
                if (formattedName == null) {
                    formattedName = url;
                }
            }
            if (sUrlCache != null) {
                sUrlCache.put(url, formattedName);
            }
        }
        if (formattedName != null && hasBeenComputed) {
            formattedName = formattedName.replace(':', '%');
        }
        return formattedName;
    }

    public String computeFormattedString(Connection conn, String url, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        String formattedName = this.formatNameFromURL(url, conn, localizer);
        if (formattedName != null) {
            formattedName = formattedName.replace(':', '%');
        } else {
            formattedName = this.getDriverName(this.getMetaData(conn, feedback), feedback);
            if (formattedName == null) {
                formattedName = url;
            }
        }
        return formattedName;
    }

    private WeakIdentityHashMap getThreadLocalNameCache() {
        return (WeakIdentityHashMap)sNameCacheThreadLocal.get();
    }

    private String getDriverName(DatabaseMetaData md, IModuleFeedbackChannel feedback) {
        String result = null;
        if (md != null) {
            Map consecutiveErrorMap = (Map)sConsecutiveFailuresThreadLocal.get();
            int[] consecutiveErrors = (int[])consecutiveErrorMap.get(md.getClass());
            if (consecutiveErrors == null) {
                consecutiveErrors = new int[1];
                consecutiveErrorMap.put(md.getClass(), consecutiveErrors);
            }
            if (consecutiveErrors[0] < 10) {
                try {
                    result = md.getDriverName();
                    consecutiveErrors[0] = 0;
                }
                catch (SQLException sQLException) {
                    consecutiveErrors[0] = consecutiveErrors[0] + 1;
                    if (consecutiveErrors[0] >= 10) {
                        this.giveMetadataErrorThrottlingWarning(md, feedback);
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        consecutiveErrors[0] = consecutiveErrors[0] + 1;
                        if (consecutiveErrors[0] >= 10) {
                            this.giveMetadataErrorThrottlingWarning(md, feedback);
                        }
                        feedback.debug("A non-fatal exception was thrown while retrieving database driver name: " + t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return result;
    }

    public DatabaseMetaData getMetaData(Connection connection, IModuleFeedbackChannel feedback) {
        DatabaseMetaData result = null;
        if (connection != null) {
            Map consecutiveErrorMap = (Map)sConsecutiveFailuresThreadLocal.get();
            int[] consecutiveErrors = (int[])consecutiveErrorMap.get(connection.getClass());
            if (consecutiveErrors == null) {
                consecutiveErrors = new int[1];
                consecutiveErrorMap.put(connection.getClass(), consecutiveErrors);
            }
            if (consecutiveErrors[0] < 10) {
                try {
                    result = connection.getMetaData();
                    consecutiveErrors[0] = 0;
                }
                catch (SQLException sQLException) {
                    consecutiveErrors[0] = consecutiveErrors[0] + 1;
                    if (consecutiveErrors[0] >= 10) {
                        this.giveErrorThrottlingWarning(connection, feedback);
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        consecutiveErrors[0] = consecutiveErrors[0] + 1;
                        if (consecutiveErrors[0] >= 10) {
                            this.giveErrorThrottlingWarning(connection, feedback);
                        }
                        feedback.debug("A non-fatal exception was thrown while retrieving database metadata: " + t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return result;
    }

    public String getURL(Connection connection, DatabaseMetaData md, IModuleFeedbackChannel feedback) {
        String result = null;
        if (connection != null) {
            result = SQLNameFormatterUtilities.getConnectionClassName(connection);
            Map consecutiveErrorMap = (Map)sConsecutiveFailuresThreadLocal.get();
            int[] consecutiveErrors = (int[])consecutiveErrorMap.get(connection.getClass());
            if (consecutiveErrors == null) {
                consecutiveErrors = new int[1];
                consecutiveErrorMap.put(connection.getClass(), consecutiveErrors);
            }
            if (consecutiveErrors[0] < 10) {
                try {
                    String url = md.getURL();
                    if (url != null) {
                        result = url;
                    }
                    consecutiveErrors[0] = 0;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    consecutiveErrors[0] = consecutiveErrors[0] + 1;
                    if (consecutiveErrors[0] >= 10) {
                        this.giveErrorThrottlingWarning(connection, feedback);
                    }
                }
                catch (SQLException sQLException) {
                    consecutiveErrors[0] = consecutiveErrors[0] + 1;
                    if (consecutiveErrors[0] >= 10) {
                        this.giveErrorThrottlingWarning(connection, feedback);
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        consecutiveErrors[0] = consecutiveErrors[0] + 1;
                        if (consecutiveErrors[0] >= 10) {
                            this.giveErrorThrottlingWarning(connection, feedback);
                        }
                        feedback.debug("A non-fatal exception was thrown while retrieving a JDBC URL: ", t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return result;
    }

    private void giveErrorThrottlingWarning(Connection connectionObj, IModuleFeedbackChannel feedback) {
        feedback.warn("Too many consecutive exceptions thrown for Connection class " + connectionObj.getClass().getName() + ", giving up trying to get JDBC URL for that class");
    }

    private void giveMetadataErrorThrottlingWarning(DatabaseMetaData md, IModuleFeedbackChannel feedback) {
        feedback.warn("Too many consecutive exceptions thrown for DatabaseMetaData class " + md.getClass().getName() + ", giving up trying to get driver name for that class");
    }

    String formatNameFromURL(String url, Connection conn, IStringLocalizer localizer) {
        URLParseInfo inf;
        String realFormat = url;
        if (url != null && (inf = this.parseVendor(url)) != null) {
            String source = url.substring(inf.infoPastVendorStart);
            if (inf.vendor.equalsIgnoreCase("jdbc:oracle")) {
                IOracleDBNameFormatter oracleformatter = (IOracleDBNameFormatter)fDispatchTable.get(inf.vendor);
                realFormat = oracleformatter.format(source, conn, localizer);
            } else if (inf.vendor.equalsIgnoreCase("com.sybase.jdbc4.jdbc.SybPooledConnection") || inf.vendor.equalsIgnoreCase("com.sybase.jdbc4.jdbc.SybConnectionProxy")) {
                if (datasourceConnectionMap.containsWeakKey((Object)conn)) {
                    realFormat = (String)datasourceConnectionMap.getWeak((Object)conn);
                } else {
                    ISybaseDBNameFormatter sybaseformatter = (ISybaseDBNameFormatter)fDispatchTable.get(inf.vendor);
                    realFormat = sybaseformatter.format(source, conn, localizer, kAgent.IAgent_getModuleFeedback());
                    if (realFormat != null) {
                        datasourceConnectionMap.putWeak((Object)conn, (Object)realFormat);
                    }
                }
            } else {
                IDBNameFormatter formatter = (IDBNameFormatter)fDispatchTable.get(inf.vendor);
                realFormat = formatter.format(source, localizer);
            }
        }
        return realFormat;
    }

    protected URLParseInfo parseVendor(String url) {
        URLParseInfo result = null;
        for (String prefix : sKnownDBTypes) {
            if (!url.startsWith(prefix)) continue;
            int leftOverIndex = url.length() == prefix.length() ? 0 : prefix.length() + 1;
            result = new URLParseInfo(prefix, leftOverIndex);
            break;
        }
        return result;
    }

    private String parseParameter(int startIndex, int endIndex, String query, String parameter) {
        if (endIndex < 0) {
            endIndex = query.length() - 1;
        }
        int beginIndex = query.indexOf(parameter, startIndex);
        int subStringBeginIndex = query.substring(startIndex, endIndex).indexOf(parameter);
        beginIndex = subStringBeginIndex >= 0 ? startIndex + subStringBeginIndex : -1;
        int equalIndex = query.indexOf(61, beginIndex);
        if (equalIndex > 0 && beginIndex >= 0) {
            int finishIndex = query.indexOf(41, equalIndex);
            return query.substring(equalIndex + 1, finishIndex);
        }
        return "";
    }

    private static String getConnectedRACHost(Connection conn) {
        try {
            Class<?> connClass = conn.getClass();
            if (connClass.getName().equals("oracle.jdbc.driver.T4CConnection")) {
                return SQLNameFormatterUtilities.getRACHostFromPhyConn(conn);
            }
            if (connClass.getName().equals("org.apache.commons.dbcp.cpdsadapter.ConnectionImpl")) {
                if (fOracleRacConnection == null) {
                    SQLNameFormatterUtilities.setConnectionFieldfromApacheConnPool(connClass, conn);
                }
                if (fOracleRacConnection != null) {
                    Connection contn = (Connection)fOracleRacConnection.get(conn);
                    return SQLNameFormatterUtilities.getRACHostFromPhyConn(contn);
                }
            } else {
                if (connClass.getName().equals(kLogicalConnectionClassName)) {
                    return SQLNameFormatterUtilities.getRACHostFromLogicalConn(conn);
                }
                if (conn instanceof PooledConnection) {
                    Connection actualConn = ((PooledConnection)((Object)conn)).getConnection();
                    return SQLNameFormatterUtilities.getRACHostFromPhyConn(actualConn);
                }
                if (connClass.getName().equals(kWrappedConnectionJDK6ClassName)) {
                    return SQLNameFormatterUtilities.getRACHostFromWrappedConnection(conn);
                }
                if (kAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                    kAgent.IAgent_getModuleFeedback().debug("Unable to handle Connection class by name : " + conn.getClass().getName());
                }
            }
        }
        catch (Exception exception) {
            kAgent.IAgent_getModuleFeedback().debug("Unable to get Oracle RAC DB hostname");
        }
        return null;
    }

    private static String getRACHostFromLogicalConn(Object conn) {
        try {
            if (fWLConnection == null) {
                SQLNameFormatterUtilities.setConnectionFieldfromWLConnPool(conn.getClass());
            }
            if (fWLConnection != null) {
                Connection contn = (Connection)fWLConnection.get(conn);
                return SQLNameFormatterUtilities.getRACHostFromPhyConn(contn);
            }
        }
        catch (Exception exception) {
            kAgent.IAgent_getModuleFeedback().debug("Unable to get Oracle RAC DB hostname");
        }
        return null;
    }

    private static String getRACHostFromWrappedConnection(Object conn) {
        try {
            Object contn;
            if (getUnderlyingConnectionMethod == null) {
                SQLNameFormatterUtilities.setUnderLyingConnfromWrappedConn(conn.getClass());
            }
            if (getUnderlyingConnectionMethod != null && (contn = getUnderlyingConnectionMethod.invoke(conn, null)) != null && contn.getClass().getName().equals(kLogicalConnectionClassName)) {
                return SQLNameFormatterUtilities.getRACHostFromLogicalConn(contn);
            }
        }
        catch (Exception exception) {
            kAgent.IAgent_getModuleFeedback().debug("Unable to get Oracle RAC DB hostname");
        }
        return null;
    }

    private static String getRACHostFromPhyConn(Connection conn) {
        String connHostName = null;
        Properties connectionProperties = null;
        Exception racHostNameFromSessionException = null;
        Exception racHostNameFromAuthException = null;
        try {
            connectionProperties = SQLNameFormatterUtilities.getConnPropsfromAuth(conn);
            if (connectionProperties != null && (connHostName = SQLNameFormatterUtilities.getHostName(connectionProperties)) != null && !"".equals(connHostName.trim())) {
                return connHostName;
            }
        }
        catch (Exception e) {
            racHostNameFromAuthException = e;
        }
        try {
            connectionProperties = SQLNameFormatterUtilities.getConnPropsfromSession(conn);
            if (connectionProperties != null && (connHostName = SQLNameFormatterUtilities.getHostName(connectionProperties)) != null && !"".equals(connHostName.trim())) {
                return connHostName;
            }
        }
        catch (Exception e) {
            racHostNameFromSessionException = e;
        }
        if (kAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
            kAgent.IAgent_getModuleFeedback().debug("Unable to retrieve HOSTNAME of connected RAC Instance : " + connHostName);
            if (racHostNameFromAuthException != null) {
                kAgent.IAgent_getModuleFeedback().error("Unable to retrieve HOSTNAME from T4CConnection AUTH: ", (Throwable)racHostNameFromAuthException);
            }
            if (racHostNameFromSessionException != null) {
                kAgent.IAgent_getModuleFeedback().error("Unable to retrieve HOSTNAME from PhysicalConnection sessionProperties: ", (Throwable)racHostNameFromSessionException);
            }
        }
        return connHostName;
    }

    private static Properties getConnPropsfromSession(Connection conn) throws Exception {
        Properties connProperties = null;
        Field sessionProps = fSessionProps;
        if (fSessionProps == null) {
            sessionProps = SQLNameFormatterUtilities.getFieldFromPhysicalConnection("sessionProperties", conn);
            sessionProps.setAccessible(true);
        }
        try {
            connProperties = (Properties)sessionProps.get(conn);
        }
        catch (Exception exception) {
            sessionProps = SQLNameFormatterUtilities.getFieldFromPhysicalConnection("sessionProperties", conn);
            sessionProps.setAccessible(true);
            connProperties = (Properties)sessionProps.get(conn);
        }
        fSessionProps = sessionProps;
        return connProperties;
    }

    private static Properties getConnPropsfromAuth(Connection conn) throws Exception {
        Properties connProperties = null;
        Field auth = fAuth;
        if (auth == null) {
            auth = SQLNameFormatterUtilities.getFieldFromT4CConnection("auth", conn);
        }
        Object authObj = null;
        try {
            auth.setAccessible(true);
            authObj = auth.get(conn);
        }
        catch (Exception exception) {
            auth = SQLNameFormatterUtilities.getFieldFromT4CConnection("auth", conn);
            auth.setAccessible(true);
            authObj = auth.get(conn);
        }
        Field connValues = authObj.getClass().getDeclaredField("connectionValues");
        connValues.setAccessible(true);
        connProperties = (Properties)connValues.get(authObj);
        fAuth = auth;
        return connProperties;
    }

    private static String getHostName(Properties connProperties) {
        String connHostName = null;
        if (connProperties != null) {
            connHostName = connProperties.getProperty("SERVER_HOST");
            if (connHostName == null) {
                connHostName = connProperties.getProperty("AUTH_SC_SERVER_HOST");
            }
            if (connHostName == null && kAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                kAgent.IAgent_getModuleFeedback().debug("SERVER HOST not found in Session Properties: " + connProperties);
            }
        }
        return connHostName;
    }

    public static Field getFieldFromPhysicalConnection(String fieldName, Connection conn) {
        Field field = null;
        try {
            Class<?> phyConn = Class.forName("oracle.jdbc.driver.PhysicalConnection", false, conn.getClass().getClassLoader());
            field = phyConn.getDeclaredField(fieldName);
            field.setAccessible(true);
        }
        catch (Exception exception) {}
        if (field == null) {
            field = SQLNameFormatterUtilities.getFieldInClassHierarchy(fieldName, conn);
        }
        return field;
    }

    public static Field getFieldFromT4CConnection(String fieldName, Connection conn) {
        Field field = null;
        try {
            Class<?> phyConn = Class.forName("oracle.jdbc.driver.T4CConnection", false, conn.getClass().getClassLoader());
            field = phyConn.getDeclaredField(fieldName);
            field.setAccessible(true);
        }
        catch (Exception exception) {}
        if (field == null) {
            field = SQLNameFormatterUtilities.getFieldInClassHierarchy(fieldName, conn);
        }
        return field;
    }

    public static Field getFieldInClassHierarchy(String fieldName, Object object) {
        Field field = null;
        Class<?> theClass = object.getClass();
        while (theClass != null) {
            try {
                field = theClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Exception exception) {}
            theClass = theClass.getSuperclass();
        }
        return field;
    }

    private static void setConnectionFieldfromWLConnPool(Class connClass) {
        try {
            Class<?> websphereConnImpl = Class.forName("oracle.jdbc.OracleConnectionWrapper", false, connClass.getClassLoader());
            Field connectn = websphereConnImpl.getDeclaredField("connection");
            connectn.setAccessible(true);
            fWLConnection = connectn;
        }
        catch (Exception exception) {
            kAgent.IAgent_getModuleFeedback().debug("Unable to get Oracle RAC DB hostname from WebLogicConnPool");
        }
    }

    private static void setConnectionFieldfromApacheConnPool(Class connClass, Connection conn) {
        Field connectn = null;
        try {
            Class<?> apacheConnImpl = Class.forName("org.apache.commons.dbcp.cpdsadapter.ConnectionImpl", false, connClass.getClassLoader());
            if (!SQLNameFormatterUtilities.isApacheCommonDBCP14(conn)) {
                connectn = apacheConnImpl.getDeclaredField("connection");
            } else {
                apacheConnImpl = Class.forName("org.apache.commons.dbcp.DelegatingConnection", false, connClass.getClassLoader());
                connectn = apacheConnImpl.getDeclaredField("_conn");
            }
            connectn.setAccessible(true);
            fOracleRacConnection = connectn;
        }
        catch (Exception exception) {
            kAgent.IAgent_getModuleFeedback().debug("Unable to get Oracle RAC DB hostname from ApacheConnPool");
        }
    }

    private static void setUnderLyingConnfromWrappedConn(Class connClass) {
        try {
            Class[] noparams = new Class[]{};
            Method method = connClass.getMethod(kGetUnderlyingConnectionMethodName, noparams);
            method.setAccessible(true);
            getUnderlyingConnectionMethod = method;
        }
        catch (Exception exception) {
            kAgent.IAgent_getModuleFeedback().debug("Unable to getgetUnderlyingConnection from org.jboss.resource.adapter.jdbc.WrappedConnection");
        }
    }

    private static boolean isApacheCommonDBCP14(Connection conn) {
        try {
            Class.forName("org.apache.commons.dbcp.managed.BasicManagedDataSource", false, conn.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static String getSafeCachedURL(IModuleFeedbackChannel feedback, Connection c) {
        String result = (String)SQLNameFormatterUtilities.getFromUrlCacheMap(c);
        if (result == null) {
            result = SQLNameFormatterUtilities.getSafeURL(feedback, c);
            if (result != null) {
                result = result.toLowerCase();
            }
            SQLNameFormatterUtilities.putInUrlCacheMap(c, result);
        }
        return result;
    }

    public static String getSafeURL(IModuleFeedbackChannel feedback, Connection c) {
        try {
            String result;
            DatabaseMetaData md;
            SQLNameFormatterUtilities utilities = SQLNameFormatterUtilities.getInstance();
            if (c != null && (md = utilities.getMetaData(c, feedback)) != null && (result = utilities.getURL(c, md, feedback)) != null) {
                String host;
                if (result.startsWith("jdbc:oracle") && SQLNameFormatterUtilities.doesMultipleHostsExist(result) && (host = SQLNameFormatterUtilities.getConnectedRACHost(c)) != null && host.trim().length() != 0) {
                    StringBuilder server = new StringBuilder(result);
                    result = server.append(kServerNameEquals).append(host).toString();
                }
                return result.toLowerCase();
            }
        }
        catch (ThreadDeath td2) {
            throw td2;
        }
        catch (Throwable throwable) {}
        return SQLNameFormatterUtilities.getConnectionClassName(c);
    }

    private static boolean isRacURL(String url, DatabaseMetaData md) throws SQLException {
        int hostStrIndex = url.toLowerCase().indexOf("host");
        return hostStrIndex != -1 && (url.charAt(hostStrIndex - 1) == '(' || url.charAt(hostStrIndex - 1) == ' ');
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean doesMultipleHostsExist(String url) {
        IModuleFeedbackChannel feedback = kAgent.IAgent_getModuleFeedback();
        try {
            if (url == null) {
                return false;
            }
            Matcher matcher = sHostPattern.matcher(url.toLowerCase());
            if (feedback.isTraceEnabled()) {
                feedback.trace("Searching for multiple hosts configured in the JDBC URL " + url);
            }
            int from = 0;
            int count = 0;
            while (true) {
                if (!matcher.find(from)) {
                    return false;
                }
                if (++count >= 2) {
                    if (!feedback.isTraceEnabled()) return true;
                    feedback.trace("This is a Oracle RAC URL");
                    return true;
                }
                from = matcher.start() + 1;
            }
        }
        catch (Exception e) {
            if (!feedback.isTraceEnabled()) return false;
            feedback.debug("An exception occured while determinig Oracle RAC URL", (Throwable)e);
        }
        return false;
    }

    public static Object getFromUrlCacheMap(Object connection) {
        if (fCacheConnectionsUrls) {
            return sUrlCacheMap.getWeak(connection);
        }
        return null;
    }

    public static Object putInUrlCacheMap(Object connection, Object urlString) {
        if (fCacheConnectionsUrls) {
            return sUrlCacheMap.putWeak(connection, urlString);
        }
        return null;
    }

    public static IWeakIdentityMap getConnectionsToURLCache() {
        return sUrlCacheMap;
    }

    public static Map getURLToFormattedNameCache() {
        return sUrlCache;
    }

    public static boolean isCacheConnectionsUrls() {
        return fCacheConnectionsUrls;
    }

    private static void loadGenericDatabasePlugins() {
        DBNameFormatterLoader fdatabaseExtensionLoader = new DBNameFormatterLoader(kAgent);
        List<IGenericDBNameFormatter> dbPlugins = fdatabaseExtensionLoader.getDatabaseNameFormatterPlugins();
        for (IGenericDBNameFormatter dbPlugin : dbPlugins) {
            sKnownDBTypes.add(dbPlugin.getDBPrefix());
            fDispatchTable.put(dbPlugin.getDBPrefix(), dbPlugin.getNameFormatter());
        }
    }

    public static boolean isIgnoreUnknownUrlType() {
        return ignoreUnknownUrlType;
    }

    public static String getConnectionClassName(Object conn) {
        return conn.getClass().getName();
    }

    private static class BEAOracleFormatter
    implements IDBNameFormatter {
        private BEAOracleFormatter() {
        }

        @Override
        public String format(String inString, IStringLocalizer localizer) {
            int colonIndex;
            String result = null;
            int doubleSlashIndex = inString.indexOf("//");
            if (doubleSlashIndex >= 0 && (colonIndex = inString.indexOf(58, doubleSlashIndex + 1)) > doubleSlashIndex) {
                int hostStart = doubleSlashIndex + 2;
                int hostEnd = colonIndex;
                int portStart = hostEnd + 1;
                int portEnd = inString.indexOf(59, portStart + 1);
                String host = inString.substring(hostStart, hostEnd);
                String port = null;
                String sid = null;
                if (portEnd == -1) {
                    port = inString.substring(portStart);
                } else {
                    port = inString.substring(portStart, portEnd);
                    int sidStart = inString.indexOf("sid=", portEnd + 1);
                    if (sidStart >= 0) {
                        int sidEnd = inString.indexOf(59, sidStart += 4);
                        sid = sidEnd == -1 ? inString.substring(sidStart) : inString.substring(sidStart, sidEnd);
                    }
                }
                result = sid != null ? localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_Oracle_Template", sid.trim(), host.trim(), port.trim()) : localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_Oracle_Template_No_SID", host.trim(), port.trim());
            }
            return result;
        }
    }

    static final class CacheConnectionsURLsProperty
    extends BooleanConfigurationProperty {
        private CacheConnectionsURLsProperty(IAgent agent) {
            super(SQLNameFormatterUtilities.kCacheConnectionsURLs, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fCacheConnectionsUrls = (Boolean)newValue != false && sUrlCacheMap != null;
        }
    }

    private static class ClarityOracleFormatter
    implements IDBNameFormatter {
        private ClarityOracleFormatter() {
        }

        @Override
        public String format(String inString, IStringLocalizer localizer) {
            String result = null;
            int slashes = inString.indexOf("//");
            if (slashes >= 0) {
                int hostStart = slashes + 2;
                int colonSeparatingNameAndPort = inString.indexOf(58, hostStart);
                String host = null;
                String port = null;
                if (colonSeparatingNameAndPort >= 0) {
                    host = inString.substring(hostStart, colonSeparatingNameAndPort);
                    int semicolonAfterPort = inString.indexOf(59, colonSeparatingNameAndPort);
                    port = semicolonAfterPort >= 0 ? inString.substring(colonSeparatingNameAndPort + 1, semicolonAfterPort) : inString.substring(colonSeparatingNameAndPort + 1);
                } else {
                    int semicolonAfterHost = inString.indexOf(59, hostStart);
                    host = semicolonAfterHost >= 0 ? inString.substring(hostStart, semicolonAfterHost) : inString.substring(hostStart);
                }
                result = port != null ? String.valueOf(host) + " on " + port + " (Clarity/Oracle DB)" : String.valueOf(host) + " (Clarity/Oracle DB)";
            }
            return result;
        }
    }

    private static class DB2Formatter
    implements IDBNameFormatter {
        private DB2Formatter() {
        }

        @Override
        public String format(String inString, IStringLocalizer localizer) {
            String formattedURL = "DB2 DB";
            try {
                int doubleSlashIndex = inString.indexOf("//");
                if (doubleSlashIndex >= 0) {
                    int startIndex = doubleSlashIndex + 2;
                    int slashIndex = inString.indexOf(47, startIndex);
                    int semiColonIndex = inString.indexOf(59, startIndex);
                    int colonIndex = inString.indexOf(58, startIndex);
                    if (slashIndex > startIndex) {
                        int otherSlashIndex;
                        int len = otherSlashIndex = inString.indexOf(47, slashIndex + 1);
                        if (otherSlashIndex <= slashIndex) {
                            len = inString.length();
                        }
                        if (colonIndex > startIndex) {
                            formattedURL = this.formatFromHostPortAndName(inString, startIndex, colonIndex, slashIndex, slashIndex + 1, len, localizer);
                        } else {
                            if (semiColonIndex >= 0) {
                                len = semiColonIndex;
                            }
                            formattedURL = this.formatFromHostAndName(inString, startIndex, slashIndex, slashIndex + 1, len, localizer);
                        }
                    } else if (semiColonIndex > startIndex) {
                        int dbNameIndex = inString.indexOf(SQLNameFormatterUtilities.kDBNameEquals);
                        if (dbNameIndex > semiColonIndex) {
                            int otherSemiColonIndex;
                            int dbNameEndIndex = dbNameIndex + SQLNameFormatterUtilities.kDBNameEquals.length();
                            int len = otherSemiColonIndex = inString.indexOf(59, dbNameEndIndex + 1);
                            if (otherSemiColonIndex <= dbNameEndIndex) {
                                len = inString.length();
                            }
                            formattedURL = colonIndex > startIndex ? this.formatFromHostPortAndName(inString, startIndex, colonIndex, semiColonIndex, dbNameEndIndex, len, localizer) : this.formatFromHostAndName(inString, startIndex, semiColonIndex, dbNameIndex, len, localizer);
                        } else {
                            int locIndex = inString.indexOf(SQLNameFormatterUtilities.kLocEquals);
                            if (locIndex > semiColonIndex) {
                                int otherSemiColonIndex;
                                int locEndIndex = locIndex + SQLNameFormatterUtilities.kLocEquals.length();
                                int len = otherSemiColonIndex = inString.indexOf(59, locEndIndex + 1);
                                if (otherSemiColonIndex <= locEndIndex) {
                                    len = inString.length();
                                }
                                formattedURL = colonIndex > startIndex ? this.formatFromHostPortAndName(inString, startIndex, colonIndex, semiColonIndex, locEndIndex, len, localizer) : this.formatFromHostAndName(inString, startIndex, semiColonIndex, locEndIndex, len, localizer);
                            }
                        }
                    } else {
                        formattedURL = this.formatMinimal(inString, startIndex, localizer);
                    }
                } else {
                    formattedURL = this.formatMinimal(inString, 0, localizer);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            return formattedURL;
        }

        private String formatMinimal(String inString, int startIndex, IStringLocalizer localizer) {
            return localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_DB2_Minimal_Template", inString.substring(startIndex));
        }

        private String formatFromHostAndName(String inString, int startIndex, int hostEndIndex, int dbNameDelimIndex, int len, IStringLocalizer localizer) {
            return localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_DB2_Host_Template", inString.substring(dbNameDelimIndex, len), inString.substring(startIndex, hostEndIndex));
        }

        private String formatFromHostPortAndName(String inString, int startIndex, int colonIndex, int portEndIndex, int dbNameDelimIndex, int len, IStringLocalizer localizer) {
            return localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_DB2_Full_Template", inString.substring(dbNameDelimIndex, len), inString.substring(startIndex, colonIndex), inString.substring(colonIndex + 1, portEndIndex));
        }
    }

    private static class DerbyFormatter
    implements IDBNameFormatter {
        private DerbyFormatter() {
        }

        @Override
        public String format(String inString, IStringLocalizer localizer) {
            String result = null;
            if (inString != null) {
                int startOfHost = inString.indexOf("//");
                if (startOfHost >= 0) {
                    int nextColon = inString.indexOf(58, (startOfHost += 2) + 1);
                    int nextSlash = inString.indexOf(47, startOfHost + 1);
                    if (nextSlash > startOfHost && nextColon < 0) {
                        String host;
                        result = host = inString.substring(startOfHost, nextSlash);
                        int startOdDatabaseName = nextSlash + 1;
                        int nextSemicolon = inString.indexOf(59, startOdDatabaseName);
                        if (nextSemicolon > startOdDatabaseName) {
                            String databasename = inString.substring(startOdDatabaseName, nextSemicolon);
                            result = String.valueOf(result) + " (" + databasename + " instance)";
                        } else {
                            String databasename = inString.substring(startOdDatabaseName, inString.length());
                            result = String.valueOf(result) + " (" + databasename + " instance)";
                        }
                    } else if (nextSlash > startOfHost && nextColon < nextSlash) {
                        String host;
                        result = host = inString.substring(startOfHost, nextColon);
                        String port = inString.substring(nextColon + 1, nextSlash);
                        result = String.valueOf(result) + " on " + port;
                        int startOdDatabaseName = nextSlash + 1;
                        int nextSemicolon = inString.indexOf(59, startOdDatabaseName);
                        if (nextSemicolon > startOdDatabaseName) {
                            String databasename = inString.substring(startOdDatabaseName, nextSemicolon);
                            result = String.valueOf(result) + " (" + databasename + " instance)";
                        } else {
                            String databasename = inString.substring(startOdDatabaseName, inString.length());
                            result = String.valueOf(result) + " (" + databasename + " instance)";
                        }
                    } else {
                        result = inString.substring(startOfHost, inString.length());
                    }
                } else {
                    result = inString;
                }
            }
            result = String.valueOf(result) + " (Derby DB)";
            return result;
        }
    }

    private static class HypersonicFormatter
    implements IDBNameFormatter {
        private HypersonicFormatter() {
        }

        @Override
        public String format(String inString, IStringLocalizer localizer) {
            String result = null;
            if (inString != null) {
                result = String.valueOf(inString) + " (Hypersonic)";
            }
            return result;
        }
    }

    static final class IgnoreUnknownUrlTypeProperty
    extends BooleanConfigurationProperty {
        private IgnoreUnknownUrlTypeProperty(IAgent agent) {
            super(SQLNameFormatterUtilities.ignoreUnknownUrlTypePropertyName, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            ignoreUnknownUrlType = (Boolean)newValue;
        }
    }

    private static class InformixSQLiFormatter
    implements IDBNameFormatter {
        private static final String kDefaultPort = "1530";

        private InformixSQLiFormatter() {
        }

        @Override
        public String format(String inString, IStringLocalizer localizer) {
            String result;
            block15: {
                result = "Informix DB";
                int doubleSlashIndex = inString.indexOf("//");
                try {
                    if (doubleSlashIndex >= 0) {
                        int hostStart = doubleSlashIndex + 2;
                        int colonIndex = inString.indexOf(58, hostStart + 1);
                        int slashIndex = inString.indexOf(47, hostStart + 1);
                        if (slashIndex > 0) {
                            int hostEnd = colonIndex;
                            String port = kDefaultPort;
                            if (colonIndex > doubleSlashIndex && colonIndex < slashIndex) {
                                int portStart = hostEnd + 1;
                                int portEnd = slashIndex;
                                port = inString.substring(portStart, portEnd);
                            } else {
                                hostEnd = slashIndex;
                            }
                            String host = inString.substring(hostStart, hostEnd);
                            String dbname = null;
                            int dbnameStart = slashIndex + 1;
                            int dbnameEnd = inString.indexOf(58, dbnameStart);
                            dbname = dbnameEnd == -1 ? inString.substring(dbnameStart) : inString.substring(dbnameStart, dbnameEnd);
                            result = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_Informix_Template", dbname, host, port);
                        }
                    } else if (inString.indexOf("INFORMIXSERVER=") != -1 || inString.indexOf("informixserver=") != -1) {
                        doubleSlashIndex = inString.indexOf("INFORMIXSERVER=");
                        if (doubleSlashIndex < 0) {
                            doubleSlashIndex = inString.indexOf("informixserver=");
                        }
                        int srvrIndex = inString.indexOf(61, doubleSlashIndex);
                        String srvrName = null;
                        String dbName = "";
                        int srvrEnd = inString.indexOf(59, srvrIndex + 1);
                        if (doubleSlashIndex >= 0 && srvrIndex > 0 && srvrEnd > 0 && srvrIndex + 1 < srvrEnd) {
                            srvrName = inString.substring(srvrIndex + 1, srvrEnd);
                            if (inString.indexOf("DATABASE=") != -1 || inString.indexOf("database=") != -1) {
                                doubleSlashIndex = inString.indexOf("DATABASE=");
                                if (doubleSlashIndex < 0) {
                                    doubleSlashIndex = inString.indexOf("database=");
                                }
                                int dbnameStart = inString.indexOf(61, doubleSlashIndex);
                                if (doubleSlashIndex >= 0 && dbnameStart > 0) {
                                    int dbnameEnd = inString.indexOf(59, dbnameStart + 1);
                                    int inStrLen = inString.length();
                                    if (inStrLen > dbnameStart + 1 && inStrLen >= dbnameEnd && dbnameStart + 1 < dbnameEnd) {
                                        dbName = inString.substring(dbnameStart + 1, dbnameEnd);
                                    }
                                }
                            }
                        }
                        if (srvrName != null) {
                            result = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_Informix_Host_Template", dbName, srvrName);
                        }
                    }
                }
                catch (Exception e) {
                    if (!kAgent.IAgent_getModuleFeedback().isDebugEnabled()) break block15;
                    kAgent.IAgent_getModuleFeedback().debug("An Exception occured in formatting name from URL : " + inString);
                    kAgent.IAgent_getModuleFeedback().error((Throwable)e);
                }
            }
            return result;
        }
    }

    private static class IntroscopeDataSourceFormatter
    implements IDBNameFormatter {
        private IntroscopeDataSourceFormatter() {
        }

        @Override
        public String format(String inString, IStringLocalizer localizer) {
            int colonIndex;
            String result = null;
            int atIndex = inString.indexOf(64);
            if (atIndex > 0 && (colonIndex = inString.indexOf(58, atIndex)) > atIndex) {
                String host = inString.substring(atIndex + 1, colonIndex);
                String port = inString.substring(colonIndex + 1);
                StringBuilder sb = new StringBuilder(host);
                sb.append("-");
                sb.append(port);
                sb.append(" (Introscope DS)");
                result = sb.toString();
            }
            return result;
        }
    }

    private static class JDBCPointbaseFormatter
    implements IDBNameFormatter {
        private JDBCPointbaseFormatter() {
        }

        @Override
        public String format(String inString, IStringLocalizer localizer) {
            return String.valueOf(inString) + "(POINTBASE DB)";
        }
    }

    private static class MongoDBFormatter
    implements IDBNameFormatter {
        private static final String kDefaultPort = "27017";

        private MongoDBFormatter() {
        }

        @Override
        public String format(String inString, IStringLocalizer localizer) {
            String result = null;
            int doubleSlashIndex = inString.indexOf("//");
            if (doubleSlashIndex >= 0) {
                int hostStart = doubleSlashIndex + 2;
                int colonIndex = inString.indexOf(58, hostStart + 1);
                int slashIndex = inString.indexOf(47, hostStart + 1);
                if (slashIndex > 0) {
                    int hostEnd = colonIndex;
                    String port = kDefaultPort;
                    if (colonIndex > doubleSlashIndex && colonIndex < slashIndex) {
                        int portStart = hostEnd + 1;
                        int portEnd = slashIndex;
                        port = inString.substring(portStart, portEnd);
                    } else {
                        hostEnd = slashIndex;
                    }
                    String host = inString.substring(hostStart, hostEnd);
                    String dbname = null;
                    int dbnameStart = slashIndex + 1;
                    int dbnameEnd = inString.indexOf(63, dbnameStart);
                    dbname = dbnameEnd == -1 ? inString.substring(dbnameStart) : inString.substring(dbnameStart, dbnameEnd);
                    result = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_MongoDB_Template", dbname, host, port);
                }
            }
            return result;
        }
    }

    private static class MySQLFormatter
    implements IDBNameFormatter {
        private String kMySQLFullTemplate = "{0} on {1}-{2} (MySQL DB)";
        private String kMySQLHostPortTemplate = "{0}-{1} (MySQL DB)";
        private String kMySQLInstanceHostTemplate = "{0} on {1} (MySQL DB)";
        private String kMySQLHostTemplate = "{0}(MySQL DB)";

        private MySQLFormatter() {
        }

        @Override
        public String format(String inString, IStringLocalizer localizer) {
            String formattedURL = "MySQL DB";
            try {
                int startIndex = inString.indexOf("//") + 2;
                if (startIndex > 0) {
                    int slashIndex = inString.indexOf(47, startIndex);
                    if (slashIndex > startIndex) {
                        int questionMarkIndex = inString.indexOf(63, slashIndex);
                        int semicolonIndex = inString.indexOf(58, startIndex);
                        if (semicolonIndex < slashIndex && semicolonIndex > startIndex) {
                            if (questionMarkIndex > slashIndex) {
                                Object[] arguments = new String[]{inString.substring(slashIndex + 1, questionMarkIndex), inString.substring(startIndex, semicolonIndex), inString.substring(semicolonIndex + 1, slashIndex)};
                                formattedURL = MessageFormat.format(this.kMySQLFullTemplate, arguments);
                            } else {
                                Object[] arguments = new String[]{inString.substring(slashIndex + 1), inString.substring(startIndex, semicolonIndex), inString.substring(semicolonIndex + 1, slashIndex)};
                                formattedURL = MessageFormat.format(this.kMySQLFullTemplate, arguments);
                            }
                        } else if (questionMarkIndex > slashIndex) {
                            Object[] arguments = new String[]{inString.substring(slashIndex + 1, questionMarkIndex), inString.substring(startIndex, slashIndex)};
                            formattedURL = MessageFormat.format(this.kMySQLInstanceHostTemplate, arguments);
                        } else {
                            Object[] arguments = new String[]{inString.substring(slashIndex + 1), inString.substring(startIndex, slashIndex)};
                            formattedURL = MessageFormat.format(this.kMySQLInstanceHostTemplate, arguments);
                        }
                    } else {
                        int semicolonIndex = inString.indexOf(58, startIndex);
                        if (semicolonIndex > startIndex) {
                            Object[] arguments = new String[]{inString.substring(startIndex, semicolonIndex), inString.substring(semicolonIndex + 1)};
                            formattedURL = MessageFormat.format(this.kMySQLHostPortTemplate, arguments);
                        } else {
                            Object[] arguments = new String[]{inString.substring(startIndex)};
                            formattedURL = MessageFormat.format(this.kMySQLHostTemplate, arguments);
                        }
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            return formattedURL;
        }
    }

    private static class NeonDB2Formatter
    implements IDBNameFormatter {
        static final String portEq = "port=";
        static final String hostEq = "host=";
        static final String apnaEq = "apna=";

        private NeonDB2Formatter() {
        }

        @Override
        public String format(String inString, IStringLocalizer localizer) {
            String result = null;
            String host = null;
            String port = null;
            String apna = null;
            int formatIndex = 0;
            if (inString != null) {
                int startOfApna;
                int startOfHost;
                int startOfPort = inString.indexOf(portEq);
                if (startOfPort != -1) {
                    int endOfPort = inString.indexOf(59, startOfPort += portEq.length());
                    if (endOfPort == -1) {
                        endOfPort = inString.length();
                    }
                    port = inString.substring(startOfPort, endOfPort);
                    formatIndex |= 4;
                }
                if ((startOfHost = inString.indexOf(hostEq)) != -1) {
                    int endOfHost = inString.indexOf(59, startOfHost += hostEq.length());
                    if (endOfHost == -1) {
                        endOfHost = inString.length();
                    }
                    host = inString.substring(startOfHost, endOfHost);
                    formatIndex |= 2;
                }
                if ((startOfApna = inString.indexOf(apnaEq)) != -1) {
                    int endOfApna = inString.indexOf(59, startOfApna += apnaEq.length());
                    if (endOfApna == -1) {
                        endOfApna = inString.length();
                    }
                    apna = inString.substring(startOfApna, endOfApna);
                    formatIndex |= 1;
                }
            }
            result = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_NeonDB2_Template" + formatIndex, apna, host, port);
            return result;
        }
    }

    private class OracleFormatter
    implements IOracleDBNameFormatter {
        private static final String kOracleDB = "Oracle DB";

        private OracleFormatter() {
        }

        @Override
        public String format(String inString, Connection conn, IStringLocalizer localizer) {
            String formatted = kOracleDB;
            String host = "";
            String port = "";
            String sid = "";
            StringBuffer distinctUrl = null;
            int atIndex = inString.indexOf(64);
            if (atIndex >= 0) {
                int firstColonIndex = inString.indexOf(58, atIndex + 1);
                if (firstColonIndex > atIndex) {
                    boolean doubleSlashAfterAt = inString.charAt(atIndex + 1) == '/' && inString.charAt(atIndex + 2) == '/';
                    int hostStart = !doubleSlashAfterAt ? atIndex + 1 : atIndex + 3;
                    int hostEnd = firstColonIndex;
                    int portStart = firstColonIndex + 1;
                    int portEnd = -1;
                    int sidStart = -1;
                    int secondColonIndex = inString.indexOf(58, firstColonIndex + 1);
                    int slashIndex = -1;
                    if (secondColonIndex == -1) {
                        slashIndex = inString.indexOf(47, firstColonIndex + 1);
                    }
                    if (secondColonIndex > firstColonIndex || slashIndex > firstColonIndex) {
                        portEnd = secondColonIndex != -1 ? secondColonIndex : slashIndex;
                        sidStart = secondColonIndex != -1 ? secondColonIndex + 1 : slashIndex + 1;
                    } else {
                        int semiColonIndex = inString.indexOf(59, firstColonIndex);
                        if (semiColonIndex > firstColonIndex && (sidStart = inString.indexOf("sid=", portEnd = semiColonIndex)) != -1) {
                            sidStart += 4;
                        }
                    }
                    if (portEnd != -1 && sidStart != -1) {
                        host = inString.substring(hostStart, hostEnd);
                        port = inString.substring(portStart, portEnd);
                        sid = inString.substring(sidStart);
                    }
                } else {
                    int fistHostIndex;
                    int slashIndex = inString.indexOf(47, atIndex);
                    if (slashIndex >= 0) {
                        port = "";
                        host = inString.substring(atIndex + 1, slashIndex);
                        sid = inString.substring(slashIndex + 1);
                    }
                    if ((fistHostIndex = (inString = inString.toLowerCase()).indexOf("host")) >= 0) {
                        int secondHostIndex = inString.indexOf("host", fistHostIndex + 4);
                        if (secondHostIndex >= 0) {
                            int hostNameIndex;
                            int lastServerIndex;
                            distinctUrl = new StringBuffer("jdbc:oracle:");
                            distinctUrl.append(inString);
                            if (sUrlCache != null) {
                                formatted = (String)sUrlCache.get(distinctUrl.toString());
                                if (formatted != null) {
                                    return formatted;
                                }
                                formatted = kOracleDB;
                            }
                            if ((lastServerIndex = inString.lastIndexOf(SQLNameFormatterUtilities.kServerNameEquals, inString.length() - 1)) != -1) {
                                host = inString.substring(lastServerIndex + SQLNameFormatterUtilities.kServerNameEquals.length());
                            }
                            if ((hostNameIndex = inString.indexOf(host)) > 0) {
                                int currentAddress = inString.lastIndexOf("address", hostNameIndex);
                                int nextAddress = inString.indexOf("address", hostNameIndex);
                                port = SQLNameFormatterUtilities.this.parseParameter(currentAddress, nextAddress, inString, "port");
                                sid = SQLNameFormatterUtilities.this.parseParameter(currentAddress, -1, inString, "service_name");
                                if (sid.equals("")) {
                                    sid = SQLNameFormatterUtilities.this.parseParameter(currentAddress, -1, inString, "sid");
                                }
                            }
                        } else {
                            if (inString.indexOf(SQLNameFormatterUtilities.kServerNameEquals) != -1) {
                                int lastServerIndex = inString.lastIndexOf(SQLNameFormatterUtilities.kServerNameEquals, inString.length() - 1);
                                if (lastServerIndex != -1) {
                                    host = inString.substring(lastServerIndex + SQLNameFormatterUtilities.kServerNameEquals.length());
                                }
                            } else {
                                host = SQLNameFormatterUtilities.this.parseParameter(atIndex, -1, inString, "host");
                            }
                            port = SQLNameFormatterUtilities.this.parseParameter(atIndex, -1, inString, "port");
                            sid = SQLNameFormatterUtilities.this.parseParameter(atIndex, -1, inString, "service_name");
                            if (sid.equals("")) {
                                sid = SQLNameFormatterUtilities.this.parseParameter(atIndex, -1, inString, "sid");
                            }
                        }
                    }
                }
            }
            if (!(host.equals("") && port.equals("") && sid.equals(""))) {
                formatted = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_Oracle_Template", sid.trim(), host.trim(), port.trim());
            }
            return formatted;
        }
    }

    private static class PointbaseFormatter
    implements IDBNameFormatter {
        private PointbaseFormatter() {
        }

        @Override
        public String format(String inString, IStringLocalizer localizer) {
            int nextSlash;
            int startOfHost;
            String result = null;
            if (inString != null && (startOfHost = inString.indexOf("//") + 2) >= 0 && (nextSlash = inString.indexOf(47, startOfHost + 1)) > startOfHost) {
                String host = inString.substring(startOfHost, nextSlash);
                String name = inString.substring(nextSlash + 1);
                result = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_Pointbase_Template", name, host);
            }
            return result;
        }
    }

    private static class PostgresSQLFormatter
    implements IDBNameFormatter {
        private static final String kDefaultPort = "5432";

        private PostgresSQLFormatter() {
        }

        @Override
        public String format(String inString, IStringLocalizer localizer) {
            String result = null;
            int doubleSlashIndex = inString.indexOf("//");
            if (doubleSlashIndex >= 0) {
                int hostStart = doubleSlashIndex + 2;
                int colonIndex = inString.indexOf(58, hostStart + 1);
                int slashIndex = inString.indexOf(47, hostStart + 1);
                if (slashIndex > 0) {
                    int hostEnd = colonIndex;
                    String port = kDefaultPort;
                    if (colonIndex > doubleSlashIndex && colonIndex < slashIndex) {
                        int portStart = hostEnd + 1;
                        int portEnd = slashIndex;
                        port = inString.substring(portStart, portEnd);
                    } else {
                        hostEnd = slashIndex;
                    }
                    String host = inString.substring(hostStart, hostEnd);
                    String dbname = null;
                    int dbnameStart = slashIndex + 1;
                    int dbnameEnd = inString.indexOf(63, dbnameStart);
                    dbname = dbnameEnd == -1 ? inString.substring(dbnameStart) : inString.substring(dbnameStart, dbnameEnd);
                    result = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_Postgres_Template", dbname, host, port);
                }
            }
            return result;
        }
    }

    private static class SAPMaxDBFormatter
    implements IDBNameFormatter {
        private static final String kDefaultPort = "7210";

        private SAPMaxDBFormatter() {
        }

        @Override
        public String format(String inString, IStringLocalizer localizer) {
            String result = null;
            int doubleSlashIndex = inString.indexOf("//");
            if (doubleSlashIndex >= 0) {
                int hostStart = doubleSlashIndex + 2;
                int colonIndex = inString.indexOf(58, hostStart + 1);
                int slashIndex = inString.indexOf(47, hostStart + 1);
                if (slashIndex > 0) {
                    int hostEnd = colonIndex;
                    String port = kDefaultPort;
                    if (colonIndex > doubleSlashIndex && colonIndex < slashIndex) {
                        int portStart = hostEnd + 1;
                        int portEnd = slashIndex;
                        port = inString.substring(portStart, portEnd);
                    } else {
                        hostEnd = slashIndex;
                    }
                    String host = inString.substring(hostStart, hostEnd);
                    String dbname = null;
                    int dbnameStart = slashIndex + 1;
                    int dbnameEnd = inString.indexOf(63, dbnameStart);
                    dbname = dbnameEnd == -1 ? inString.substring(dbnameStart) : inString.substring(dbnameStart, dbnameEnd);
                    result = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_MaxDB_Template", dbname, host, port);
                }
            }
            return result;
        }
    }

    private static class SQLServerFormatter
    implements IDBNameFormatter {
        private SQLServerFormatter() {
        }

        @Override
        public String format(String inString, IStringLocalizer localizer) {
            String formattedURL = "MS SQL Server DB";
            try {
                int colonIndex;
                int startIndex = inString.indexOf("//") + 2;
                if (startIndex > 0 && (colonIndex = inString.indexOf(58, startIndex)) > startIndex) {
                    int semiColonIndex = inString.indexOf(59, colonIndex + 1);
                    int doubleBackSlashIndex = inString.indexOf(92, startIndex);
                    if (doubleBackSlashIndex > startIndex && doubleBackSlashIndex < colonIndex) {
                        if (semiColonIndex < 0 || semiColonIndex < colonIndex) {
                            formattedURL = this.formatInstanceOnly(inString, startIndex, doubleBackSlashIndex, colonIndex + 1, inString.length(), doubleBackSlashIndex + 1, colonIndex, localizer);
                        } else {
                            int dbNameIndex = inString.indexOf(SQLNameFormatterUtilities.kDBNameEquals, semiColonIndex);
                            if (dbNameIndex > semiColonIndex) {
                                int otherSemiColonIndex;
                                int dbNameEndIndex = dbNameIndex + SQLNameFormatterUtilities.kDBNameEquals.length();
                                int len = otherSemiColonIndex = inString.indexOf(59, dbNameEndIndex);
                                if (otherSemiColonIndex <= dbNameEndIndex) {
                                    len = inString.length();
                                }
                                formattedURL = this.formatInstanceAndDBName(inString, startIndex, doubleBackSlashIndex, colonIndex + 1, semiColonIndex, doubleBackSlashIndex + 1, colonIndex, dbNameEndIndex, len, localizer);
                            } else {
                                formattedURL = this.formatInstanceOnly(inString, startIndex, doubleBackSlashIndex, colonIndex + 1, semiColonIndex, doubleBackSlashIndex + 1, colonIndex, localizer);
                            }
                        }
                    } else if (doubleBackSlashIndex > colonIndex) {
                        if (semiColonIndex < 0 || semiColonIndex < doubleBackSlashIndex) {
                            formattedURL = this.formatInstanceOnly(inString, startIndex, colonIndex, colonIndex + 1, doubleBackSlashIndex, doubleBackSlashIndex + 1, inString.length(), localizer);
                        } else {
                            int dbNameIndex = inString.indexOf(SQLNameFormatterUtilities.kDBNameEquals, semiColonIndex);
                            if (dbNameIndex > semiColonIndex) {
                                int otherSemiColonIndex;
                                int dbNameEndIndex = dbNameIndex + SQLNameFormatterUtilities.kDBNameEquals.length();
                                int len = otherSemiColonIndex = inString.indexOf(59, dbNameEndIndex);
                                if (otherSemiColonIndex <= dbNameEndIndex) {
                                    len = inString.length();
                                }
                                formattedURL = this.formatInstanceAndDBName(inString, startIndex, colonIndex, colonIndex + 1, doubleBackSlashIndex, doubleBackSlashIndex + 1, semiColonIndex, dbNameEndIndex, len, localizer);
                            } else {
                                formattedURL = this.formatInstanceOnly(inString, startIndex, colonIndex, colonIndex + 1, doubleBackSlashIndex, doubleBackSlashIndex + 1, semiColonIndex, localizer);
                            }
                        }
                    } else if (semiColonIndex > colonIndex) {
                        int dbNameIndex = inString.indexOf(SQLNameFormatterUtilities.kDBNameEquals, semiColonIndex);
                        if (dbNameIndex > semiColonIndex) {
                            int dbNameEndIndex = dbNameIndex + SQLNameFormatterUtilities.kDBNameEquals.length();
                            int otherSemiColonIndex = inString.indexOf(59, dbNameEndIndex);
                            if (otherSemiColonIndex > dbNameEndIndex) {
                                formattedURL = this.formatDBNameOnly(inString, startIndex, colonIndex, semiColonIndex, dbNameEndIndex, otherSemiColonIndex, localizer);
                            } else if (otherSemiColonIndex != dbNameEndIndex) {
                                formattedURL = this.formatDBNameOnly(inString, startIndex, colonIndex, semiColonIndex, dbNameEndIndex, inString.length(), localizer);
                            }
                        } else {
                            formattedURL = this.formatMinimal(inString, startIndex, colonIndex, semiColonIndex, localizer);
                        }
                    } else {
                        formattedURL = this.formatMinimal(inString, startIndex, colonIndex, inString.length(), localizer);
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            return formattedURL;
        }

        private String formatMinimal(String inString, int startIndex, int colonIndex, int lastIndex, IStringLocalizer localizer) {
            return localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_SQLServer_Minimal_Template", inString.substring(startIndex, colonIndex), inString.substring(colonIndex + 1, lastIndex));
        }

        private String formatInstanceAndDBName(String inString, int startIndex, int hostEndIndex, int portBeginIndex, int portEndIndex, int instanceBeginIndex, int instanceEndIndex, int dbNameIndex, int lastIndex, IStringLocalizer localizer) {
            return localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_SQLServer_With_Full_Info_Name_Template", inString.substring(dbNameIndex, lastIndex), inString.substring(instanceBeginIndex, instanceEndIndex), inString.substring(startIndex, hostEndIndex), inString.substring(portBeginIndex, portEndIndex));
        }

        private String formatInstanceOnly(String inString, int startIndex, int hostEndIndex, int portBeginIndex, int portEndIndex, int instanceBeginIndex, int instanceEndIndex, IStringLocalizer localizer) {
            return localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_SQLServer_With_Instance_Name_Template", inString.substring(instanceBeginIndex, instanceEndIndex), inString.substring(startIndex, hostEndIndex), inString.substring(portBeginIndex, portEndIndex));
        }

        private String formatDBNameOnly(String inString, int startIndex, int colonIndex, int semiColonIndex, int dbNameIndex, int lastIndex, IStringLocalizer localizer) {
            return localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_SQLServer_With_DBName_Template", inString.substring(dbNameIndex, lastIndex), inString.substring(startIndex, colonIndex), inString.substring(colonIndex + 1, semiColonIndex));
        }
    }

    private static class SybaseFormatter
    implements IDBNameFormatter {
        private SybaseFormatter() {
        }

        @Override
        public String format(String inString, IStringLocalizer localizer) {
            String result = null;
            int endOfHostName = inString.indexOf(58);
            try {
                if (endOfHostName > 0) {
                    String host = inString.substring(0, endOfHostName);
                    int forwardSlashIndex = inString.indexOf(47, endOfHostName + 1);
                    int questionMarkIndex = inString.indexOf(63, endOfHostName + 1);
                    if (forwardSlashIndex == -1 && questionMarkIndex == -1) {
                        String port = inString.substring(endOfHostName + 1);
                        result = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_Sybase_No_SID_Template", host, port);
                    } else if (forwardSlashIndex == -1 && questionMarkIndex != -1) {
                        String port = inString.substring(endOfHostName + 1, questionMarkIndex);
                        int serviceNameIndex = inString.indexOf("servicename=", questionMarkIndex + 1);
                        if (serviceNameIndex == -1) {
                            result = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_Sybase_No_SID_Template", host, port);
                        } else {
                            int ampersandIndex = inString.indexOf(38, serviceNameIndex + 12);
                            String servicename = ampersandIndex != -1 ? inString.substring(serviceNameIndex + 12, ampersandIndex) : inString.substring(serviceNameIndex + 12);
                            result = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_Sybase_Template", servicename, host, port);
                        }
                    } else if (forwardSlashIndex != -1 && questionMarkIndex == -1) {
                        String port = inString.substring(endOfHostName + 1, forwardSlashIndex);
                        String servicename = inString.substring(forwardSlashIndex + 1);
                        result = servicename == null | servicename.trim().length() == 0 ? localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_Sybase_No_SID_Template", host, port) : localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_Sybase_Template", servicename, host, port);
                    } else if (forwardSlashIndex != -1 && questionMarkIndex != -1) {
                        String port = inString.substring(endOfHostName + 1, forwardSlashIndex);
                        String servicename = inString.substring(forwardSlashIndex + 1, questionMarkIndex);
                        result = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_Sybase_Template", servicename, host, port);
                    }
                } else {
                    result = localizer.IStringLocalizer_getLocalizedString("Agent_SQL_Backend_Sybase_Default_Template");
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                result = localizer.IStringLocalizer_getLocalizedString("Agent_SQL_Backend_Sybase_Default_Template");
            }
            return result;
        }
    }

    private static class TibcoAndWebmethodsFormatter
    implements IDBNameFormatter {
        private final String ORACLE = "oracle";
        private final String DB2 = "db2";
        private final String SQLSERVER = "sqlserver";
        private final String SYBASE = "sybase";
        private final String SERVICENAME_PARM = "servicename";
        private final String SID_PARM = "sid";
        private final String DATABASENAME_PARM = "databasename";
        private final String LOCATIONNAME_PARM = "locationname";
        private boolean isTibco = true;

        public TibcoAndWebmethodsFormatter(boolean isTibco) {
            this.isTibco = isTibco;
        }

        @Override
        public String format(String inString, IStringLocalizer localizer) {
            String databaseVendor = null;
            String host = null;
            String port = null;
            String databaseName = null;
            if (inString != null) {
                StringTokenizer st = new StringTokenizer(inString, ":");
                if (st.countTokens() < 3) {
                    return inString;
                }
                databaseVendor = st.nextToken();
                if (databaseVendor.equalsIgnoreCase("oracle")) {
                    databaseVendor = "Oracle";
                } else if (databaseVendor.equalsIgnoreCase("db2")) {
                    databaseVendor = "Db2";
                } else if (databaseVendor.equalsIgnoreCase("sqlserver")) {
                    databaseVendor = "SqlServer";
                } else if (this.isTibco && databaseVendor.equalsIgnoreCase("sybase")) {
                    databaseVendor = "Sybase";
                } else {
                    return inString;
                }
                host = st.nextToken();
                if (!host.startsWith("//") || host.length() <= 2) {
                    return inString;
                }
                host = host.substring(2);
                String remainingString = st.nextToken();
                int portEnd = remainingString.indexOf(59);
                if (portEnd > 0) {
                    port = remainingString.substring(0, portEnd);
                    StringTokenizer strT = new StringTokenizer(remainingString.substring(portEnd), ";");
                    String keyValue = null;
                    String parmName = null;
                    while (strT.hasMoreTokens()) {
                        keyValue = strT.nextToken();
                        int equalsIndex = keyValue.indexOf(61);
                        if (equalsIndex <= 0 || keyValue.length() <= equalsIndex + 1) continue;
                        parmName = keyValue.substring(0, equalsIndex);
                        if (databaseVendor.equalsIgnoreCase("oracle")) {
                            if (!parmName.equalsIgnoreCase("servicename") && !parmName.equalsIgnoreCase("sid")) continue;
                            databaseName = keyValue.substring(equalsIndex + 1);
                        } else if (databaseVendor.equalsIgnoreCase("db2")) {
                            if (!parmName.equalsIgnoreCase("databasename") && !parmName.equalsIgnoreCase("locationname")) continue;
                            databaseName = keyValue.substring(equalsIndex + 1);
                        } else {
                            if (!parmName.equalsIgnoreCase("databasename")) continue;
                            databaseName = keyValue.substring(equalsIndex + 1);
                        }
                        break;
                    }
                } else if (portEnd == -1) {
                    port = remainingString;
                } else {
                    return inString;
                }
                if (this.isTibco) {
                    return databaseName != null ? localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_Tibco_Full_Template", databaseName, host, port, databaseVendor) : localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_Tibco_Template_NoDatabasename", host, port, databaseVendor);
                }
                return databaseName != null ? localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_WebMethods_Full_Template", databaseName, host, port, databaseVendor) : localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SQL_Backend_WebMethods_Template_NoDatabasename", host, port, databaseVendor);
            }
            return inString;
        }
    }

    private static class URLParseInfo {
        String vendor;
        int infoPastVendorStart;

        URLParseInfo(String dbVendor, int theRest) {
            this.vendor = dbVendor;
            this.infoPastVendorStart = theRest;
        }
    }
}

