/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class ArcHandler {
    public static final double kDegreeToRadianRatio = Math.PI / 180;
    public static final double kRadianToDegreeRatio = 57.29577951308232;
    Rectangle fArcBounds;

    public ArcHandler(Rectangle arcBounds) {
        this.fArcBounds = arcBounds;
    }

    public ArcHandler(int x1, int y1, int width, int height) {
        this(new Rectangle(x1, y1, width, height));
    }

    public ArcHandler(int width, int height) {
        this(0, 0, width, height);
    }

    public ArcHandler(Point center, int radius) {
        this(center.x - radius, center.y - radius, 2 * radius, 2 * radius);
    }

    public void drawArc(Graphics g, int startAngle, int numDegrees) {
        g.drawArc(this.fArcBounds.x, this.fArcBounds.y, this.fArcBounds.width, this.fArcBounds.height, startAngle, numDegrees);
    }

    public void fillArc(Graphics g, int startAngle, int numDegrees) {
        g.fillArc(this.fArcBounds.x, this.fArcBounds.y, this.fArcBounds.width, this.fArcBounds.height, startAngle, numDegrees);
    }

    public Point getPointAt(double atDegree, double distance) {
        double atRadian = atDegree * (Math.PI / 180);
        Point p = new Point();
        p.x = this.fArcBounds.x + (int)((double)this.fArcBounds.width / 2.0 * (1.0 + distance * Math.cos(atRadian)));
        p.y = this.fArcBounds.y + (int)((double)this.fArcBounds.height / 2.0 * (1.0 - distance * Math.sin(atRadian)));
        return p;
    }
}

