/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncFrontendTracer;
import com.wily.introscope.agent.async.AsyncTransactionContext;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class AsyncFrontendEndTracer
extends AsyncFrontendTracer {
    protected final IModuleFeedbackChannel feedback;
    protected static Module module = new Module("AsyncFrontendEndTracer");
    protected final AsyncVirtualStack asyncStack;
    private final IAgent agent;

    public AsyncFrontendEndTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.feedback = agent.IAgent_getModuleFeedback();
        this.asyncStack = AsyncVirtualStack.getInstance(agent);
        this.agent = agent;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        AsyncTransactionContext.AsyncComponentInvocation frontendInfo = this.asyncStack.getAsyncFrontendInfoFromTransactionCache(data);
        if (frontendInfo == null) {
            if (this.feedback.isDebugEnabled(module)) {
                this.feedback.debug(module, "Failed to find correlated frontend info. " + data.getProbeInformation().getProbeIdentification().getProbeClassName() + "." + data.getProbeInformation().getProbeIdentification().getProbeMethodName());
            }
        } else {
            this.asyncStack.pop(frontendInfo, data, this);
        }
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

