/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncThreadFragmentTracer;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.async.IAsyncMetricProvider;
import com.wily.introscope.agent.async.IAsyncMetricUpdater;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.ICounterRepository;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.hc2.AverageMetricGathererWrapper;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.properties.AttributeListing;

public abstract class AsyncFrontendTracer
extends AsyncThreadFragmentTracer
implements IAsyncMetricProvider,
IAsyncMetricUpdater {
    public static final int kConcurrentMetricIndex = 0;
    public static final int kTimerMetricIndex = 1;
    public static final int kPerIntervalMetricIndex = 2;
    public static final int kStallMetricIndex = 3;
    public static final int kErrorMetricIndex = 4;

    public AsyncFrontendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public AsyncVirtualStack.AsyncMetricHolder[] constructAsyncComponentMetrics(String componentName) {
        IRepository concurrentSds = null;
        IRepository timerSds = null;
        IRepository stallSds = null;
        IRepository errorsSds = null;
        IRepository perIntervalSds = null;
        AsyncVirtualStack.AsyncMetricHolder[] metrics = new AsyncVirtualStack.AsyncMetricHolder[5];
        AgentMetric[] concurrentMetric = this.createFrontendConcurrentInvocationMetric(this.getConcurrentInvocationMetricName(componentName));
        concurrentSds = this.getSharedRepositoryNoSharedStructure(false);
        metrics[0] = new AsyncVirtualStack.AsyncMetricHolder(concurrentSds, concurrentMetric);
        AgentMetric[] timerMetric = this.createFrontendTimerMetric(this.getTimerMetricName(componentName));
        timerSds = this.getSharedRepository(AverageMetricGathererWrapper.getFactory(true), this.fNumberOfStripes);
        metrics[1] = new AsyncVirtualStack.AsyncMetricHolder(timerSds, timerMetric);
        AgentMetric[] perIntervalMetric = this.createFrontendPerIntervalMetric(this.getPerIntervalMetricName(componentName));
        perIntervalSds = this.getSharedRepository(true, this.fNumberOfStripes);
        metrics[2] = new AsyncVirtualStack.AsyncMetricHolder(perIntervalSds, perIntervalMetric);
        AgentMetric[] stallMetric = this.createFrontendStallsMetric(this.getStallsMetricName(componentName));
        stallSds = this.getSharedRepositoryNoSharedStructure(false);
        metrics[3] = new AsyncVirtualStack.AsyncMetricHolder(stallSds, stallMetric);
        AgentMetric[] errorMetric = this.createFrontendErrorsMetric(this.getErrorsMetricName(componentName));
        errorsSds = this.getSharedRepositoryNoSharedStructure(false);
        metrics[4] = new AsyncVirtualStack.AsyncMetricHolder(errorsSds, errorMetric);
        return metrics;
    }

    @Override
    public void updateAsyncComponentMetricsAtStart(AsyncVirtualStack.AsyncMetricHolder[] metrics, long startTime) {
        ICounterRepository cin = (ICounterRepository)metrics[0].sds;
        if (cin != null) {
            cin.increase(startTime);
        }
    }

    @Override
    public void updateAsyncComponentMetricsAtStall(AsyncVirtualStack.AsyncMetricHolder[] metrics, long time) {
        IRepository sds;
        AsyncVirtualStack.AsyncMetricHolder holder = metrics[3];
        if (holder != null && (sds = holder.sds) instanceof ICounterRepository) {
            ICounterRepository cr = (ICounterRepository)sds;
            cr.increase(time);
        }
    }

    @Override
    public void updateAsyncComponentMetricsAtError(AsyncVirtualStack.AsyncMetricHolder[] metrics, long time) {
        IRepository sds;
        AsyncVirtualStack.AsyncMetricHolder holder = metrics[4];
        if (holder != null && (sds = holder.sds) instanceof ICounterRepository) {
            ICounterRepository cr = (ICounterRepository)sds;
            cr.increase(time);
        }
    }

    @Override
    public void updateAsyncComponentMetricsAtAbort(AsyncVirtualStack.AsyncMetricHolder[] metrics, long time, boolean didStall) {
        ICounterRepository cin = (ICounterRepository)metrics[0].sds;
        if (cin != null) {
            cin.decrease(time);
        }
        if (didStall && (cin = (ICounterRepository)metrics[3].sds) != null) {
            cin.decrease(time);
        }
    }

    @Override
    public void updateAsyncComponentMetricsAtEnd(AsyncVirtualStack.AsyncMetricHolder[] metrics, long startTime, long endTime, boolean didStall) {
        IRepository rep;
        ICounterRepository cin = (ICounterRepository)metrics[0].sds;
        long elapsed = endTime - startTime;
        if (cin != null) {
            cin.decrease(endTime);
        }
        if ((rep = metrics[1].sds) != null) {
            rep.update((IUpdater)updater, elapsed, endTime, 0);
        }
        if ((rep = metrics[2].sds) != null) {
            rep.update(increaser, 0L, endTime, 0);
        }
        if (didStall && (cin = (ICounterRepository)metrics[3].sds) != null) {
            cin.decrease(endTime);
        }
    }
}

