/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.metric.calculator;

import com.wily.introscope.agent.metric.calculator.CalculatorService;
import com.wily.introscope.agent.metric.calculator.MetricPatternUtils;
import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.gatherer.GathererFactory;

public abstract class Operation {
    protected String resultMetricPattern;
    protected Object[] resultTokens;
    protected CalculatorService service;

    public Operation setResultMetric(String metric) {
        this.resultMetricPattern = metric;
        this.resultTokens = MetricPatternUtils.parseMetricPattern(this.resultMetricPattern);
        return this;
    }

    public Operation setService(CalculatorService service) {
        this.service = service;
        return this;
    }

    public abstract IMetricDataValue invoke(String[] var1);

    protected void recordResult(String[] vars, IMetricDataValue value) {
        if (this.resultTokens == null || this.service == null) {
            return;
        }
        String metric = MetricPatternUtils.resolveMetric(this.resultTokens, vars);
        IMetricDataValue oldvalue = this.service.getOutputMetric(metric);
        IMetricDataValue result = value;
        if (oldvalue != null) {
            try {
                result = GathererFactory.aggregateByTime((IMetricDataValue)oldvalue, (IMetricDataValue)value);
            }
            catch (IncompatibleTypesException incompatibleTypesException) {
                return;
            }
        }
        this.service.putOutputMetric(metric, result);
    }
}

