/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.handlers.axis;

import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.handlers.WsdmGenericHandler;
import com.wily.powerpack.webservices.handlers.WsdmLogger;
import com.wily.powerpack.webservices.handlers.WsdmMessageContext;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.SOAPPart;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WsdmJaxRpcHandler
extends WsdmGenericHandler {
    private WsdmLogger log = new WsdmLogger();
    private static final String MC_HTTP_SERVLETREQUEST = "transport.http.servletRequest";
    private static final String MC_TRANSPORT_URL = "transport.url";
    protected static final String XML_ENCODING = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    private void processCorrelationId(WsdmMessageContext wsdmMessageContext, SOAPEnvelope envelope, MimeHeaders httpheader) throws SOAPException {
        int observationType = wsdmMessageContext.getObservationType();
        boolean correlationIdFound = false;
        if (this.getObservationType() == 1) {
            if (WSMUtils.correlationHTTPReadEnabled()) {
                if (httpheader != null) {
                    String[] corid = httpheader.getHeader("CorID");
                    if (corid != null && corid.length > 0) {
                        if (corid.length > 1) {
                            this.log.info("WsdmJaxRpcHandler:processCorrelationId: multiple Correlation ID values found, the first value will be used");
                        }
                        correlationIdFound = true;
                        String correlationId = corid[0];
                        new CorrelationId(correlationId);
                        wsdmMessageContext.setCorrelationId(correlationId);
                    }
                } else {
                    this.log.debug("WsdmJaxRpcHandler:processCorrelationId: Correlation ID over HTTP enabled but HTTP header is not available");
                }
            }
            if (WSMUtils.correlationSOAPReadEnabled() && !correlationIdFound) {
                if (envelope == null) {
                    this.log.debug("WsdmJaxRpcHandler:processCorrelationId: Correlation ID over SOAP enabled but SOAP header is not available");
                    return;
                }
                Name attrName = envelope.createName("CorID");
                SOAPHeader header = envelope.getHeader();
                if (header != null) {
                    Iterator it = header.getChildElements();
                    while (it.hasNext()) {
                        SOAPHeaderElement headerElement;
                        String headerName;
                        Object ChildElement = it.next();
                        if (!(ChildElement instanceof javax.xml.soap.SOAPHeaderElement) || !(headerName = (headerElement = (SOAPHeaderElement)ChildElement).getName()).equals("WSCorIDSOAPHeader")) continue;
                        correlationIdFound = true;
                        String correlationId = headerElement.getAttributeValue(attrName);
                        new CorrelationId(correlationId);
                        wsdmMessageContext.setCorrelationId(correlationId);
                        header.removeChild((Node)headerElement);
                        break;
                    }
                }
            }
            if (!correlationIdFound) {
                new CorrelationId();
            }
            return;
        }
        if (observationType == 2) {
            CorrelationId corrId = new CorrelationId();
            corrId.incrementSequenceId();
            this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
            this.log.debug("WsdmJaxrpcHandler wsdmHandleRequest::operationname=" + wsdmMessageContext.getOperationName() + " operationnamespace=" + wsdmMessageContext.getOperationNameSpace());
            this.mapDependency();
            String correlationString = corrId.getCurrentOutgoingCorrelationIdStrippedForHeader();
            this.processClientCorrelationId(wsdmMessageContext, envelope, correlationString, httpheader);
        } else if (observationType != 2) {
            this.log.error("processCorrelationId: observationType is not set");
        }
    }

    private void processClientCorrelationId(WsdmMessageContext wsdmMessageContext, SOAPEnvelope envelope, String correlationString, MimeHeaders httpheader) throws SOAPException {
        wsdmMessageContext.setCorrelationId(correlationString);
        if (WSMUtils.correlationSOAPInsertionEnabled()) {
            if (envelope == null) {
                this.log.debug("WsdmJaxRpcHandler:processCorrelationId: Correlation ID over SOAP enabled but SOAP envolope is not available");
            } else {
                this.processSOAPClientCorrelationId(envelope, correlationString);
            }
        }
        if (WSMUtils.correlationHTTPInsertionEnabled()) {
            if (httpheader == null) {
                this.log.debug("WsdmJaxRpcHandler:processCorrelationId: Correlation ID over HTTP enabled but HTTP envolope is not available");
            } else {
                this.processHTTPClientCorrelationId(httpheader, correlationString);
            }
        }
    }

    private void processHTTPClientCorrelationId(MimeHeaders httpheader, String correlationString) {
        String[] corid = httpheader.getHeader("CorID");
        if (corid == null || corid.length == 0) {
            httpheader.addHeader("CorID", correlationString);
        } else {
            httpheader.setHeader("CorID", correlationString);
        }
    }

    private void processSOAPClientCorrelationId(SOAPEnvelope envelope, String correlationString) throws SOAPException {
        Name attrName = envelope.createName("CorID");
        Element element = XMLUtils.StringToElement((String)"http://www.ca.com/apm", (String)"WSCorIDSOAPHeader", (String)"");
        SOAPHeaderElement headerElement = new SOAPHeaderElement(element);
        headerElement.setPrefix("");
        headerElement.addAttribute(attrName, correlationString);
        ((org.apache.axis.message.SOAPEnvelope)envelope).addHeader(headerElement);
    }

    public boolean handleFault(MessageContext context) {
        boolean ret = true;
        try {
            ret = this.wsdmHandleFault(context);
        }
        catch (Throwable e) {
            this.log.error("WsdmJaxRpcHandler::handleFault " + e);
            if (this.log.isDebugLogging().booleanValue()) {
                this.log.debug("WsdmJaxRpcHandler::handleFault " + WSMUtils.dumpStackTrace(e));
            }
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean handleRequest(MessageContext context) {
        boolean ret = super.handleRequest(context);
        try {
            ret = this.wsdmHandleRequest(context);
        }
        catch (Throwable e) {
            this.log.error("WsdmJaxRpcHandler::handleRequest " + e);
            if (this.log.isDebugLogging().booleanValue()) {
                this.log.debug("WsdmJaxRpcHandler::handleRequest " + WSMUtils.dumpStackTrace(e));
            }
            ret = true;
        }
        return ret;
    }

    public boolean handleResponse(MessageContext context) {
        boolean ret = true;
        try {
            this.wsdmHandleResponse(context);
        }
        catch (Throwable e) {
            this.log.error("WsdmJaxRpcHandler::handleResponse " + e);
            if (this.log.isDebugLogging().booleanValue()) {
                this.log.debug("WsdmJaxRpcHandler::handleResponse " + WSMUtils.dumpStackTrace(e));
            }
            ret = true;
        }
        return ret;
    }

    public void init(HandlerInfo config) {
        block2: {
            try {
                this.wsdmInit(config);
            }
            catch (Throwable e) {
                this.log.error("WsdmJaxRpcHandler::init " + e);
                if (!this.log.isDebugLogging().booleanValue()) break block2;
                this.log.debug("WsdmJaxRpcHandler::init " + WSMUtils.dumpStackTrace(e));
            }
        }
    }

    private void sendOutFaultInfo(AxisFault fault, WsdmMessageContext context) {
        if (fault == null) {
            return;
        }
        Element[] arr = fault.getFaultDetails();
        String[] sarr = null;
        if (arr != null && arr.length > 0) {
            sarr = new String[arr.length];
            int x = 0;
            while (x < arr.length) {
                Element el = arr[x];
                String localName = el.getNodeName();
                if (!(localName != null && localName.length() != 0 || (localName = el.getLocalName()) != null && localName.length() != 0 || (localName = el.getTagName()) != null && localName.length() != 0)) {
                    localName = "";
                }
                Node fc = el.getFirstChild();
                String nodeValue = "";
                if (fc != null) {
                    nodeValue = fc.getNodeValue();
                }
                if (el != null) {
                    sarr[x] = String.valueOf(localName) + ":" + nodeValue;
                }
                ++x;
            }
        }
        this.wsdmHandlerUtil.spoolFault(context, fault.getFaultActor(), fault.getFaultCode() == null ? "" : fault.getFaultCode().toString(), fault.getFaultString(), sarr);
    }

    private void sendOutSOAPFaultInfo(SOAPFault fault, WsdmMessageContext context) {
        if (fault == null) {
            return;
        }
        AxisFault afault = fault.getFault();
        if (afault != null) {
            this.sendOutFaultInfo(afault, context);
        }
    }

    private boolean wsdmHandleFault(MessageContext context) {
        block7: {
            if (this.getObservationType() == 2) {
                int correlationCount = new CorrelationId().decrementCorrelationCount();
                this.log.debug("WsdmJaxRpcHandler wsdmHandleFault correlationCount=" + correlationCount);
            }
            WsdmMessageContext wsdmMessageContext = (WsdmMessageContext)context.getProperty("WSDM_TRANSID");
            this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
            Message sm = ((org.apache.axis.MessageContext)context).getResponseMessage();
            try {
                if (sm != null) {
                    javax.xml.soap.SOAPBody sb;
                    org.apache.axis.message.SOAPEnvelope se;
                    wsdmMessageContext.setResponseSOAPMessage((SOAPMessage)sm);
                    SOAPPart sp = (SOAPPart)sm.getSOAPPart();
                    if (sp != null && (se = (org.apache.axis.message.SOAPEnvelope)sp.getCurrentMessage()) != null && (sb = se.getBody()) != null) {
                        javax.xml.soap.SOAPFault fault = sb.getFault();
                        this.sendOutSOAPFaultInfo((SOAPFault)fault, wsdmMessageContext);
                    }
                }
            }
            catch (ClassCastException c) {
                this.log.error("wsdmHandleFault " + c);
                if (this.log.isDebugLogging().booleanValue()) {
                    this.log.debug("wsdmHandleFault " + WSMUtils.dumpStackTrace(c));
                }
            }
            catch (SOAPException j) {
                this.log.error("wsdmHandleFault " + (Object)((Object)j));
                if (!this.log.isDebugLogging().booleanValue()) break block7;
                this.log.debug("wsdmHandleFault " + WSMUtils.dumpStackTrace(j));
            }
        }
        return true;
    }

    private boolean wsdmHandleRequest(MessageContext context) {
        block40: {
            MimeHeaders hd;
            SOAPEnvelope se;
            WsdmMessageContext wsdmMessageContext;
            block39: {
                ServiceDesc servDesc;
                OperationDesc opDesc;
                javax.xml.soap.SOAPBody sb;
                SOAPMessage soapMess;
                String operationNamespace;
                block36: {
                    wsdmMessageContext = new WsdmMessageContext(this.getObservationType());
                    operationNamespace = "";
                    if (this.log.isDebugLogging().booleanValue()) {
                        this.log.debug("WsdmJaxRpcHandler::wsdmHandleRequest");
                    }
                    HttpServletRequest req = null;
                    if (context.containsProperty(MC_HTTP_SERVLETREQUEST)) {
                        req = (HttpServletRequest)context.getProperty(MC_HTTP_SERVLETREQUEST);
                    }
                    String tempPort = null;
                    if (req == null) {
                        if (context.containsProperty(MC_TRANSPORT_URL)) {
                            tempPort = (String)context.getProperty(MC_TRANSPORT_URL);
                        }
                        if ((tempPort == null || tempPort.equals("")) && this.log.isInfoLogging().booleanValue()) {
                            this.log.info("WsdmJaxRpcHandler::handleRequest: unable to get HttpServletRequest");
                        }
                        wsdmMessageContext.setRequestorLocation(this.wsdmHandlerUtil.getObserverIp());
                    }
                    if (req != null) {
                        if (req.getServerPort() == 80) {
                            wsdmMessageContext.setPortName("http://" + req.getServerName() + req.getRequestURI());
                        } else {
                            wsdmMessageContext.setPortName("http://" + req.getServerName() + ":" + req.getServerPort() + req.getRequestURI());
                        }
                        wsdmMessageContext.setRequestorLocation(req.getRemoteAddr());
                    } else if (context.containsProperty("transport.jms.Destination")) {
                        wsdmMessageContext.setPortName((String)context.getProperty("transport.jms.Destination"));
                    } else {
                        wsdmMessageContext.setPortName(tempPort);
                    }
                    soapMess = ((SOAPMessageContext)context).getMessage();
                    se = null;
                    javax.xml.soap.SOAPPart sp = null;
                    sb = null;
                    try {
                        if (soapMess != null) {
                            sp = soapMess.getSOAPPart();
                            if (sp != null) {
                                se = sp.getEnvelope();
                            }
                        } else {
                            this.log.error("WsdmJaxRpcHandler::wsdmHandleRequest: SoapMess is null");
                        }
                    }
                    catch (SOAPException e) {
                        this.log.error("WsdmJaxRpcHandler::wsdmHandleRequest: failed to process correlation Id: " + (Object)((Object)e));
                        if (!this.log.isDebugLogging().booleanValue()) break block36;
                        this.log.debug("WsdmJaxRpcHandler::wsdmHandleRequest: " + WSMUtils.dumpStackTrace(e));
                    }
                }
                if ((opDesc = ((org.apache.axis.MessageContext)context).getOperation()) != null) {
                    wsdmMessageContext.setOperationName(opDesc.getName());
                    QName opqname = opDesc.getElementQName();
                    if (opqname != null) {
                        if (wsdmMessageContext.getOperationName() == null || wsdmMessageContext.getOperationName().equals("")) {
                            wsdmMessageContext.setOperationName(opqname.getLocalPart());
                        }
                        operationNamespace = opqname.getNamespaceURI();
                    }
                }
                if (operationNamespace == null || operationNamespace.equals("")) {
                    SOAPBody asb;
                    Iterator iter;
                    block37: {
                        if (se != null) {
                            try {
                                sb = se.getBody();
                            }
                            catch (SOAPException soape) {
                                this.log.error("WsdmJaxRpcHandler::wsdmHandleRequest: " + (Object)((Object)soape));
                                if (!this.log.isDebugLogging().booleanValue()) break block37;
                                this.log.debug("WsdmJaxRpcHandler::wsdmHandleRequest: " + WSMUtils.dumpStackTrace(soape));
                            }
                        }
                    }
                    if (sb != null && (iter = (asb = (SOAPBody)sb).getChildElements()) != null) {
                        while (iter.hasNext()) {
                            Object element = iter.next();
                            if (!(element instanceof MessageElement)) continue;
                            MessageElement me = (MessageElement)element;
                            operationNamespace = me.getNamespaceURI();
                            break;
                        }
                    }
                }
                if (operationNamespace == null || operationNamespace.equals("")) {
                    String inputString = "";
                    if (se != null) {
                        block38: {
                            try {
                                sb = se.getBody();
                            }
                            catch (SOAPException soape) {
                                this.log.error("WsdmJaxRpcHandler::wsdmHandleRequest: " + (Object)((Object)soape));
                                if (!this.log.isDebugLogging().booleanValue()) break block38;
                                this.log.debug("WsdmJaxRpcHandler::wsdmHandleRequest: " + WSMUtils.dumpStackTrace(soape));
                            }
                        }
                        if (sb != null) {
                            inputString = sb.toString();
                        }
                    }
                    operationNamespace = this.getOperationNamespaceFromSoapBody(inputString);
                }
                if ((operationNamespace == null || operationNamespace.equals("")) && opDesc != null && (servDesc = opDesc.getParent()) != null) {
                    operationNamespace = servDesc.getName();
                }
                wsdmMessageContext.setRequestSOAPMessage(soapMess);
                String targetService = ((org.apache.axis.MessageContext)context).getTargetService();
                if (targetService == null || targetService.equals("")) {
                    targetService = wsdmMessageContext.getPortName();
                }
                wsdmMessageContext.setServiceName(targetService);
                if (operationNamespace == null || operationNamespace.equals("")) {
                    operationNamespace = wsdmMessageContext.getPortName();
                }
                wsdmMessageContext.setOperationNameSpace(operationNamespace);
                this.wsdmHandlerUtil.observeRequest(wsdmMessageContext);
                context.setProperty("WSDM_TRANSID", (Object)wsdmMessageContext);
                hd = soapMess.getMimeHeaders();
                if (se != null || hd != null) break block39;
                this.log.error("WsdmJaxRpcHandler::wsdmHandleRequest: both SOAP and HTTP headers are not available for correlation ID");
                return false;
            }
            try {
                this.processCorrelationId(wsdmMessageContext, se, hd);
            }
            catch (SOAPException e) {
                this.log.error("WsdmJaxRpcHandler::wsdmHandleRequest: failed to process correlation Id: " + (Object)((Object)e));
                if (!this.log.isDebugLogging().booleanValue()) break block40;
                this.log.debug("WsdmJaxRpcHandler::wsdmHandleRequest: " + WSMUtils.dumpStackTrace(e));
            }
        }
        return true;
    }

    @Override
    protected WsdmMessageContext wsdmHandleResponse(MessageContext context) {
        SOAPMessage soapMess;
        WsdmMessageContext wsdmMessageContext;
        block4: {
            if (this.getObservationType() == 2) {
                int correlationCount = new CorrelationId().decrementCorrelationCount();
                this.log.debug("WsdmJaxRpcHandler wsdmHandleResponse correlationCount=" + correlationCount);
            }
            wsdmMessageContext = this.setupTransactionId(context);
            soapMess = ((SOAPMessageContext)context).getMessage();
            try {
                javax.xml.soap.SOAPFault flt;
                javax.xml.soap.SOAPBody sb;
                SOAPEnvelope se;
                javax.xml.soap.SOAPPart sp;
                if (soapMess != null && (sp = soapMess.getSOAPPart()) != null && (se = sp.getEnvelope()) != null && (sb = se.getBody()) != null && (flt = sb.getFault()) != null) {
                    this.sendOutSOAPFaultInfo((SOAPFault)flt, wsdmMessageContext);
                    return wsdmMessageContext;
                }
            }
            catch (Exception e) {
                this.log.error("WsdmJaxRpcHandler::wsdmHandleResponse: " + e);
                if (!this.log.isDebugLogging().booleanValue()) break block4;
                this.log.debug("WsdmJaxRpcHandler::wsdmHandleRequest: " + WSMUtils.dumpStackTrace(e));
            }
        }
        wsdmMessageContext.setResponseSOAPMessage(soapMess);
        this.wsdmHandlerUtil.observeResponse(wsdmMessageContext);
        return wsdmMessageContext;
    }

    @Override
    public boolean hasSOAPHeader(MessageContext context, String headerName) {
        boolean headerFound;
        block4: {
            SOAPEnvelope envelope = null;
            javax.xml.soap.SOAPPart sp = null;
            headerFound = false;
            SOAPMessage soapMess = ((SOAPMessageContext)context).getMessage();
            try {
                if (soapMess != null) {
                    SOAPHeader header;
                    sp = soapMess.getSOAPPart();
                    if (sp == null || (header = (envelope = sp.getEnvelope()).getHeader()) == null) break block4;
                    Iterator it = header.getChildElements();
                    while (it.hasNext()) {
                        SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                        String hdrName = headerElement.getName();
                        if (!hdrName.equals(headerName)) continue;
                        headerFound = true;
                        break block4;
                    }
                    break block4;
                }
                this.log.error("WsdmJaxRpcHandler::hasSOAPHeader: SoapMess is null");
            }
            catch (SOAPException e) {
                this.log.error("WsdmJaxRpcHandler::hasSOAPHeader: failed to process headers: " + (Object)((Object)e));
                if (!this.log.isDebugLogging().booleanValue()) break block4;
                this.log.debug("WsdmJaxRpcHandler::hasSOAPHeader: " + WSMUtils.dumpStackTrace(e));
            }
        }
        return headerFound;
    }

    @Override
    public void addSOAPHeader(MessageContext context, String headerName) {
        block6: {
            SOAPEnvelope envelope = null;
            javax.xml.soap.SOAPPart sp = null;
            SOAPMessage soapMess = ((SOAPMessageContext)context).getMessage();
            try {
                if (soapMess != null) {
                    sp = soapMess.getSOAPPart();
                    if (sp != null) {
                        boolean headerFound = false;
                        headerFound = this.hasSOAPHeader(context, headerName);
                        if (!headerFound) {
                            envelope = sp.getEnvelope();
                            Element element = XMLUtils.StringToElement((String)"http://www.ca.com/apm", (String)headerName, (String)"WSDM_TRUE");
                            SOAPHeaderElement headerElement = new SOAPHeaderElement(element);
                            ((org.apache.axis.message.SOAPEnvelope)envelope).addHeader(headerElement);
                        }
                    }
                } else {
                    this.log.error("WsdmJaxRpcHandler::addSOAPHeader: SoapMess is null");
                }
            }
            catch (SOAPException e) {
                this.log.error("WsdmJaxRpcHandler::addSOAPHeader: " + (Object)((Object)e));
                if (!this.log.isDebugLogging().booleanValue()) break block6;
                this.log.debug("WsdmJaxRpcHandler::addSOAPHeader: " + WSMUtils.dumpStackTrace(e));
            }
        }
    }
}

