/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.properties.KUICommonStringsKeys;
import com.wily.ui.IGenericServices;
import com.wily.ui.KWilyUserInterfaceConstants;
import com.wily.ui.MultiMessagePane;
import com.wily.ui.WilyUIUtilities;
import com.wily.ui.swing.ExtendedJFrame;
import com.wily.util.text.ILocalizableMessage;
import com.wily.wilyassert.SwingAssertion;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MultiMessageFrame
extends ExtendedJFrame
implements KUICommonStringsKeys,
KWilyUserInterfaceConstants {
    private static final long serialVersionUID = 6863995529460991607L;
    private MultiMessagePane fMultiMessagePane;
    private JCheckBox fBringToFrontOptionCheckbox;
    private JButton fCloseButton;
    private JButton fEmptyButton;
    private static final int kMultiMessageFramePreferredWidth = 640;
    private static final int kMultiMessageFramePreferredHeight = 400;
    private static final int kMultiMessageFrameMinimumWidth = 400;
    private static final int kMultiMessageFrameMinimumHeight = 50;

    public MultiMessageFrame(IGenericServices genericServices, ILocalizableMessage singularMessageTypeName, ILocalizableMessage pluralMessageTypeName, String title, String iconKey) {
        this(genericServices, new MultiMessagePane(genericServices.IGenericServices_getStringLocalizer(), singularMessageTypeName, pluralMessageTypeName), title, iconKey);
    }

    public MultiMessageFrame(IGenericServices genericServices, ILocalizableMessage singularMessageTypeName, ILocalizableMessage pluralMessageTypeName, int maxNumMessages, ILocalizableMessage overflowMessage, String title, String iconKey) {
        this(genericServices, new MultiMessagePane(genericServices.IGenericServices_getStringLocalizer(), singularMessageTypeName, pluralMessageTypeName, maxNumMessages, overflowMessage), title, iconKey);
    }

    private MultiMessageFrame(IGenericServices genericServices, MultiMessagePane multiMessagePane, String title, String iconKey) {
        super(genericServices, title, iconKey);
        this.initUI(multiMessagePane);
    }

    private void initUI(MultiMessagePane multiMessagePane) {
        this.fMultiMessagePane = multiMessagePane;
        JPanel contentPane = new JPanel();
        contentPane.setPreferredSize(new Dimension(640, 400));
        contentPane.setMinimumSize(new Dimension(400, 50));
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setBorder(kStandardDialogBorder);
        contentPane.add(this.fMultiMessagePane);
        this.fBringToFrontOptionCheckbox = new JCheckBox(this.getStringLocalizer().IStringLocalizer_getLocalizedString("MultiMessageFrameBringToFrontOnNewMessageOptionTitle"), true);
        this.fEmptyButton = new JButton(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Empty"));
        WilyUIUtilities.setLocalizedMnemonic(this.fEmptyButton, "Empty_Mnemonic", this.getStringLocalizer());
        this.fEmptyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MultiMessageFrame.this.flushMessages();
            }
        });
        this.fEmptyButton.setEnabled(false);
        this.fMultiMessagePane.addMessagePaneContainerListener(new EmptyPaneListener());
        this.fCloseButton = new JButton();
        WilyUIUtilities.setLocalizedMnemonic(this.fCloseButton, "Close_Mnemonic", this.getStringLocalizer());
        WilyUIUtilities.setActionForButton(this.getMonitoredReportingCloseAction(this.fCloseButton), this.fCloseButton, true);
        JPanel checkboxAndButtonPanel = new JPanel();
        this.getRootPane().setDefaultButton(this.fCloseButton);
        checkboxAndButtonPanel.setLayout(new BoxLayout(checkboxAndButtonPanel, 0));
        checkboxAndButtonPanel.add(this.fBringToFrontOptionCheckbox);
        checkboxAndButtonPanel.add(Box.createHorizontalGlue());
        checkboxAndButtonPanel.add(this.fEmptyButton);
        checkboxAndButtonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        checkboxAndButtonPanel.add(this.fCloseButton);
        checkboxAndButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        contentPane.add(checkboxAndButtonPanel);
        this.setContentPane(contentPane);
    }

    public void show() {
        WilyUIUtilities.centerWindowOnScreen(this);
        super.show();
    }

    public boolean getBringToFrontOnNewMessage() {
        return this.fBringToFrontOptionCheckbox.isSelected();
    }

    public void setBringToFrontOnNewMessage(boolean flip) {
        this.fBringToFrontOptionCheckbox.setSelected(flip);
    }

    public void addMessageSync(ILocalizableMessage message, int messageType) {
        SwingAssertion.assertSwingSafe(this);
        Toolkit.getDefaultToolkit().beep();
        this.fMultiMessagePane.addMessage(message, messageType);
        this.fMultiMessagePane.revalidate();
        this.ensurePackedAndShown();
        if (this.getBringToFrontOnNewMessage()) {
            this.forceToFrontWithFocus();
        }
    }

    public void addMessageAsync(final ILocalizableMessage message, final int messageType) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MultiMessageFrame.this.addMessageSync(message, messageType);
            }
        });
    }

    private void flushMessages() {
        if (this.fMultiMessagePane != null) {
            this.fMultiMessagePane.flushMessages();
        }
    }

    protected void doStandardClose() {
        this.setVisible(false);
    }

    private class EmptyPaneListener
    extends ContainerAdapter {
        private EmptyPaneListener() {
        }

        public void componentAdded(ContainerEvent event) {
            MultiMessageFrame.this.fEmptyButton.setEnabled(MultiMessageFrame.this.fMultiMessagePane.getNumMessages() != 0);
        }

        public void componentRemoved(ContainerEvent event) {
            MultiMessageFrame.this.fEmptyButton.setEnabled(MultiMessageFrame.this.fMultiMessagePane.getNumMessages() != 0);
        }
    }
}

