/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.mutate;

import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.mutate.IClassMutator;
import com.wily.diagnos.cmp.transform.SubstituteClassTransformation;
import com.wily.diagnos.personality.java.classfile.DGClass;
import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import com.wily.diagnos.personality.java.mutate.AJavaMethodMutation;
import com.wily.util.classfile.IModeledMethod;
import com.wily.wilyassert.Assertion;
import java.io.IOException;

public final class SubstituteClassMethodMutation
extends AJavaMethodMutation {
    private final SubstituteClassTransformation fTransform;

    public SubstituteClassMethodMutation(DGCompilerSettings settings, IClassMutator mutator, SubstituteClassTransformation transform, IModeledMethod targetMethod) {
        super(settings, mutator, targetMethod);
        this.fTransform = transform;
    }

    @Override
    protected void doMutate(DGMethod targetMethod) throws DGClassModificationException, IOException {
        DGClass targetClass = targetMethod.getDGClass();
        String className = this.fTransform.getSourceClass().getPackageAndNameString();
        String subclassName = this.fTransform.getReplacementClass().getPackageAndNameString();
        DGConstantPool cp = targetClass.getConstantPool();
        Integer[] cpiClassArray = cp.findAllClassReferences(className);
        Assertion.wilyAssert(cpiClassArray.length != 0);
        Assertion.wilyAssert(!className.equals(targetClass.getClassName().getPackageAndNameString()));
        int cpiSubstituteClass = cp.addClassReferenceIfNecessary(subclassName);
        targetMethod.substituteClassAllocation(cpiClassArray, cpiSubstituteClass);
    }
}

