/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class SocketCFT
implements ClassFileTransformer {
    public static final String AGENT_LOG = "[IntroscopeAgent.Agent] ";
    static String[] socketClassesToModify = new String[]{"java/net/SocketInputStream", "java/net/SocketOutputStream", "java/net/PlainSocketImpl", "java/net/SocketImpl", "java/net/AbstractPlainSocketImpl"};
    ArrayList<String> baseClassesToModify;
    WeakReference<Instrumentation> instObj;
    WilySocketClassModifier modifier = null;
    static ModifiedClassStore store;

    public SocketCFT(Instrumentation instrumentation) throws Exception {
        try {
            this.instObj = new WeakReference<Instrumentation>(instrumentation);
            this.baseClassesToModify = new ArrayList<String>(Arrays.asList(socketClassesToModify));
            this.modifier = new WilySocketClassModifier();
            store = new ModifiedClassStore();
            SocketCFT.logMessage("Socket related ClassFileTransformation applied");
        }
        catch (Exception e) {
            SocketCFT.logMessage("Failed to apply Class transformations for Socket tracing " + e);
            throw e;
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        block5: {
            if (this.baseClassesToModify.contains(className)) {
                this.baseClassesToModify.remove(className);
                try {
                    return this.modifier.modify(className, classfileBuffer);
                }
                catch (Exception e) {
                    SocketCFT.logMessage("Modifier failed to modify Socket class " + className + ". Reason " + e);
                    if (this.baseClassesToModify.size() != 0) break block5;
                    try {
                        ((Instrumentation)this.instObj.get()).removeTransformer(this);
                    }
                    catch (Exception exception) {}
                    SocketCFT.logMessage("Done with Socket Transformations. Removing SocketCFT.. ");
                }
            }
        }
        return null;
    }

    public static boolean isSocketClass(Class cls) {
        return store == null ? false : store.isSocketClass(cls);
    }

    public static void store(String name, byte[] data) throws Exception {
        if (store != null) {
            store.store(name, data);
        }
    }

    public static byte[] retrieve(Class cls) throws Exception {
        if (store != null) {
            return store.retrieve(cls);
        }
        throw new Exception("SocketCFT not initialized! ");
    }

    public static boolean isDynamicSocketClassModificationEnabled() {
        return store != null;
    }

    public static void logMessage(String message) {
        System.out.println(AGENT_LOG + message);
    }

    class ModifiedClassStore {
        private ArrayList<String> socketClassToValidate = new ArrayList<String>(Arrays.asList(socketClassesToModify));
        private volatile Map<String, byte[]> modifiedBytes = new HashMap<String, byte[]>();

        ModifiedClassStore() {
        }

        public boolean isSocketClass(Class cls) {
            if (cls == null) {
                return false;
            }
            String className = cls.getName().replace(".", "/");
            return this.socketClassToValidate.contains(className);
        }

        public boolean isSocketClass(String className) {
            if (className == null) {
                return false;
            }
            className = className.replace(".", "/");
            return this.socketClassToValidate.contains(className);
        }

        public void store(String name, byte[] data) {
            this.modifiedBytes.put(name, data);
        }

        public byte[] retrieve(String className) {
            if (className == null) {
                return null;
            }
            if (this.modifiedBytes.containsKey(className = className.replace(".", "/"))) {
                return this.modifiedBytes.get(className);
            }
            return null;
        }

        public byte[] retrieve(Class cls) {
            String className;
            String string = className = cls != null ? cls.getName() : null;
            if (className == null) {
                return null;
            }
            if (this.modifiedBytes.containsKey(className = className.replace(".", "/"))) {
                return this.modifiedBytes.get(className);
            }
            return null;
        }
    }

    class WilySocketClassModifier {
        ClassLoader customPBCL = this.getClassLoader();
        Class _DGClass = Class.forName("com.wily.diagnos.personality.java.classfile.DGClass", true, this.customPBCL);
        Method _makePublic = this._DGClass.getDeclaredMethod("makePublic", new Class[0]);
        Method _makeConstructorsPublic = this._DGClass.getDeclaredMethod("makeConstructorsPublic", new Class[0]);
        Method _makeFieldPublic = this._DGClass.getDeclaredMethod("makeFieldPublic", String.class);
        Method _write = this._DGClass.getDeclaredMethod("write", OutputStream.class);

        private ClassLoader getClassLoader() throws Exception {
            StringBuilder pbJarPathBuilder = new StringBuilder();
            String bootstrapHome = System.getProperty("introscope.agent.bootstrap.home");
            if (bootstrapHome == null || bootstrapHome.trim().equals("null")) {
                pbJarPathBuilder.append(this.getNonBootstrapProbeBuilderPath());
            } else {
                pbJarPathBuilder.append(bootstrapHome);
                pbJarPathBuilder.append(File.separator);
                pbJarPathBuilder.append("releases");
                pbJarPathBuilder.append(File.separator);
                pbJarPathBuilder.append(System.getProperty("introscope.agent.bootstrap.version.loaded"));
                pbJarPathBuilder.append(File.separator);
            }
            pbJarPathBuilder.append("core");
            pbJarPathBuilder.append(File.separator);
            pbJarPathBuilder.append("ext");
            pbJarPathBuilder.append(File.separator);
            pbJarPathBuilder.append("ProbeBuilder.jar");
            String pbJarPathString = pbJarPathBuilder.toString();
            try {
                File pbFile = new File(pbJarPathString);
                if (pbFile.exists()) {
                    URL[] urls = new URL[]{pbFile.toURI().toURL()};
                    return new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
                }
                throw new Exception("Invalid Probe builder jar location: " + pbJarPathString);
            }
            catch (Exception e) {
                SocketCFT.logMessage("Error in creating classloader " + e);
                throw e;
            }
        }

        private String getNonBootstrapProbeBuilderPath() {
            String PATH_PREFIX_FILE = "file:/";
            URL url = SocketCFT.class.getResource("SocketCFT.class");
            if (url == null) {
                return null;
            }
            String urlPath = url.getPath();
            try {
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            int index = urlPath.indexOf("Agent.jar");
            if (index == -1) {
                return null;
            }
            String path = urlPath.substring(0, index);
            if (path.startsWith(PATH_PREFIX_FILE)) {
                path = System.getProperty("os.name").startsWith("Windows") ? path.substring(PATH_PREFIX_FILE.length()) : path.substring("file:".length());
                return path;
            }
            return null;
        }

        public byte[] modify(String className, byte[] classBytes) throws Exception {
            byte[] modifiedBytes = this.parseClassAndModifyAlt(className, classBytes);
            if (modifiedBytes != null) {
                SocketCFT.store(className, modifiedBytes);
            }
            return modifiedBytes;
        }

        private byte[] parseClassAndModifyAlt(String className, byte[] inputBytes) throws Exception {
            try {
                Object DGClassInstance = this._DGClass.getDeclaredConstructor(InputStream.class).newInstance(new ByteArrayInputStream(inputBytes));
                this._makePublic.invoke(DGClassInstance, new Object[0]);
                this._makeConstructorsPublic.invoke(DGClassInstance, new Object[0]);
                if (className.equals("java/net/SocketImpl")) {
                    this._makeFieldPublic.invoke(DGClassInstance, "socket");
                    this._makeFieldPublic.invoke(DGClassInstance, "serverSocket");
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                this._write.invoke(DGClassInstance, bos);
                return bos.toByteArray();
            }
            catch (Exception e) {
                SocketCFT.logMessage("Error modifying bytes for " + className + ". Reason: " + e);
                throw e;
            }
        }

        private byte[] parseClassAndModify(String className, byte[] inputBytes) throws Exception {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(bos);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(inputBytes));
            in.readInt();
            output.writeInt(-889275714);
            int fMinorVersion = in.readUnsignedShort();
            output.writeShort(fMinorVersion);
            int fMajorVersion = in.readUnsignedShort();
            output.writeShort(fMajorVersion);
            int constantPool_count = in.readUnsignedShort();
            output.writeShort(constantPool_count);
            Vector<Object> fConstants = new Vector<Object>(constantPool_count);
            fConstants.add(new Object());
            int i = 1;
            while (i < constantPool_count) {
                int tag = in.readUnsignedByte();
                output.writeByte(tag);
                switch (tag) {
                    case 1: {
                        String tempUTF = in.readUTF();
                        output.writeUTF(tempUTF);
                        fConstants.add(tempUTF);
                        break;
                    }
                    case 3: {
                        int tempInt = in.readInt();
                        output.writeInt(tempInt);
                        fConstants.add(tempInt);
                        break;
                    }
                    case 4: {
                        float tempFloat = in.readFloat();
                        output.writeFloat(tempFloat);
                        fConstants.add(Float.valueOf(tempFloat));
                        break;
                    }
                    case 5: {
                        long tempLong = in.readLong();
                        output.writeLong(tempLong);
                        fConstants.add(tempLong);
                        fConstants.add(new Object());
                        ++i;
                        break;
                    }
                    case 6: {
                        double tempDouble = in.readDouble();
                        output.writeDouble(tempDouble);
                        fConstants.add(tempDouble);
                        fConstants.add(new Object());
                        ++i;
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 16: {
                        int tempShort = in.readUnsignedShort();
                        output.writeShort(tempShort);
                        fConstants.add(tempShort);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 18: {
                        int temp1 = in.readUnsignedShort();
                        int temp2 = in.readUnsignedShort();
                        output.writeShort(temp1);
                        output.writeShort(temp2);
                        Vector<Integer> tempV = new Vector<Integer>();
                        tempV.add(temp1);
                        tempV.add(temp2);
                        fConstants.add(tempV);
                        break;
                    }
                    case 15: {
                        int temp1 = in.readUnsignedByte();
                        int temp2 = in.readUnsignedShort();
                        output.writeByte(temp1);
                        output.writeByte(temp2);
                        Vector<Integer> tempV = new Vector();
                        tempV.add(temp1);
                        tempV.add(temp2);
                        fConstants.add(tempV);
                        break;
                    }
                    default: {
                        throw new Exception("Exception Parsing Constant pool ");
                    }
                }
                ++i;
            }
            int fAccessFlags = in.readUnsignedShort();
            fAccessFlags = this.makePublic(fAccessFlags);
            output.writeShort(fAccessFlags);
            output.writeShort(in.readUnsignedShort());
            output.writeShort(in.readUnsignedShort());
            int interface_count = in.readUnsignedShort();
            output.writeShort(interface_count);
            int i2 = 0;
            while (i2 < interface_count) {
                output.writeShort(in.readUnsignedShort());
                ++i2;
            }
            int fieldCount = in.readUnsignedShort();
            output.writeShort(fieldCount);
            int i3 = 0;
            while (i3 < fieldCount) {
                int field_fAccessFlags = in.readUnsignedShort();
                int name_index = in.readUnsignedShort();
                if (className.equals("java/net/SocketImpl")) {
                    try {
                        String fieldName = (String)fConstants.get(name_index);
                        if (fieldName.equals("socket") || fieldName.equals("serverSocket")) {
                            field_fAccessFlags = this.makePublic(field_fAccessFlags);
                        }
                    }
                    catch (Exception e) {
                        SocketCFT.logMessage("Error in setting field access: " + e);
                    }
                }
                output.writeShort(field_fAccessFlags);
                output.writeShort(name_index);
                output.writeShort(in.readUnsignedShort());
                int attributeCount = in.readUnsignedShort();
                output.writeShort(attributeCount);
                int j = 0;
                while (j < attributeCount) {
                    int cpi_name = in.readUnsignedShort();
                    output.writeShort(cpi_name);
                    int dataSize = in.readInt();
                    output.writeInt(dataSize);
                    byte[] data = new byte[dataSize];
                    in.readFully(data);
                    output.write(data);
                    ++j;
                }
                ++i3;
            }
            int methodCount = in.readUnsignedShort();
            output.writeShort(methodCount);
            int i4 = 0;
            while (i4 < methodCount) {
                int field_fAccessFlags = in.readUnsignedShort();
                int name_index = in.readUnsignedShort();
                try {
                    String methodName = (String)fConstants.get(name_index);
                    if (methodName.equals("<clinit>") || methodName.equals("<init>")) {
                        field_fAccessFlags = this.makePublic(field_fAccessFlags);
                    }
                }
                catch (Exception e) {
                    SocketCFT.logMessage("Error in getting constructor ..: " + e);
                }
                output.writeShort(field_fAccessFlags);
                output.writeShort(name_index);
                output.writeShort(in.readUnsignedShort());
                int attributeCount = in.readUnsignedShort();
                output.writeShort(attributeCount);
                int j = 0;
                while (j < attributeCount) {
                    int cpi_name = in.readUnsignedShort();
                    output.writeShort(cpi_name);
                    int dataSize = in.readInt();
                    output.writeInt(dataSize);
                    byte[] data = new byte[dataSize];
                    in.readFully(data);
                    output.write(data);
                    ++j;
                }
                ++i4;
            }
            output.write(this.readAllBytes(in));
            return bos.toByteArray();
        }

        private byte[] readAllBytes(InputStream is) throws IOException {
            byte[] buf = new byte[8192];
            int capacity = buf.length;
            int nread = 0;
            while (true) {
                int n;
                if ((n = is.read(buf, nread, capacity - nread)) > 0) {
                    nread += n;
                    continue;
                }
                if (n < 0) break;
                if (capacity <= 0x7FFFFFF7 - capacity) {
                    capacity <<= 1;
                } else {
                    if (capacity == 0x7FFFFFF7) {
                        throw new OutOfMemoryError("Required array size too large");
                    }
                    capacity = 0x7FFFFFF7;
                }
                buf = Arrays.copyOf(buf, capacity);
            }
            return capacity == nread ? buf : Arrays.copyOf(buf, nread);
        }

        private int makePublic(int fAccessFlags) {
            if ((fAccessFlags & 1) == 0) {
                if ((fAccessFlags & 2) != 0) {
                    fAccessFlags ^= 2;
                } else if ((fAccessFlags & 4) != 0) {
                    fAccessFlags ^= 4;
                }
                fAccessFlags |= 1;
            }
            return fAccessFlags;
        }
    }
}

