/*
 * Decompiled with CFR 0.152.
 */
package com.wily.net;

import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.net.AgentSocketOutputStream;
import java.io.IOException;
import java.net.AbstractPlainSocketImpl;
import java.net.SocketOutputStream;

public final class ManagedSocketOutputStreamAPSIHighPerformance
extends SocketOutputStream {
    private final AgentSocketOutputStream agentSocketOutputStream = new AgentSocketOutputStream();

    public ManagedSocketOutputStreamAPSIHighPerformance(AbstractPlainSocketImpl impl) throws IOException {
        super(impl);
        this.agentSocketOutputStream.setCache(impl.socket);
    }

    public final void write(int b) throws IOException {
        if (this.agentSocketOutputStream.getCache() == null || this.checkWithOverheadMgr()) {
            super.write(b);
            return;
        }
        int addedToAppMap = 0;
        boolean addedConcurrentWriter = this.agentSocketOutputStream.addToConcurrentWriters("write(int )");
        if (this.agentSocketOutputStream.getCache().isClientConnection()) {
            this.agentSocketOutputStream.annotateBlameStack();
            addedToAppMap = this.agentSocketOutputStream.addToAppMap("write(int )");
            this.agentSocketOutputStream.suggestStackTraceRecording();
        }
        try {
            super.write(b);
            this.agentSocketOutputStream.addToOutputBandwidth(1);
        }
        finally {
            this.agentSocketOutputStream.removeFromAppMap(addedToAppMap, "write(int )");
            this.agentSocketOutputStream.removeFromConcurrentWriters(addedConcurrentWriter, "write(int )");
        }
    }

    public final void write(byte[] b) throws IOException {
        if (this.agentSocketOutputStream.getCache() == null || this.checkWithOverheadMgr()) {
            super.write(b);
            return;
        }
        int addedToAppMap = 0;
        boolean addedConcurrentWriter = this.agentSocketOutputStream.addToConcurrentWriters("write(byte )");
        if (this.agentSocketOutputStream.getCache().isClientConnection()) {
            this.agentSocketOutputStream.annotateBlameStack();
            addedToAppMap = this.agentSocketOutputStream.addToAppMap("write(byte )");
            this.agentSocketOutputStream.suggestStackTraceRecording();
        }
        try {
            super.write(b);
            if (b != null) {
                this.agentSocketOutputStream.addToOutputBandwidth(b.length);
            }
        }
        finally {
            this.agentSocketOutputStream.removeFromAppMap(addedToAppMap, "write(byte )");
            this.agentSocketOutputStream.removeFromConcurrentWriters(addedConcurrentWriter, "write(byte )");
        }
    }

    public final void write(byte[] b, int off, int len) throws IOException {
        if (this.agentSocketOutputStream.getCache() == null || this.checkWithOverheadMgr()) {
            super.write(b, off, len);
            return;
        }
        int addedToAppMap = 0;
        boolean addedConcurrentWriter = this.agentSocketOutputStream.addToConcurrentWriters("write(byte, int, int)");
        if (this.agentSocketOutputStream.getCache().isClientConnection()) {
            this.agentSocketOutputStream.annotateBlameStack();
            addedToAppMap = this.agentSocketOutputStream.addToAppMap("write(byte, int, int)");
            this.agentSocketOutputStream.suggestStackTraceRecording();
        }
        try {
            super.write(b, off, len);
            this.agentSocketOutputStream.addToOutputBandwidth(len);
        }
        finally {
            this.agentSocketOutputStream.removeFromAppMap(addedToAppMap, "write(byte, int, int)");
            this.agentSocketOutputStream.removeFromConcurrentWriters(addedConcurrentWriter, "write(byte, int, int)");
        }
    }

    private boolean checkWithOverheadMgr() {
        return OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND == OverheadAdministrator.getOverheadMode() || OverheadMode.ABSOLUTE_LOW == OverheadAdministrator.getOverheadMode();
    }
}

